// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbdfptr.h 
// Compiler Used: MSVC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer    
// File Creation Date: 02/04/1997 
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The VBD file pointer routines are a collection of classes and
standalone functions used to define the underlying file system
used by the VBD file manager. NOTE: None of the data structures
and functions defined here are intended to be used directly. They
are used by the vbDatabase class to call the correct native file
API function for each supported platform.
*/
// ----------------------------------------------------------- //  
#ifndef __VBD_FILE_POINTER_HPP__
#define __VBD_FILE_POINTER_HPP__

// Non-platform specific include files
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "vbdtypes.h"
#include "vbheader.h"

// VBD file pointer type
struct vbdFPTR {
  FILE *fptr;
};

// NOTE: Any underlying file system used must provide the basic
// functionallity defined here.
vbdFPTR *vbdFPTRCreate(const char *fname);
vbdFPTR *vbdFPTROpen(const char *fname, vbDatabaseAccessMode mode);
int vbdFPTRClose(vbdFPTR *stream);
int vbdFPTRFlush(vbdFPTR *stream);
int vbdFPTRRead(vbdFPTR *stream, void *buf, __UWORD__ bytes);
int vbdFPTRWrite(vbdFPTR *stream, const void *buf, __UWORD__ bytes);
__LWORD__ vbdFPTRSeek(vbdFPTR *stream, __LWORD__, vbDatabaseSeekMode mode);
__LWORD__ vbdFPTRTell(vbdFPTR *stream);
int vbdFPTRExists(const char *fname);
__LWORD__ vbdFPTRFileSize(const char *fname);

#endif // __VBD_FILE_POINTER_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
