// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbstream.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/12/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The VBStream class is used to stream data from a client to a 
server over a TCP/IP connection.
*/
// ----------------------------------------------------------- //   
#ifndef __VBSTREAM_HPP__
#define __VBSTREAM_HPP__

#include "vbsocket.h"
#include "vbheader.h"

class vbStream : public vbSocket
{
public:
  vbStream() { }
  ~vbStream() { }

public: // Client/Server configuration
  int StreamServer(int port, int max_connections = SOMAXCONN);
  int StreamClient(int port, char *host);
  int PortNumber(int &port);
  int RemotePortNumber(int &port);
  int HostName(char *hs);
  int RemoteHostName(char *hs);
  
public: // High-level variable block functions
  int WriteBlock(const void *buf, int bytes);
  int TerminateConnection();
  int CloseConnection();
  int ReadClientHeader(vbBlockHeader &vbs);
  int ReadRemoteBlock(void *buf, vbBlockHeader &vb);
  int WriteRemoteBlock(void *buf, int bytes);
  void *RequestBlock(const void *request, vbBlockHeader &request_header, 
		      vbBlockHeader &requested_block_header);
  int AddBlock(const void *block, vbBlockHeader &block_header);
  int ChangeBlock(const void *request, const void *block, 
		  vbBlockHeader &request_header, vbBlockHeader &block_header);
  int DeleteBlock(const void *request, vbBlockHeader &request_header);
  int WriteAckBlock();
  int WriteRemoteAckBlock();
  int ReadAckBlock();
  int ReadRemoteAckBlock();
  
public: // Low-level variable block functions
  void SetBlockStatus(vbBlockHeader &vb, __SBYTE__ net_status,
		      __SBYTE__ file_status = vbRemoteDeviceBlock);
  int WriteBlock(vbsSocket_t s, const void *buf, int bytes);
  int WriteBlock(vbsSocket_t s, const void *buf, vbBlockHeader &vb);
  int WriteHeader(vbsSocket_t s, vbBlockHeader &vb);
  int ReadBlock(vbsSocket_t s, void *buf, vbBlockHeader &vb);
  int ReadHeader(vbsSocket_t s, vbBlockHeader &vb);
  void *RequestBlock(vbsSocket_t s, const void *request,
		     vbBlockHeader &request_header, 
		     vbBlockHeader &requested_block_header);
  int AddBlock(vbsSocket_t s, const void *block, vbBlockHeader &block_header);
  int DeleteBlock(vbsSocket_t s, const void *request,
		  vbBlockHeader &request_header);
  int ChangeBlock(vbsSocket_t s, const void *request, 
		  const void *block, vbBlockHeader &request_header,
		  vbBlockHeader &block_header);
  int WriteAckBlock(vbsSocket_t s);
  int ReadAckBlock(vbsSocket_t s);
  int TerminateConnection(vbsSocket_t s);
  int CloseConnection(vbsSocket_t s);
};

#endif // __VBSTREAM_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
