// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: vbsema.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/11/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Semaphore synchronization class implemented using condition variables
and a mutually exclusive integer variable. Typically, an application
uses a semaphore to limit the number of threads using a resource by
causing a thread to stop and wait until another thread signals that it
has arrived at a certain place in the entry function.
*/
// ----------------------------------------------------------- //   
#include "vbsema.h"

vbSemaphore::vbSemaphore(vbProcessType type)
{
  SemaphoreInit(type);
}

vbSemaphore::~vbSemaphore()
{
  SemaphoreDestroy();
}

int vbSemaphore::SemaphoreInit(vbProcessType type)
// Initialize the semaphore. Returns a non-zero value if
// any errors occur.
{
  if(vbThreadSemaphoreInit(&semaphore, type) != 0) return 1;
  return 0;
}

int vbSemaphore::SemaphoreDestroy()
// Destroy the semaphore. Returns a non-zero value if
// any errors occur.
{
  return vbThreadSemaphoreDestroy(&semaphore);
}

int vbSemaphore::SemaphoreWait()
// Decrement the semaphore and block if the semaphore
// value is zero until another thread signals a change.
// Returns a non-zero value if any errors occur.
{
  return vbThreadSemaphoreWait(&semaphore);
}

int vbSemaphore::SemaphorePost()
// Increments the semaphore and signals any threads that are blocked.
// Returns a non-zero value if any errors occur.
{
  return vbThreadSemaphorePost(&semaphore);
}

int vbSemaphore::SemaphoreDecrement()
// vbSemaphore::SemaphoreDecrement() is a non-blocking function
// that decrements the value of the semaphore. It allows threads
// to decrement the semaphore to some negative value as part of
// an initialization process. Decrements allow multiple threads
// to move up on a semaphore before another thread can go down.
// Returns a non-zero value if any errors occur.
{
  return vbThreadSemaphoreIncrement(&semaphore);
}

int vbSemaphore::SemaphoreIncrement()
// vbSemaphore::SemaphoreIncrement() is a non-blocking function
// that increments the value of the semaphore. Returns a non-zero
// value if any errors occur.
{
  return vbThreadSemaphoreIncrement(&semaphore);
}

int vbSemaphore::SemaphoreValue()
// Returns the value of the semaphore at the time the
// critical section is accessed. NOTE: The value may
// change after the function unlocks the critical
// section.
{
  return vbThreadSemaphoreValue(&semaphore);
}

const char *vbSemaphore::SemaphoreExceptionMessage()
// Returns a null termainated string that can
// be use to log or print a semaphore execption.
{
  return vbThreadSemaphoreExceptionMessage(&semaphore);
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
