// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbdbase.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer    
// File Creation Date: 02/04/1997 
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbDatabase class defines low-level methods used to build
embedded database systems based on variable block technology.
*/
// ----------------------------------------------------------- //  
#ifndef __VB_DATABASE_HPP__
#define __VB_DATABASE_HPP__

#include "vbdfptr.h"
#include "vbcrc32.h"
#include "vbderror.h"

class vbDatabase
{
public:
  vbDatabase();
  virtual ~vbDatabase();

private:
  // Disallow copying and assignment to prevent multiple copies of
  // database objects. Forcing pointer semantics to helps to ensure
  // the safe deletion or modification of a database object.
  vbDatabase(const vbDatabase &ob) { }
  void operator=(const vbDatabase &ob) { }

public: // Database functions
  virtual vbDatabaseError Create(const char *fname, FAU static_size = 0L,
			 __SBYTE__ RevisionLetter = vbDatabaseRevisionLetter);
  virtual vbDatabaseError Open(const char *fname, 
			       vbDatabaseAccessMode mode = vbDBASE_READWRITE);
  virtual vbDatabaseError Close();
  virtual vbDatabaseError Flush();
  vbDatabaseError Read(void *buf, __ULWORD__ bytes, 
		       FAU file_address = vbCurrAddress);
  vbDatabaseError Write(const void *buf, __ULWORD__ bytes, 
			FAU file_address = vbCurrAddress,
			int flush = 1, int bit_test = 1);
  vbDatabaseError Seek(FAU offset, vbDatabaseSeekMode mode = vbDBASE_SEEK_BEG);
  FAU SeekTo(FAU file_address);
  vbStreamPos FilePosition();
  
public: // Allocation/Deallocation functions
  virtual FAU Alloc(__ULWORD__ bytes,
		    vbDatabaseReclaimMethod method = vbDBASE_RECLAIM_FIRSTFIT);
  FAU ReclaimBestFit(__ULWORD__ bytes);
  FAU ReclaimFirstFit(__ULWORD__ bytes);
  int Delete(FAU object_address, int remove = 0); 
  int Remove(FAU object_address);
  int UnDelete(FAU object_address);

protected: // Internal processing fucntions
  vbDatabaseError InitFileHdr();
  
public: // Functions used to calculate file offsets
  size_t FileHeaderSize() const;
  size_t FileHeaderSize(); 
  size_t VBHeaderSize() const;
  size_t VBHeaderSize();
  __ULWORD__ ObjectLength(FAU object_address = vbCurrAddress);
  __ULWORD__ VBLength(FAU object_address = vbCurrAddress);

public:  // File Status functions
  int IsOK() { return ((is_ok == 1) && (is_open == 1)); }
  int IsOK() const { return ((is_ok == 1) && (is_open == 1)); }
  int IsOpen() { return ((is_ok == 1) && (is_open == 1)); }
  int IsOpen() const { return ((is_ok == 1) && (is_open == 1)); }
  int ReadForReading() const { return ready_for_reading == 1; }
  int ReadForReading() { return ready_for_reading == 1; }
  int ReadyForWriting() const { return ready_for_writing == 1; }
  int ReadyForWriting() { return ready_for_writing == 1; }

public: // File and block header functions
  vbDatabaseError ReadFileHdr();
  vbDatabaseError WriteFileHdr();
  vbDatabaseError ReadBlockHdr(vbBlockHeader &hdr, 
			       FAU block_address = vbCurrAddress);
  vbDatabaseError WriteBlockHdr(const vbBlockHeader &hdr, 
				FAU block_address = vbCurrAddress);

public:  // Exception handling functions
  vbDatabaseError GetDatabaseError() { return vbd_error; }
  vbDatabaseError GetDatabaseError() const { return vbd_error; }
  void SetDatabaseError(vbDatabaseError err) { vbd_error = err; }
  void ResetDatabaseError() { vbd_error = vbDBASE_NO_ERROR; }
  const char *DatabaseExceptionMessage();

public: // Static file statistics
  const char *GetSignature() const;
  char *GetSignature();
  char GetRevLetter() { return rev_letter; }
  const char GetRevLetter() const { return rev_letter; }
  vbINT32 GetVersion() const { return file_header.vbd_ver; }
  vbINT32 GetVersion() { return file_header.vbd_ver; }
  const char *vbDatabaseName() const { return (const char *)file_name; }
  char *vbDatabaseName() { return file_name; }
  FAU StaticArea();
    
public: // Dynamic file statistics
  FAU GetVBDFreeSpace();
  FAU GetEOF();
  FAU GetHeapStart();
  FAU GetHighestVB();
  __ULWORD__ VBDeleted(__ULWORD__ *d = 0, __ULWORD__ *r = 0);
  int TestVBDHeader();  // Keeps VBD file header's dynamic data in sync
  __ULWORD__ VBTotal();  // Return total number of Variable Blocks

public: // Linear navigation methods
  FAU FindFirstVB(FAU offset = 0L);     // Finds first valid Variable Block
  FAU FindPrevVB(FAU offset);           // Finds the previous block 
  FAU FindNextVB(FAU offset = 0L);      // Finds next after first 
  FAU FindFirstObject(FAU offset = 0L); // Finds first object address
  FAU FindPrevObject(FAU offset);       // Finds the previous object 
  FAU FindNextObject(FAU offset = 0L);  // Finds next object after first 
  
public: // General purpose file utilities
  static int Exists(const char *fname);
  static FAU FileSize(const char *fname);
  
public: // Revision letter functions
  void SetRevisionLetter(__SBYTE__ RevisionLetter);

public: // 32-bit CRC checksum routines (revision A and higher)
  __ULWORD__ CalcChecksum(__ULWORD__ bytes, FAU file_address, 
			  int mem_alloc = 1);
  vbUINT32 WriteObjectChecksum(FAU object_address);
  int ReadObjectChecksum(FAU object_address, __ULWORD__ *object_crc = 0,
			 __ULWORD__ *calc_crc = 0);

public: // File lock functions (revision B and higher)
  void InitFileLockHdr(vbFileLockHeader &hdr);
  vbDatabaseError ResetFileLock();
  vbDatabaseError WriteFileLockHdr(const vbFileLockHeader &hdr);
  vbDatabaseError ReadFileLockHdr(vbFileLockHeader &hdr);
  int LockFile(vbDatabaseLockType l_type = vbDBASE_WRITELOCK);
  int UnlockFile(vbDatabaseLockType l_type = vbDBASE_WRITELOCK);

public: // Record lock functions (revision C and higher)
  void InitRecordLockHdr(vbRecordLockHeader &hdr);
  vbDatabaseError ResetRecordLock(FAU block_address = vbCurrAddress);
  vbDatabaseError ReadRecordLockHdr(vbRecordLockHeader &hdr, 
				    FAU block_address = vbCurrAddress);
  vbDatabaseError WriteRecordLockHdr(const vbRecordLockHeader &hdr, 
				     FAU block_address = vbCurrAddress);
  int LockRecord(vbDatabaseLockType l_type = vbDBASE_WRITELOCK,
		 FAU block_address = vbCurrAddress);
  int UnlockRecord(vbDatabaseLockType l_type = vbDBASE_WRITELOCK,
		   FAU block_address = vbCurrAddress);

protected:
  char file_name[vbMaxNameLength];    // Open database file name
  char rev_letter;                    // VBD revision letter
  vbFileHeader file_header;           // Database file header
  vbdFPTR *fp;                        // Stream file handle
  vbDatabaseOperation last_operation; // Last I/O operation preformed
  vbDatabaseError vbd_error;          // Last reported file error

  // File status members
  int is_ok;             // Used to signal a fatal error condition
  int is_open;           // True if the file is open
  int ready_for_reading; // True if the file is ready for reading
  int ready_for_writing; // True if the file is ready for writing

public: // Static data members used in place of global variables
  static __SBYTE__ VBDSignature[8];     // Signature for VBD files
  static FAU VBDVersion;                // Version number VBD files
  static vbUINT32 VBDInternalCheckWord; // 32-bit synchronization word

public: // Overloaded operators
  int operator!() const { return ((is_ok == 1) && (is_open == 1)); }
  int operator!() { return ((is_ok == 1) && (is_open == 1)); }
  operator const int () const { return ((is_ok == 1) && (is_open == 1)); }
  operator int () { return ((is_ok == 1) && (is_open == 1)); }
};

#endif // __VB_DATABASE_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
