// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbd64.h 
// Compiler Used: MSVC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer    
// File Creation Date: 02/04/1997 
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbDatabase64 class defines low-level methods used to build
embedded database systems based on variable block technology.
*/
// ----------------------------------------------------------- //  
#ifndef __VB_DATABASE_64_HPP__
#define __VB_DATABASE_64_HPP__

#include "vbdfp64.h"
#include "vbcrc32.h"
#include "vbderror.h"

class vbDatabase64
{
public:
  vbDatabase64();
  virtual ~vbDatabase64();

private:
  // Disallow copying and assignment to prevent multiple copies of
  // database objects. Forcing pointer semantics to helps to ensure
  // the safe deletion or modification of a database object.
  vbDatabase64(const vbDatabase64 &ob) { }
  void operator=(const vbDatabase64 &ob) { }

public: // Database functions
  virtual vbDatabaseError Create(const char *fname,
				 FAU64 static_size = (__LLWORD__)0,
			 __SBYTE__ RevisionLetter = vbDatabaseRevisionLetter);
  virtual vbDatabaseError Open(const char *fname, 
			       vbDatabaseAccessMode mode = vbDBASE_READWRITE);
  virtual vbDatabaseError Close();
  virtual vbDatabaseError Flush();
  vbDatabaseError Read(void *buf, __ULWORD__ bytes, 
		       FAU64 file_address = vbCurrAddress64);
  vbDatabaseError Write(const void *buf, __ULWORD__ bytes, 
			FAU64 file_address = vbCurrAddress64,
			int flush = 1, int bit_test = 1);
  vbDatabaseError Seek(FAU64 offset,
		       vbDatabaseSeekMode mode = vbDBASE_SEEK_BEG);
  FAU64 SeekTo(FAU64 file_address);
  vbStreamPos64 FilePosition();
  
public: // Allocation/Deallocation functions
  virtual FAU64 Alloc(__ULWORD__ bytes,
		    vbDatabaseReclaimMethod method = vbDBASE_RECLAIM_FIRSTFIT);
  FAU64 ReclaimBestFit(__ULWORD__ bytes);
  FAU64 ReclaimFirstFit(__ULWORD__ bytes);
  int Delete(FAU64 object_address, int remove = 0); 
  int Remove(FAU64 object_address);
  int UnDelete(FAU64 object_address);

protected: // Internal processing fucntions
  vbDatabaseError InitFileHdr();
  
public: // Functions used to calculate file offsets
  size_t FileHeaderSize() const;
  size_t FileHeaderSize(); 
  size_t VBHeaderSize() const;
  size_t VBHeaderSize();
  __ULWORD__ ObjectLength(FAU64 object_address = vbCurrAddress64);
  __ULWORD__ VBLength(FAU64 object_address = vbCurrAddress64);

public:  // File Status functions
  int IsOK() { return ((is_ok == 1) && (is_open == 1)); }
  int IsOK() const { return ((is_ok == 1) && (is_open == 1)); }
  int IsOpen() { return ((is_ok == 1) && (is_open == 1)); }
  int IsOpen() const { return ((is_ok == 1) && (is_open == 1)); }
  int ReadForReading() const { return ready_for_reading == 1; }
  int ReadForReading() { return ready_for_reading == 1; }
  int ReadyForWriting() const { return ready_for_writing == 1; }
  int ReadyForWriting() { return ready_for_writing == 1; }

public: // File and block header functions
  vbDatabaseError ReadFileHdr();
  vbDatabaseError WriteFileHdr();
  vbDatabaseError ReadBlockHdr(vbBlockHeader64 &hdr, 
			       FAU64 block_address = vbCurrAddress64);
  vbDatabaseError WriteBlockHdr(const vbBlockHeader64 &hdr, 
				FAU64 block_address = vbCurrAddress64);

public:  // Exception handling functions
  vbDatabaseError GetDatabaseError() { return vbd_error; }
  vbDatabaseError GetDatabaseError() const { return vbd_error; }
  void SetDatabaseError(vbDatabaseError err) { vbd_error = err; }
  void ResetDatabaseError() { vbd_error = vbDBASE_NO_ERROR; }
  const char *DatabaseExceptionMessage();

public: // Static file statistics
  const char *GetSignature() const;
  char *GetSignature();
  char GetRevLetter() { return rev_letter; }
  const char GetRevLetter() const { return rev_letter; }
  FAU64 GetVersion() const { return file_header.vbd_ver; }
  FAU64 GetVersion() { return file_header.vbd_ver; }
  const char *vbDatabaseName() const { return (const char *)file_name; }
  char *vbDatabaseName() { return file_name; }
  FAU64 StaticArea();
    
public: // Dynamic file statistics
  FAU64 GetVBDFreeSpace();
  FAU64 GetEOF();
  FAU64 GetHeapStart();
  FAU64 GetHighestVB();
  __ULWORD__ VBDeleted(__ULWORD__ *d = 0, __ULWORD__ *r = 0);
  int TestVBDHeader();  // Keeps VBD file header's dynamic data in sync
  __ULWORD__ VBTotal();  // Return total number of Variable Blocks

public: // Linear navigation methods
  FAU64 FindFirstVB(FAU64 offset = (__LLWORD__)0);     // Finds first block
  FAU64 FindPrevVB(FAU64 offset);                      // Finds prev block 
  FAU64 FindNextVB(FAU64 offset = (__LLWORD__)0);      // Finds next block  
  FAU64 FindFirstObject(FAU64 offset = (__LLWORD__)0); // Finds first object
  FAU64 FindPrevObject(FAU64 offset);                  // Finds prev object 
  FAU64 FindNextObject(FAU64 offset = (__LLWORD__)0);  // Finds next object
  
public: // General purpose file utilities
  static int Exists(const char *fname);
  static FAU64 FileSize(const char *fname);
  
public: // Revision letter functions
  void SetRevisionLetter(__SBYTE__ RevisionLetter);

public: // 32-bit CRC checksum routines (revision A and higher)
  __ULWORD__ CalcChecksum(__ULWORD__ bytes, FAU64 file_address, 
			  int mem_alloc = 1);
  vbUINT32 WriteObjectChecksum(FAU64 object_address);
  int ReadObjectChecksum(FAU64 object_address, __ULWORD__ *object_crc = 0,
			 __ULWORD__ *calc_crc = 0);

public: // File lock functions (revision B and higher)
  void InitFileLockHdr(vbFileLockHeader &hdr);
  vbDatabaseError ResetFileLock();
  vbDatabaseError WriteFileLockHdr(const vbFileLockHeader &hdr);
  vbDatabaseError ReadFileLockHdr(vbFileLockHeader &hdr);
  int LockFile(vbDatabaseLockType l_type = vbDBASE_WRITELOCK);
  int UnlockFile(vbDatabaseLockType l_type = vbDBASE_WRITELOCK);

public: // Record lock functions (revision C and higher)
  void InitRecordLockHdr(vbRecordLockHeader &hdr);
  vbDatabaseError ResetRecordLock(FAU64 block_address = vbCurrAddress64);
  vbDatabaseError ReadRecordLockHdr(vbRecordLockHeader &hdr, 
				    FAU64 block_address = vbCurrAddress64);
  vbDatabaseError WriteRecordLockHdr(const vbRecordLockHeader &hdr, 
				     FAU64 block_address = vbCurrAddress64);
  int LockRecord(vbDatabaseLockType l_type = vbDBASE_WRITELOCK,
		 FAU64 block_address = vbCurrAddress64);
  int UnlockRecord(vbDatabaseLockType l_type = vbDBASE_WRITELOCK,
		   FAU64 block_address = vbCurrAddress64);

protected:
  char file_name[vbMaxNameLength];    // Open database file name
  char rev_letter;                    // VBD revision letter
  vbFileHeader64 file_header;         // Database file header
  vbdFPTR64 *fp;                      // Stream file handle
  vbDatabaseOperation last_operation; // Last I/O operation preformed
  vbDatabaseError vbd_error;          // Last reported file error

  // File status members
  int is_ok;             // Used to signal a fatal error condition
  int is_open;           // True if the file is open
  int ready_for_reading; // True if the file is ready for reading
  int ready_for_writing; // True if the file is ready for writing

public: // Static data members used in place of global variables
  static __SBYTE__ VBD64Signature[10];    // Signature for VBD files
  static FAU64 VBD64Version;              // Version number VBD files
  static vbUINT32 VBD64InternalCheckWord; // 32-bit synchronization word

public: // Overloaded operators
  int operator!() const { return ((is_ok == 1) && (is_open == 1)); }
  int operator!() { return ((is_ok == 1) && (is_open == 1)); }
  operator const int () const { return ((is_ok == 1) && (is_open == 1)); }
  operator int () { return ((is_ok == 1) && (is_open == 1)); }
};

#endif // __VB_DATABASE_64_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
