// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 08/07/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the FLOAT64 class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdio.h>
#include "vbfloat.h"

const __DPFLOAT__ DPFLOATPositiveLimit = 1.7E+308; // (15 digit precision)
const __DPFLOAT__ DPFLOATNegitiveLimit = 1.7E-308; // (15 digit precision)

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

void SkipToEol(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

void FWrite(char *fname)
{
  vbFLOAT64 aa = 3.141592653589793; // Arc cosine of -1 equals pi
  cout.precision(15);  // Show 15 places after the decimal point 
  cout.setf(ios::fixed | ios::right); // Normal FP notation right justified
  cout << "Writing a vbFLOAT64 value " << aa << " to a file..." << endl;

#ifndef __BCC_BUILDER_40__
  // Do not synchronize with stdio under BCC32
  ios::sync_with_stdio();
#endif
  
  FILE *stream;
  int numwritten;

  /* Open file in binary mode: */
  if((stream = fopen( fname, "w+b" )) != NULL )
    {
      numwritten = fwrite((char *)&aa, 1, sizeof(vbFLOAT64), stream );
      printf( "Wrote %d items\n", numwritten );
      fclose( stream );
    }
  else
    printf( "Problem opening the file\n" );
}

void FRead(char *fname)
{
  vbFLOAT64 bb = 0;
#ifndef __BCC_BUILDER_40__
  // Do not synchronize with stdio under BCC32
  ios::sync_with_stdio();
#endif
  FILE *stream;
  int numread;

  cout.precision(15);  // Show 15 places after the decimal point 
  cout.setf(ios::fixed | ios::right); // Normal FP notation right justified
  cout << "Reading back vbFLOAT64 value from the file..." << endl;
  if( (stream = fopen( fname, "r+b" )) != NULL )
    {
      numread = fread((char *)&bb, 1, sizeof(vbFLOAT64), stream );
      printf( "Number of items read = %d\n", numread );
      fclose( stream );
    }
  else
    printf( "File could not be opened\n" );
  
  cout << "Value read from file = " << bb << endl;

}

template<class TYPEX, class TYPEY>
inline void OperatorTest(TYPEX x, TYPEY y)
{
  char *tf[2] = {"FALSE", "TRUE"};
  cout << endl;
  cout << "Value x = " << x << ", Value y = " << y << endl;
  TYPEX z;
  cout << x << " += " << y << " = "; z = x; z += y; cout << z << endl;
  cout << x << " -= " << y << " = "; z = x; z -= y; cout << z << endl;
  cout << x << " *= " << y << " = "; z = x; z *= y; cout << z << endl;
  cout << x << " /= " << y << " = "; z = x; z /= y; cout << z << endl;
  cout << x << " * " << y << " = " ; z = (x * y); cout << z << endl;
  cout << x << " / " << y << " = " ; z = (x / y); cout << z << endl;
  cout << x << " + " << y << " = " ; z = (x + y); cout << z << endl;
  cout << x << " - " << y << " = " ; z = (x - y); cout << z << endl;
  cout << x << " == " << y << " = " << tf[(x == y)] << endl;
  cout << x << " != " << y << " = " << tf[(x != y)] << endl;
  cout << x << " <= " << y << " = " << tf[(x <= y)] << endl;
  cout << x << " >= " << y << " = " << tf[(x >= y)] << endl;
  cout << x << " < " << y << " = " << tf[(x < y)] << endl;
  cout << x << " > " << y << " = " << tf[(x > y)] << endl;
  cout << x << "++ = "; z = x; z++; cout << z << endl;
  cout << x << "-- = "; z = x; z--; cout << z << endl; 
  cout << "++" << x << " = "; z = x; ++z; cout << z << endl;
  cout << "--" << x << " = "; z = x; --z; cout << z << endl;
}

int main()
{
  vbFLOAT64 a = DPFLOATPositiveLimit;
  cout << "vbFLOAT64 positive limit = " << a << endl;

  vbFLOAT64 b(DPFLOATNegitiveLimit);
  cout << "vbFLOAT64 negitive limit = " << b << endl;

  PausePrg();
  
  cout << "Testing vbFLOAT64 copy consturctor..." << endl;
  vbFLOAT64 c(a);
  cout << c << endl;

  cout << endl;
  cout << "Testing vbFLOAT64 assignment operator..." << endl;
  vbFLOAT64 d;
  d = a;
  cout << d << endl;

  PausePrg();

  // Reading and writing a vbFLOAT64 value to a file
  char fname[255] = "testf64.out";
  FILE *tmp; // Temporary file pointer
  tmp = ::fopen(fname, "rb");

  if(tmp) FRead(fname); else FWrite(fname);
    
  PausePrg();
  
  cout.precision(10);  // Show 10 places after the decimal point 
  cout.setf(ios::fixed | ios::right); // Normal FP notation right justified
  cout << "Testing overloaded operators (vbFLOAT64, vbFLOAT64)..." << endl;
  __DPFLOAT__ buf1, buf2, af, bf;
  
  cout << "Enter first floating point value: ";
  cin >> buf1;
  if(cin) {
    a = buf1;
    af = buf1;
    cout << "Enter second floating point value: ";
    cin >> buf2;
  }
  else {
    cout << "Input stream broken. Exiting..." << endl;
    return 0;
  }
  if(cin) {
    b = buf2;
    bf = buf2;
  }
  else {
    cout << "Input stream broken. Exiting..." << endl;
    return 0;
  }

  SkipToEol(cin);
    
  cout << endl;
  
  OperatorTest(a, b);
  
  PausePrg();

  cout << "Testing overloaded operators (vbFLOAT64, __DPFLOAT__)..." << endl;
  OperatorTest(a, bf);

  PausePrg();

  cout << "Testing overloaded operators (__DPFLOAT__, vbFLOAT64)..." << endl;
  OperatorTest(af, b);
  
  PausePrg();

  cout << "Testing overloaded operators (vbFLOAT64, __LWORD__)..." << endl;
  OperatorTest(a, (__LWORD__)bf);

  PausePrg();

  cout << "Testing overloaded operators (__LWORD__, vbFLOAT64)..." << endl;
  OperatorTest((__LWORD__)af, b);
  
  PausePrg();

  cout << "Testing overloaded operators (vbFLOAT64, __WORD__)..." << endl;
  OperatorTest(a, (__WORD__)bf);

  PausePrg();

  cout << "Testing overloaded operators (__WORD__, vbFLOAT64)..." << endl;
  OperatorTest((__WORD__)af, b);

  PausePrg();

  cout << "Testing overloaded operators (vbFLOAT64, __SWORD__)..." << endl;
  OperatorTest(a, (__SWORD__)bf);

  PausePrg();

  cout << "Testing overloaded operators (__SWORD__, vbFLOAT64)..." << endl;
  OperatorTest((__SWORD__)af, b);

  PausePrg();
  
  cout << "Testing overloaded operators (vbFLOAT64, __UWORD__)..." << endl;
  OperatorTest(a, (__UWORD__)bf);

  PausePrg();

  cout << "Testing overloaded operators (__UWORD__, vbFLOAT64)..." << endl;
  OperatorTest((__UWORD__)af, b);

  PausePrg();

  cout << "Testing overloaded operators (vbFLOAT64, __USWORD__)..." << endl;
  OperatorTest(a, (__USWORD__)bf);

  PausePrg();

  cout << "Testing overloaded operators (__USWORD__, vbFLOAT64)..." << endl;
  OperatorTest((__USWORD__)af, b);

  PausePrg();
  
  cout << "Testing overloaded operators (vbFLOAT64, __SBYTE__)..." << endl;
  OperatorTest(a, 'B');

  PausePrg();

  cout << "Testing overloaded operators (__SBYTE__, vbFLOAT64)..." << endl;
  OperatorTest('A', b);

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
