// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer 
// File Creation Date: 02/04/1997  
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

vbDatabase linear navigation test.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include "vbdbase.h"
#include "vbfloat.h"
#include "vbstat32.h"

const int name_length = 16;

class DatabaseObject
{ 
public:
  DatabaseObject() { name[0] = 0; oid = (vbINT32)0, cid = (vbFLOAT64)0; }
  DatabaseObject(const char *s, long i, double d);

public:
  friend void *operator new(size_t n, char *s, int i, double d,
			    vbDatabase *f) {
    void *ptr = new DatabaseObject(s, i, d);
    f->Write(ptr, n, f->Alloc(n));
    return ptr;
  }
  
public: // Platform independent data members
  char name[name_length]; // Fixed string type
  vbINT32 oid;            // Integer type
  vbFLOAT64 cid;          // Floating point type
};

DatabaseObject::DatabaseObject(const char *s, long i, double d)
{
  for(int j = 0; j < name_length; j++) name[j] = 0; // Clear the name string
  strcpy(name, s);
  oid = i;  
  cid = d;
}

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
// Simple demo of how to use the file manager class.
{
  vbDatabase *f = new vbDatabase;
  const char *fname = "prevnext.vbd";

  cout << endl;
  cout << "Simple navigation demo." << endl;
  cout << "Testing vb find functions..." << endl;
  const int num_to_add = 5;

  if(!vbDatabase::Exists(fname)) {
    cout << "Creating new file..." << endl;
    f->Create(fname);
    if(CheckError(f) != 0) return 1;
    cout << "Adding " << num_to_add << " objects..." << endl;
    for(long i = 0; i < num_to_add; i++)
      new("Mouse", i, 2000.101, f) DatabaseObject;
    if(CheckError(f) != 0) return 1;
  }
  else {
    cout << "Opening existing file..." << endl;
    f->Open(fname);
    if(CheckError(f) != 0) return 1;
  }

  PausePrg();
  VBDStats(f);
  PausePrg();

  cout << "Walking through the file finding all blocks..." << endl;
  FAU block_address = 0;
  while(1) {
    block_address = f->FindFirstVB(block_address);
    if(block_address == FAU(0)) break;
    cout << "Found block at file address: " << block_address << endl;
    block_address++; // Offset the block address
  }

  PausePrg();
  
  cout << "Finding all blocks in reverse order..." << endl;
  block_address = f->GetEOF();
  while(1) {
    block_address = f->FindPrevVB(block_address);
    if(block_address == FAU(0)) break;
    cout << "Found block at file address: " << block_address << endl;
    block_address++; // Offset the block address
  }

  PausePrg();

  cout << "Walking through the file finding every object..." << endl;
  FAU object_address = 0;
  while(1) {
    object_address = f->FindFirstObject(object_address);
    if(object_address == FAU(0)) break;
    cout << "Found object at file address: " << object_address << endl;
    object_address++; // Offset the block address
  }

  PausePrg();

  cout << "Finding every object in reverse order..." << endl;
  object_address = f->GetEOF();
  while(1) {
    object_address = f->FindPrevObject(object_address);
    if(object_address == FAU(0)) break;
    cout << "Found object at file address: " << object_address << endl;
    object_address++; // Offset the block address
  }
  
  cout << endl;
  cout << "Exiting..." << endl;
  f->Close();
  if(CheckError(f) != 0) return 1;
  delete f;
  return 0; 
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
