//===================================================================
// datamanp.hpp
//
// Version 1.0
//
// Written by:
//   Brent Worden
//   WordenWare
//   email:  brent.worden@poboxes.com
//
// Copyright (c) 1998-1999 WordenWare
//
// Created:  August 28, 1998
// Revised:  
//===================================================================

#ifndef _DATA_MANP_HPP_
#define _DATA_MANP_HPP_

#include "descript.hpp"

template<class T>
inline void empty(T& con)
//-------------------------------------------------------------------
// Removes all elements from the container con.
//-------------------------------------------------------------------
{
    con.erase(con.begin(), con.end());
}

template<class T>
std::vector<T> unique_values(T* first, T* last)
//-------------------------------------------------------------------
// Returns a vector containing the unique values in [first1, last1).
//-------------------------------------------------------------------
{
    std::vector<T> dest(first, last);

	sort(dest.begin(), dest.end());
    dest.erase(unique(dest.begin(), dest.end()), dest.end());
    
    return dest;
};

template<class T>
vector< pair<T, int> > frequencies(T* first, T* last)
//-------------------------------------------------------------------
// Returns a vector containing the unique values in [ffirst, flast),
// together with the frequencies with which they occur.
//-------------------------------------------------------------------
{
    vector< pair<T, int> > ret;
    vector<T> unq = unique_values(first, last);
    vector<T>::iterator iter = unq.begin();
    
    while(iter != unq.end()){
        cnt = count(first, last, *iter);
        ret.push_back(make_pair(*iter, cnt));
        ++iter;
    }
    
    return ret;
};

template<class S, class T>
vector< pair<S, vector<T> > > group(S* ffirst, S* flast, T* dfirst)
//-------------------------------------------------------------------
// Returns a vector containing the unique values in [ffirst, flast),
// together with the vector of elements from [dfirst, dfirst +
// (flast - ffirst)) in that group.
//-------------------------------------------------------------------
{
    vector< pair<S, vector<T> > > ret;
    vector<S> unq = unique_values(ffirst, flast);
    vector<S>::iterator iter = unq.begin();
    vector<T> elements;
    vector<S>::iterator found, start;
    
    while(iter != unq.end()){
        empty(elements);
        found = start = ffirst;
        while((found = find(start, flast, *iter)) != flast){
            elements.push_back(*(dfirst + (found - ffirst)));
            start = found + 1;
        }
        ret.push_back(make_pair(*iter, elements));
        ++iter;
    }

    return ret;
}

#endif

//===================================================================
// Revision History
//
// Version 1.0 - 08/28/1998 - New.
//===================================================================
