
%NOLIST
;============================================================================
;
; DRIVER.INC
; strucs/equs needed for device-driver (access)
; This file is part of the
;
; PseudoCD package (version 02)
; Copyright (C) 1997  C.Kulms
;
;   This is free software; you can redistribute it and/or modify it
;   under the terms of the GNU General Public License as published by
;   the Free Software Foundation; version 2 of the License.
;
;   This software is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this software; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;============================================================================
%LIST

;driver commands 
DRV_MEDCHK	EQU 01h ;media check
DRV_BPB		EQU 02h ;build BPB
DRV_IOCTLI	EQU 03h ;ioctl input
DRV_READ	EQU 04h ;read
DRV_NDINP	EQU 05h ;nondestructive input no wait
DRV_ISTAT	EQU 06h ;input status
DRV_IFLUSH	EQU 07h ;input flush
DRV_WRITE	EQU 08h ;write
DRV_WRITEV	EQU 09h ;write with verify
DRV_OSTAT	EQU 0Ah ;output status
DRV_OFLUSH	EQU 0Bh ;output flush
DRV_IOCTLO	EQU 0Ch ;ioctl output
DRV_OPEN	EQU 0Dh ;device open
DRV_CLOSE	EQU 0Eh ;device close
DRV_RMVMED	EQU 0Fh ;removable media
DRV_OUBUSY	EQU 10h ;output until busy

;device-driver status codes
STAT_DONE		EQU 0100h	;operation complete, successfull
STAT_BUSY		EQU 0200h	;device busy
ERR_WRITEPROT	EQU 8100h	;write protectition violation
ERR_UNKNOWNUNIT	EQU 8101h	;invalid sub-unit number in request-header
ERR_NOTREADY	EQU 8102h	;device not ready
ERR_UNKNOWNCMD	EQU 8103h	;unknown command code in request-header
ERR_CRCERROR	EQU 8104h	;crc-error
ERR_BADRQLENGTH	EQU 8105H	;bad request-header length
ERR_SEEKERROR	EQU 8106H	;seek error
ERR_UNKNOWNMED	EQU 8107H	;unknwon media byte in request-header
ERR_SECNOTFOUND	EQU 8108H	;sector not found
ERR_OUTOFPAPER	EQU 8109H	;printer out of paper
ERR_WRITEFAULT	EQU 810AH	;write fault
ERR_READFAULT	EQU 810BH	;read fault
ERR_GENFAILURE	EQU 810CH	;general failure
ERR_INVCHANGE	EQU 810FH	;invalid media change

;device-driver structures

STRUC sDRVHDR				;general device-driver header
drvLink		dd ?			;pointer to next device-driver
drvAttrib	dw ?			;attributes
drvStrat	dw ?			;strategy-routine entry point
drvIntr		dw ?			;interrupt-routine entry point
drvName		db "dev_name"	;device-name / number of units
ENDS sDRVHDR

STRUC sREQHDR				;general request-header
rqLength	db ?			;length of request header
rqSubUnit	db ?			;subunit number
rqCmd		db ?			;command
rqStatus	dw ?			;status
rqRsvd		db 8 DUP(?)		;
ENDS sREQHDR

STRUC sRWREQ				;general read/write request-header
rwLength	db SIZE sRWREQ	;length of request-header
rwUnit		db ?			;sub-unit the request is for
rwFunction	db ?			;requested function (read of write)
rwStatus	dw ?			;status returned from driver
rwRsvd		db 8 DUP(?)		;
rwMedia		db ?			;expected media-type
rwBufferOff	dw ?			;pointer to transfer-buffer
rwBufferSeg	dw ?
rwCount		dw ?			;number of sectors to read
rwStartSec	dw ?			;first sector to read (<0FFFFh)
rwVolumeID	dd ?			;pointer to volume-id if disk-changed
rwHugeSec	dd ?			;first sector to read if StartSec=0FFFFh
ENDS sRWREQ

STRUC sREQIOCTL				;resquest header for IOCTL (input/output)
ioHdr	sREQHDR ?			;
ioMedia		db 0			;media expected
ioBuffer	dd ?			;pointer to transfer buffer
ioSize		dw ?			;number of bytes/sectors to read/write
ioSec		dw 0			;first sector to read/write
ioPtr		dd 0			;points to volume-id if media-changed
ENDS sREQIOCTL

STRUC sREQINIT				;request header for INIT command
irhdr		sREQHDR ?		;
irUnits		db ?			;number of units supported
irEndAdrOff	dw ?			;pointer to end after initialisation
irEndAdrSeg	dw ?			;(points to end of useable memory at call)
irParmAdr	dd ?			;points to config-line (gets ptr to BPB)
irDriveNo	db ?			;number of first assigned drive
irMsgFlag	dw ?			;flag if DOS should display a message on error
ENDS sREQINIT

;end of file 'DRIVER.INC'

