include src\qlib.inc
include process.inc
include dos.inc
include alloc.inc
include string.inc
include dpmi.inc
include errno.inc
include fcntl.inc

;this is part of file i/o
;for packed file loading/etc.

_INIT_ segment word public use32 'INITDATA'
  db 0
  db 0
  dd offset pack_init
_INIT_ ends

_EXIT_ segment word public use32 'EXITDATA'
  db 0
  db 0
  dd offset pack_uninit
_EXIT_ ends

.data?  ;starts DWORD aligned
coff dd ?
csiz dd ?
cpos dd ?
cend dd ?
temp4 dd ?  ;used all over
noff dd ?   ;# of files (this must come right after temp4)
old_int21h df ? ;old int21h handler
fn db 13 dup (?)    ;File name used by _open

.data
pts dd 0  ;table size
phs dd 0  ;handles size
pt dd 0   ;the tables  (malloc'ed() and realloc())
  ;this holds the struct of each file loaded (within the pack files)
ph dd 0   ;Packs Handles (malloc'ed and realloc())
  ;FIX : v2.01 : No longer restricted to 16
  ;      this holds the handles of each pack file loaded to quickly know when
  ;      file IO is being performed on a pack file
chand dw 0  ;current handle (0=none!)  (if one file is opened then
            ; another cannot be opened!)
usedos db 0  ;set when needed to bypass pack file IO system

ps struct  ;within file only
  fn db 13 dup (?)   ;the name
  fh dw ?            ;the handle (not used in the header when in the file)
  off dd ?           ;offset in the file
  siz dd ?           ;size of file
ps ends

.code

pack_init proc private
  pushad  ;FIX : v2.01

  sub esp,sizeof pmPROCstruct
  mov ebx,esp
  callp _DPMI_getpmint,21h,ebx
  mov ax,[ebx].pmPROCstruct._sel
  mov wptr[old_int21h+4],ax
  mov eax,[ebx].pmPROCstruct._off
  mov dptr[old_int21h],eax

  mov ax,selcode
  mov [ebx].pmPROCstruct._sel,ax
  mov [ebx].pmPROCstruct._off,offset int_21h
  callp _DPMI_setpmint,21h,ebx
  add esp,sizeof pmPROCstruct

  popad
  ret
pack_init endp

pack_uninit proc private
  pushad

;restore original DOS INT 21h handler
  sub esp,sizeof pmPROCstruct
  mov ebx,esp
  mov ax,wptr[old_int21h+4]
  mov [ebx].pmPROCstruct._sel,ax
  mov eax,dptr[old_int21h]
  mov [ebx].pmPROCstruct._off,eax
  callp _DPMI_setpmint,21h,ebx
  add esp,sizeof pmPROCstruct
  
;close all files used
  cmp ph,0
  jz nobuf
  mov esi,ph
  mov ecx,phs
@@:
  callp close,wptr[esi]
  add esi,2
  dec ecx
  jnz @b

;free buffers
  callp free,pt
  mov pt,0
  callp free,ph
  mov ph,0

nobuf:
  popad
  ret
pack_uninit endp

open_pack proc private,hdr:dword,h:word
  mov ecx,noff
  mov esi,hdr
  mov ax,h
@@:
  mov [esi].ps.fh,ax
  add esi,sizeof ps
  dec ecx
  jnz @b

  mov esi,hdr

  ; increase the size of PT
  ;EBX = # of entries more needed
  mov eax,sizeof ps
  mul noff
  mov ebx,eax
  mov ecx,eax
  mov eax,sizeof ps
  mul pts
  add ebx,eax
  mov edx,eax  ;save for...
  callp realloc,pt,ebx
  cmp eax,NULL
  je bad
  mov pt,eax
  mov edi,eax
  add edi,edx  ;...here
  copyECX  ;destroys AL
  mov eax,noff
  add pts,eax
  xor eax,eax
  ret
bad:
  mov eax,ERROR   ;not enough room to load all files
  ret
open_pack endp

;ADDED : v2.01
  ;opens a packed file (with header already loaded)
  ;these pack files must have been created with the header option with PACKIT.EXE
; Please see packit.txt for more info

pack_open proc,strg:dword,args:vararg  ;opens a packed file
  local h:word,buf:dword

  mov usedos,1

  pushad  ;FIX : v2.01
  ;increase size of PH
  mov ecx,phs
  inc ecx
  shl ecx,1
  callp realloc,ph,ecx
  cmp eax,NULL
  je bad
  inc phs
  mov ph,eax
  mov edi,eax
  add edi,ecx
  sub edi,2  ;edi=>open location
  callp open,strg,O_BINARY or O_RDONLY  ;for reading only! (objections?)
  .if eax==ERROR
bad:
    mov usedos,0
    popad
    mov eax,ERROR
    ret
  .endif
@@:
  stosw   ;save handle
  mov h,ax
;now to read in the files  (can't use READ cause it will screw it up)
  callp read,ax,offset temp4,6
  .if (eax==ERROR) || (eax!=6)
    callp close,h
    jmp bad
  .endif
  mov ebx,offset temp4
  cmp dword ptr[ebx],01a484150h ;'PAH',26  ;note: it's PAH for Pack files without headers
  jz noheader
  cmp dword ptr[ebx],01a4b4150h ;'PAK',26
  jnz bad

;got a header
  xor eax,eax
  mov eax,noff
  mov ebx,sizeof ps
  mul ebx 
  mov ecx,eax  ;siz (save for l8r)
  callp malloc,eax  ;a temp buffer needed to quickly load all structs
  .if eax==NULL
    callp close,h
    jmp bad
  .endif
  mov buf,eax
  callp read,h,eax,ecx
  .if (eax==ERROR) || (eax!=ecx)
    callp free,buf   ;release temp buffer
    callp close,h
    jmp bad
  .endif
  callp open_pack,buf,h
  mov ebx,eax     ;save eax...
  callp free,buf  ;release temp buffer
  .if ebx         ;...for here
    callp close,h
    jmp bad
  .endif
  popad
  xor eax,eax
  mov ax,h
  mov usedos,0
  ret

noheader:
  lea eax,args
  mov ebx,[eax]  ;header
  xor eax,eax
  mov ax,[ebx]
  mov wptr[noff],ax
  add ebx,2  ;skip # of files
  callp open_pack,ebx,h
  test eax,eax
  jnz bad
  popad
  xor eax,eax
  mov ax,h
  mov usedos,0
  ret
pack_open endp

align 4
pack_close proc,h:word
  pushad
  mov ax,h
  mov h,ax
  mov esi,pt
  mov edi,esi
  mov ebx,pts
  xor edx,edx  ;new size
@@:
  cmp [esi].ps.fh,ax
  .if zero?
    add esi,sizeof ps
    dec pts
  .else
    add edx,sizeof ps
    mov ecx,sizeof ps
    rep movsb   ;OPT! : can't opt!  Need all regs
  .endif
  dec ebx
  jnz @b
  mov usedos,1
  callp close,ax
  mov usedos,0
  ;Resize pt
  .if !edx
    callp free,pt
    mov pt,0
  .else
    callp realloc,pt,edx
    mov pt,eax
  .endif

  ;Erase handle too.
  mov esi,ph
  mov edi,esi

  mov ecx,phs
  mov ax,h
  repnz scasw
  .if zero?
    ;copy the rest now
    mov esi,edi
    sub edi,2
    rep movsw
    mov ecx,phs
    dec ecx
    .if zero?
      callp free,ph
      mov ph,0
    .else
      shl ecx,1
      callp realloc,ph,ecx
      mov ph,eax
    .endif
    popad
    xor eax,eax
    ret
  .else
bad:     ;this should NEVER happen! (unless you screw up)
    popad
    mov eax,ERROR
    ret
  .endif

  popad
  xor eax,eax
  ret
pack_close endp

align 4
int_21h:
  push ds
  mov ds,cs:seldata
  cmp usedos,1
  je do_dos
  cmp ph,0
  je do_dos
  cmp ah,3dh
  je _open
  cmp ah,3eh
  je _close
  cmp ah,3fh
  je _read
  cmp ah,42h
  je _lseek
do_dos:
  pop ds
  jmp cs:[old_int21h]

_open:
;search in tables
  cmp chand,0
  jnz do_dos  ;other handle already open!
  pushad
  push es
  mov es,seldata
  mov esi,edx ;strg
  mov edi,offset fn
  xor ecx,ecx
  cld
@@:           ;capatalize the string
  lodsb
  cmp al,0
  jz @f
  cmp al,'\'
  jz notfound
  cmp al,':'
  jz notfound
  .if (al>='a') && (al<='z')
    sub al,32
  .endif
  stosb
  inc ecx
  cmp ecx,12
  jna @b
notfound:
  pop es
  popad
  jmp do_dos
@@:
  test ecx,ecx
  jz notfound
  .if bptr[edi-1]=='.'
    mov bptr[edi-1],0
  .else
    xor al,al
    stosb
  .endif
  mov ebx,pt
  mov ecx,pts
  mov eax,sizeof ps
  mul ecx
  mov edx,offset fn
  add ebx,eax
  sub ebx,sizeof ps  ;ptrs to last entry (so last occurance of file be used instead)
@@:
  callp strcmp,edx,ebx
  test al,al
  jz found
  sub ebx,sizeof ps      ;search thru list backwards!!!
  dec ecx
  jnz @b
  jmp notfound
found:
;pack file found!
  mov ax,[ebx].ps.fh   ;handle
  mov edx,[ebx].ps.off ;offset
  mov ecx,[ebx].ps.siz ;size
  mov coff,edx
  mov cend,edx
  mov chand,ax
  mov cpos,0
  mov csiz,ecx
  add cend,ecx
  mov ecx,edx
  shr ecx,16  ;CX:DX
  mov bx,ax
  mov ax,4200h
  ;mov usedos,1
  ;callp lseek,ax,ecx,SEEK_SET
  ;mov usedos,0
  pushfd   ;faster
  call [old_int21h]
  .if carry?
    ;error
    pop es
    popad
    pop ds
    or byte ptr[esp+8],1      ;set carry on error
    ; flags , cs , eip
    iretd
  .endif
  ;successful
  pop es
  popad
  pop ds
  and byte ptr[esp+8],0feh  ;clear carry
  ; flags , cs , eip
  mov ax,cs:chand
  iretd

_close:
  ;bx=hand
  pushad
  mov ax,bx
  mov esi,ph   ;handlers in use
  mov ecx,phs
@@:
  cmp [esi],ax
  jz @f
  add esi,2
  dec ecx
  jnz @b
  popad
  jmp do_dos
@@:
  popad
  mov chand,0      ;Forgot this thing  eta V0.03
  pop ds
  and byte ptr[esp+8],0feh  ;clear carry
  ; ret,cs,flags
  iretd

_read:
  ;bx=hand
  pushad
  mov ax,bx
  mov esi,ph   ;handlers in use
  mov edx,phs
@@:
  cmp [esi],ax
  jz @f
  add esi,2
  dec edx
  jnz @b
  popad
  jmp do_dos
@@:
  ;reading with a pack file!!
  ;must make sure we don't read past EOF
  ;ecx=MAX TO READ
  mov eax,ecx
  add eax,cpos
  .if eax>csiz
    mov ecx,csiz
    sub ecx,cpos  ;read what is left over  (=0 if cpos=csiz)
  .endif
  mov [esp+6*4],ecx  ;save into ecx
  popad
  pushfd
  call [old_int21h]
  ;gotta fix cpos to ptr to proper location within file
  .if carry?
    or byte ptr[esp+12],1      ;set carry
  .else
    and byte ptr[esp+12],0feh  ;clear carry
    add cpos,eax
  .endif
  pop ds
  iretd

_lseek:
  ;bx=hand
  pushad
  mov ax,bx
  mov esi,ph   ;handlers in use
  mov ecx,phs
@@:
  cmp [esi],ax
  jz @f
  add esi,2
  dec ecx
  jnz @b
  popad
  jmp do_dos
@@:
  popad
  ;LSEEKing with a pack file!!
  ;convert CX:DX => EDX
  shl ecx,16
  mov cx,dx
  mov edx,ecx
  .if al==0
    add edx,coff
  .endif
  .if al==1    ;FIX : v2.01 : greatly updated
    .if edx & 80000000h  ;neg?
      add edx,cpos
      add edx,coff
      .if edx > cend || edx < coff
        mov edx,coff
      .endif
    .else
      add edx,cpos
      add edx,coff
      .if edx > cend || edx < coff
        mov edx,cend
      .endif
    .endif
    xor al,al
  .endif
  .if al==2  ;this is not allowed if edx>0 so I just ignore edx!!
    add edx,cend
    .if edx>cend || edx < coff
      mov edx,cend
    .endif
    xor al,al
  .endif
  .if al>2  ;???
    jmp badseek
  .endif
  mov ecx,edx
  shr ecx,16   ;CX:DX
  pushfd
  call [old_int21h]   ;DX:AX
  ;gotta fix eax to ptr to proper location within file
  .if carry?
    ;ds,ret,cs,flg
badseek:
    or byte ptr[esp+12],1      ;set carry
  .else
    ; DX:AX -> EAX
    shl edx,16
    mov dx,ax
    mov eax,edx
    and byte ptr[esp+12],0feh  ;clear carry
    sub eax,coff
    mov cpos,eax   ;new pos
    ; EAX -> DX:AX
    mov edx,eax
    shr edx,16
  .endif
  pop ds
  iretd

_endseg

end


;in:
;ah=45h
;bx=handle
;out:
;ax=new handle
; NOTE: changing offset of one changes the other.

