#include <qlib.h>
#include <except.h>
#include <stdio.h>
#include <conio.h>
#include <process.h>
#include <video.h>
#include <alloc.h>
#include <string.h>

// Demonstrates the Pure Virtual Function handler

class A;
void test_virtual( A *p );

// class A has a pure virtual function...
class A {
  public:
    A( void ) {
      // this call to test_virtual will fail because
      // the entire vtable has not been built and there
      // are still calls to _purecall
      test_virtual( this );
    }
    virtual void func( void ) = 0;
};

// class B implement this virtual function...
class B : public A {
  public:
    B( void ) {
      // this call to test_virtual will succeed because
      // by this time the vtable is properly created
      test_virtual( this );
    }
    virtual void func( void ) {
      return;
    }
};

// this function simply calls the virtual function...
void test_virtual( A* p ) {
  p->func();
}

void do_vir(void) {
  B test;  //create class B, whose constructor will call a pure virtual
           //function
}

// WARNING : this handler MUST not cause a pure virtual exception
//           or the system will crash !
// WARNING : if this handler is called during an IRQ the system will crash
//           You can not have pure virtual functions called in a C++ IRQ
//           handler !
void new_handler(void) {
  t_setmode(80,25);   //this call will restore the video mode
                      // and the mouse will auto. be disabled (if shown)
  printf("Error : A pure virtual function has been called\n");
  printf("This program will now terminate...\n");
  exit(0);
}

void main( void ) {
  void *fnt,*ptr,*r;

  #include "gfxinit.h"
  if ((fnt=g_loadfnt("font.fnt"))==(void *)ERROR) {
    printf("Unable to load font!\n");
    exit(0);
  }
  if ((ptr=mouse_loadcursor("mouse.ptr"))==(void *)ERROR) {
    printf("Unable to load mouse ptr!\n");
    exit(0);
  }
  if (mouse_init()==ERROR) {
    printf("No mouse detected!\n");
    exit(0);
  }
  if ((r=malloc(320*200))==NULL) {
    printf("Not enough ram!\n");
    exit(0);
  }

  SetExceptHandler(EH_PURE_VIRTUAL,new_handler);
  g_getmode(320,200,8);
  g_setmode();
  mouse_setcursor(ptr);
  memset(r,0,320*200);
  g_setbuf(r);
  mouse_on();
  g_setfntcolor(15);
  g_printf(0,0,"Press a key to cause exception");
  g_copy();
  getch();
  do_vir();
  t_setmode(80,25);
  printf("Pure Function handler failed?\n");
}


