include src\qlib.inc
include dpmi.inc

.code

_DPMI_desc_alloc proc,n:word
  pushad
  mov ax,0000h
  mov cx,n
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  xor ebx,ebx
  mov bx,ax
  mov [esp+7*4],ebx  ;save AX
  popad
  ret
_DPMI_desc_alloc endp

_DPMI_desc_free proc,n:word
  pushad
  mov ax,0001h
  mov bx,n
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_desc_free endp

_DPMI_seg2desc proc,n:word
  pushad
  mov ax,0002h
  mov bx,n
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  xor ebx,ebx
  mov bx,ax
  mov [esp+7*4],ebx  ;save AX
  popad
  ret
_DPMI_seg2desc endp

_DPMI_selinc proc
  mov ax,0003h
  int 31h
  movzx eax,ax
  ret
_DPMI_selinc endp
  
_DPMI_getbase proc,sel:word
  pushad
  mov ax,0006h
  mov bx,sel
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  shl ecx,16
  mov cx,dx
  mov [esp+7*4],ecx  ;save EAX
  popad
  ret
_DPMI_getbase endp

_DPMI_setbase proc,sel:word,base:dword
  pushad
  mov ax,0007h
  mov bx,sel
  mov ecx,base
  mov dx,cx
  shr ecx,16
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_setbase endp

_DPMI_setlimit proc,sel:word,limit:dword
  pushad
  mov ax,0008h
  mov bx,sel
  mov ecx,limit
  mov dx,cx
  shr ecx,16
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_setlimit endp

_DPMI_setrights proc,sel:word,rights:word
  pushad
  mov ax,0009h
  mov bx,sel
  mov cx,rights
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_setrights endp

_DPMI_create_alias proc,sel:word
  pushad
  mov ax,000ah
  mov bx,sel
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  xor ebx,ebx
  mov bx,ax
  mov [esp+7*4],ebx  ;save EAX
  popad
  ret
_DPMI_create_alias endp

_DPMI_getdesc proc,sel:word,buf:dword
  pushad
  mov ax,000bh
  mov bx,sel
  mov edi,buf   ;ES:EDI
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_getdesc endp

_DPMI_setdesc proc,sel:word,buf:dword
  pushad
  mov ax,000ch
  mov bx,sel
  mov edi,buf   ;ES:EDI
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_setdesc endp

_DPMI_dos_alloc proc,siz:word
  pushad
  mov ax,0100h
  mov bx,siz
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  xor ebx,ebx
  mov bx,dx
  mov [esp+7*4],ebx  ;save EAX
  popad
  ret
_DPMI_dos_alloc endp

_DPMI_dos_free proc,sel:word
  pushad
  mov ax,0101h
  mov dx,sel
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_dos_free endp

_DPMI_dos_resize proc,sel:word,siz:word
  pushad
  mov ax,0102h
  mov bx,siz
  mov dx,sel
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_dos_resize endp

_DPMI_do_int proc,v:byte,cb:dword
  pushad
  mov ax,0300h
  xor ebx,ebx
  mov bl,v
  xor ecx,ecx
  mov edi,cb
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_do_int endp

_DPMI_do_call_retf proc,cb:dword
  pushad
  mov ax,0301h
  xor ebx,ebx
  xor ecx,ecx
  mov edi,cb
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_do_call_retf endp

_DPMI_do_call_iret proc,cb:dword
  pushad
  mov ax,0302h
  xor ebx,ebx
  xor ecx,ecx
  mov edi,cb
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  popad
  xor eax,eax
  ret
_DPMI_do_call_iret endp

_DPMI_get_raw_state proc,rf:dword,pf:dword
  pushad
  mov ax,305h
  int 31h
  mov edx,rf
  mov [edx].rmPROCstruct._seg,bx
  mov [edx].rmPROCstruct._off,cx
  mov edx,pf
  mov [edx].pmPROCstruct._sel,si
  mov [edx].pmPROCstruct._off,edi
  xor ebx,ebx
  mov bx,ax
  mov [esp+7*4],ebx  ;save EAX
  popad
  ret
_DPMI_get_raw_state endp

_DPMI_get_raw_switch proc,rf:dword,pf:dword
  pushad
  mov ax,306h
  int 31h
  mov edx,rf
  mov [edx].rmPROCstruct._seg,bx
  mov [edx].rmPROCstruct._off,cx
  mov edx,pf
  mov [edx].pmPROCstruct._sel,si
  mov [edx].pmPROCstruct._off,edi
  popad
  xor eax,eax
  ret
_DPMI_get_raw_switch endp

_DPMI_getver proc
  pushad
  mov ax,400h
  int 31h
  xor ebx,ebx
  mov bx,ax
  mov [esp+7*4],ebx  ;save EAX
  popad
  ret
_DPMI_getver endp

_DPMI_getflgs proc
  pushad
  mov ax,400h
  int 31h
  xor ecx,ecx
  mov cx,bx
  mov [esp+7*4],ecx  ;save EAX
  popad
  ret
_DPMI_getflgs endp

_DPMI_getcpu proc
  pushad
  mov ax,400h
  int 31h
  xor ebx,ebx
  mov bl,cl
  mov [esp+7*4],ebx  ;save EAX
  popad
  ret
_DPMI_getcpu endp

_DPMI_getpics proc
  pushad
  mov ax,400h
  int 31h
  xor ebx,ebx
  mov bx,dx
  mov [esp+7*4],ebx  ;save EAX
  popad
  ret
_DPMI_getpics endp

_DPMI_cli proc
  mov ax,900h
  int 31h
  movzx eax,al
  ret
_DPMI_cli endp

_DPMI_sti proc
  mov ax,901h
  int 31h
  movzx eax,al
  ret
_DPMI_sti endp

_DPMI_getIF proc
  mov ax,902h
  int 31h
  movzx eax,al
  ret
_DPMI_getIF endp

; 0eeffh PMODE/W stuff only

_DPMI_detect proc,pf:dword
  pushad
  mov ax,0eeffh
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  mov edx,pf
  mov [edx].pmPROCstruct._sel,es
  mov es,seldata
  mov [edx].pmPROCstruct._off,ebx
  mov [esp+7*4],eax  ;save EAX
  popad
  ret
_DPMI_detect endp

_DPMI_getmode proc
  pushad
  mov ax,0eeffh
  int 31h
  .if carry?
    popad
    mov eax,ERROR
    ret
  .endif
  xor ebx,ebx
  mov bl,ch
  mov [esp+7*4],ebx  ;save EAX
  popad
  ret
_DPMI_getmode endp

_endseg

end

