#ifndef __QDLL_H_
#define __QDLL_H_

#include <qlib.h>

#define QDLL_SIG  0x4C4C4451  // "QDLL"
#define REVISION  1
#define NAMELEN   64

#define QF_COMPRESSED 1      // DLL file compressed?
#define QF_NEWFIXUP   2      // new fixup format?

/* structs needed for reading a QDLL file... */
struct t_QDLL_fhdr           // QDLL file header
{
  dword sig;                 // "QDLL"
  dword version;             // which version of QDLLFIX produced this QDLL
  dword imagesize;           // size of the DLL exe image
  dword compressedsize;      // size if the DLL is compressed
  dword bsssize;             // size of uninitialized data
  dword numrelocs;           // size of the relocation info (in bytes)
  dword flags;               // QF_* flags (upper two bytes=compression stuff)
  dword entrypoint;          // entrypoint relative to header
  byte  idstring[NAMELEN];   // some ID string. Not a DLL name
  // directly after this header follows the binary DLL image,
  // and after the image comes the relocation info
};

struct t_QDLL_fixup     // not used right now
{
  dword offset;              // offset of fixup
  byte  fixtype;             // type   of fixup
};

#ifdef __cplusplus
  extern "C" {
#endif

extern  word *DLL_error;               // word * because of cross program/QDLL usage
extern  byte  DLL_init(word);
extern  void  DLL_done(void);

extern  word  DLL_load(char *);
extern  byte  DLL_free(word);
extern  char *DLL_getname(word);
extern  word  DLL_gethnd(char *);
extern  void *DLL_getproc(word,char *);
extern  word  DLL_numpublics(word);
struct t_QDLL_procinfo *DLL_getpublic(word,word);

// DLL_init and DLL_done can't be called by a DLL


#ifdef __cplusplus
  }
#endif

#endif