ifndef __PROFILER_H__
__PROFILER_H__ equ 0

.code
profiler_init proto
profiler_start proto pf:dword
profiler_stop proto pf:dword
profiler_print proto pf:dword
profiler_uninit proto

.data

profiler_info struct
  cnt1 dd ?   ;IRQ1
  cnt2 dd ?   ;Pentium cycle clock only  (any CPL)
  idx1dl dd ?  ;index 1 init data lo
  idx1dh dd ?  ;index 1 init data hi
  idx2dl dd ?  ;index 2 init data lo
  idx2dh dd ?  ;index 2 init data hi
  idx1 db ?   ;index 1 (Pentium MSR @ CPL0 only)
  idx2 db ?   ;index 2 
profiler_info ends

pf_data_write equ 0      ;Default
pf_data_read equ 1
pf_data_TLB_miss equ 2   ;(translation look-aside buffer)
pf_data_read_miss equ 3
pf_data_write_miss equ 4
;5 write (hit) to M or E state lines
;6 data cache lines written back
;7 data cache snoops
;8 data cache snoop hits
;9 memory accesses in both pipes
;0Ah bank conflict
pf_misaligned equ 0Bh
;0Ch code read
;0Dh code TLB miss
;0Eh code cache miss
;0Fh segment load
;10h ????
;11h ????
pf_jmps equ 12h
;13h BTB hits (Branch Target Buffer)
;14h taken branch OR BTB hit
pf_pipeline_flushes equ 15h
;16h instructions executed
;17h instructions executed in V-pipe
;18h bus utilization (clocks)
;19h pipeline stalled by write backup
;1Ah pipeline stalled by data memory write
;1Bh pipeline stalled by write to E or M line
;1Ch locked bus cycles
;1Dh i/o read or write cycles
;1Eh non cacheable memory references
pf_AGI equ 1fh    ;(Address Generation Interlock)
;20h ????
;21h ????
;22h FPU operations
;23h breakpoint 0 match
;24h breakpoint 1 match
;25h breakpoint 2 match
;26h breakpoint 3 match
;27h hardware interrupts
;28h data read or data write
;29h data read miss or data write miss

endif

