#ifndef __DOS_H__
#define __DOS_H__

#include <stddef.h>

struct BYTEREGS  {
  byte  al, ah;  word _1;
  byte  bl, bh;  word _2;
  byte  cl, ch;  word _3;
  byte  dl, dh;  word _4;
};

struct WORDREGS  {
  word  ax,_1;
  word  bx,_2;
  word  cx,_3;
  word  dx,_4;
  word  si,_5;
  word  di,_6;
  word  cflag,_7;
  word  flags,_8;
};

struct DWORDREGS  {
  dword  eax, ebx, ecx, edx;
  dword  esi, edi, cflag, flags;
};

union REGS {
  struct  DWORDREGS  x;
  struct  WORDREGS  w;
  struct  BYTEREGS  h;
};

// NOTE: int86x() & int386x() ignores ss,cs
struct SREGS {
  word  es;
  word  cs;
  word  ss;
  word  ds;
  word  fs;
  word  gs;
};

struct ffblk {
  byte ff_reserved[21]; /* reserved by DOS */
  byte ff_attrib;       /* attribute found */
  word ff_ftime;        /* file time */
  word ff_fdate;        /* file date */
  dword ff_fsize;        /* file size */
  byte ff_name[13];     /* found file name */
};

struct lfn_ffblk {
 dword ff_attrib;
   // file attributes
   // bits 0-6 standard DOS attributes (FA_*)
   // bit 8: temporary file
 dword ff_ct_lo,ff_ct_hi;
   // file creation time (number of 100ns intervals since 1/1/1601)
 dword ff_last_access_lo,ff_last_access_hi; // last access time
 dword ff_last_modify_lo,ff_last_modify_hi; // last modification time
 dword ff_fsize_hi;   // file size (high 32 bits)
 dword ff_fsize_lo;   // file size (low 32 bits)
 byte ff_reserved[8];    // reserved
 byte ff_full_name[260]; // ASCIZ full filename
 byte ff_short_name[14]; // ASCIZ short filename (for backward compatibility)
};

struct time {
  byte ti_min;   /* minutes */
  byte ti_hour;  /* hours */
  byte ti_hund;  /* hundredths of seconds */
  byte ti_sec;   /* seconds */
};

struct date {
  word da_year;     /* current year */
  byte da_day;     /* day of the month */
  byte da_mon;     /* month (1 = Jan) */
};

#ifdef __cplusplus
  extern "C" {
#endif

extern void truename(char *dest,char *src);  //DOS func 60h

extern void int86(byte i,union REGS *rin,union REGS *rout);
extern void int86x(byte i,union REGS *rin,union REGS *rout,struct SREGS *sreg);
extern void int386(byte i,union REGS *rin,union REGS *rout);
extern void int386x(byte i,union REGS *rin,union REGS *rout,struct SREGS *sreg);

extern word errno;

extern sword open(char *strg,word acc,...  /*/ mode /*/ );

/* macros for compatibility with earlier versions & other compilers. */
#define sopen(path,access,shflag,mode)	 open (path, (access)|(shflag), mode)

extern void close(sword hand);
extern word creat(char *strg,word attr);
extern word _creat(char *strg,word attr);
extern sdword read(sword hand,void* buf,dword len);
extern sdword write(sword hand,void* buf,dword len);
extern sdword lseek(sword hand,dword pos,byte typ);
extern sdword tell(sword hand);
extern sdword filelength(sword hand);
extern sword eof(sword hand);
extern sword unlink(char * strg);
extern sword getdisk(void);
extern sword setdisk(byte drv);
extern sword mkdir(char * strg);
extern sword chdir(char * strg);
extern sword rmdir(char * strg);
extern sword rename(char * _old,char * _new);
extern char *getcwd(char * buf);
extern char *getdcwd(byte drv,char * buf);
extern sword findfirst(char* str1,void * ffb,word attr);
extern sword findnext(void* ffb);
extern void  fsplit(char *full,char *path,char *_name,char *ext);
extern sbyte getfattr(char *s,dword *attr);
extern sbyte setfattr(char *s,dword attr);
extern sbyte chmod(char *s,dword attr);

extern int isatty(int);

// LFN functions  (see \txt\lfn.txt)
extern sword lfn_findfirst(char* str1,byte allow_attr,byte req_attr,
  word datetyp,void * lfn_ffb);
extern sword lfn_findnext(sword hand,word datetyp,void * lfn_ffb);
extern sword lfn_freefind(sword hand);
// NEW : v2.11 Beta #2 : following LFN functions are all new
extern sword lfn_open(char *,word acc,word attr);
extern sword lfn_creat(char *,word acc,word attr);
extern sbyte lfn_chdir(char *);
extern sbyte lfn_mkdir(char *);
extern sbyte lfn_rmdir(char *);
extern sbyte lfn_unlink(char *);
extern sbyte lfn_rename(char *_old,char *_new);
extern sbyte lfn_getcwd(char *);
extern sbyte lfn_getdcwd(byte,char *);
// NEW : v2.11 Beta #5 : following LFN functions are all new
extern sbyte lfn_truename(char *dest,char *src);

extern void gettime(struct time*);
extern void settime(struct time*);
extern void getdate(struct date*);
extern void setdate(struct date*);

extern void sleep(word);
extern void delay(word);
extern void sound(word);
extern void nosound(void);

#ifndef SEEK_SET

#define SEEK_SET 0   // Seeks from beginning of file
#define SEEK_CUR 1   // Seeks from current position
#define SEEK_END 2   // Seeks from end of file

#define O_NOINHERIT 0x80
#define O_DENYALL   0x10
#define O_DENYWRITE 0x20
#define O_DENYREAD  0x30
#define O_DENYNONE  0x40

#define O_RDONLY   0        // Read only                                   
#define O_WRONLY   1        // Write only                                  
#define O_RDWR     2        // Read and write                              

#define O_CREAT     0x0100  /* create and open file */
#define O_CREATE    0x0100  /* create and open file */
#define O_TRUNC     0x0200  /* open with truncation */
#define O_EXCL      0x0400  /* exclusive open */
#define O_APPEND    0x0800  /* to end of file */

#define O_CHANGED   0x1000  /* user may read these bits, but        */
#define O_DEVICE    0x2000  /*   only RTL\io functions may touch.   */
#define O_TEXT      0x4000  /* CR-LF translation    */
#define O_BINARY    0x8000  /* no translation       */

#define FA_NORMAL   0x00        /* Normal file, no attributes */
#define FA_RDONLY   0x01        /* Read only attribute */
#define FA_HIDDEN   0x02        /* Hidden file */
#define FA_SYSTEM   0x04        /* System file */
#define FA_LABEL    0x08        /* Volume label */
#define FA_DIREC    0x10        /* Directory */
#define FA_ARCH     0x20        /* Archive */

/* Traditional names for bits in st_mode. */
#define S_IFMT  0xF000  /* file type mask */
#define S_IFDIR 0x4000  /* directory */
#define S_IFIFO 0x1000  /* FIFO special */
#define S_IFCHR 0x2000  /* character special */
#define S_IFBLK 0x3000  /* block special */
#define S_IFREG 0x8000  /* or just 0x0000, regular */
#define S_IREAD 0x0100  /* owner may read */
#define S_IWRITE 0x0080 /* owner may write */
#define S_IEXEC 0x0040  /* owner may execute <directory search> */

#define S_ISDIR(m)  ((m) & S_IFDIR)
#define S_ISCHR(m)  ((m) & S_IFCHR)
#define S_ISBLK(m)  ((m) & S_IFBLK)
#define S_ISREG(m)  ((m) & S_IFREG)
#define S_ISFIFO(m) ((m) & S_IFIFO)

#define S_IRWXU  0x01c0 /* RWE permissions mask for owner */
#define S_IRUSR  0x0100 /* owner may read */
#define S_IWUSR  0x0080 /* owner may write */
#define S_IXUSR  0x0040 /* owner may execute <directory search> */

#define LFN_DATE_64BIT 0x00
#define LFN_DATE_MSDOS 0x01

#endif  //SEEK_SET

#ifdef __cplusplus
  }
#endif

#endif
