/*

  mailin2.cmd for ADN v1.10

  This is an advanced REXX file example of how to use ADN with Squish on OS/2.

*/

"@echo off"

/* Configuration */

SemPath="G:\SEM"                /* Semaphore directory */
LogFile="C:\LOG\MAIL.LOG"       /* Log file */
LogName="MAIL"                  /* Log name */
OutBound="C:\OUTBOUND"          /* Outbound directory */

/* Setup */

Call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
Call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/* MailIn */

Call LineOut "LINK.LOG","NETMAIL"
/* Add entries to LINK.LOG here if wanted */
Call Stream "LINK.LOG",'C',"Close"
sq386p "IN OUT SQUASH -fLINK.LOG -o"
adn
If RC<>0 Then Call LogExit "ADN, Err="RC
B=0
If SemExist("AREAFIX.DO") Then
Do
  Call SemDel "AREAFIX.DO"
  /* Call your AreaFix program */
  B=1
End
If SemExist("FILEFIX.DO") Then
Do
  Call SemDel "FILEFIX.DO"
  /* Call your FileFix program */
  B=1
End
If B<>0 Then
Do
  adn
  If RC<>0 Then Call LogExit "ADN, Err="RC
End
If FileExist("LINK.LOG") Then
Do
  sq386p "SQUASH LINK -fLINK.LOG -o"
  Call FileDel "LINK.LOG"
End
Else If FilesExist(OutBound".SQ\*") Then 
  sq386p "SQUASH -o"
scanbldp "All"
Exit 0

/* Terminate */

Terminate:
Exit 1

/* Semaphore functions */

SemDel:
Result=SysFileDelete(SemPath"\"Arg(1))
if Result<>0 Then Call LogExit "Delete error of "SemPath"\"Arg(1)", Errcode="Result
return

SemExist:
If Stream(SemPath"\"Arg(1),'C',"Query Exists")<>"" Then
  Return 1
Return 0

/* File functions */

FileExist:
If Stream(Arg(1),'C',"Query Exists")<>"" Then
  Return 1
Return 0

FileDel:
Result=SysFileDelete(Arg(1))
if Result<>0 Then Call LogExit "Delete error of "Arg(1)", Errcode="Result
Return

FilesExist:
Result=SysFileTree(Arg(1),"TmpFile","FO")
If (Result==0) & (TmpFile.0>0) Then
  Result=1
Else
  Result=0
Drop TmpFile.
Return Result

/* Log functions */

Log:
Say Date('O')" "Time('N')" "LogName" "Arg(1)
Call LineOut LogFile,Date('O')" "Time('N')" "LogName" "Arg(1)
Call LineOut LogFile
Return

LogExit:
Call Log Arg(1)
Signal Terminate

