'
'  DOOR.BAS
'

$ERROR ALL ON
$LIB ALL OFF
$LINK "PCL4PB.OBJ"
$INCLUDE "PCL4PB.BI"

'declare variables
DIM RxBuffer(256+16) AS BYTE
DIM TxBuffer(256+16) AS BYTE
DIM BufSeg AS WORD
DIM Port AS INTEGER
DIM Code AS INTEGER
DIM I AS INTEGER
DIM LibVer AS INTEGER
DIM AnyKey AS STRING

IF COMMAND$ = "" THEN
  PRINT "  Usage: DOOR <Port>"
  PRINT "Example: DOOR 1"
  END
END IF

'Get COM port
Port = VAL(COMMAND$)

'set up RX buffer
BufSeg = 1 + VARSEG(RxBuffer(0)) + (VARPTR(RxBuffer(0)) \ 16)
Code = SioRxBuf(Port, BufSeg, %Size256)
IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioRxBuf()"
  Code = SioError(Code)
  STOP
END IF

IF SioInfo(ASC("I")) <> 0 THEN
  'setup TX buffer
  BufSeg = 1 + VARSEG(TxBuffer(0)) + (VARPTR(TxBuffer(0)) \ 16)
  Code = SioTxBuf(Port, BufSeg, %Size256)
  IF Code < 0 THEN
    PRINT "Error "; Code; " returned from SioTxBuf()"
    Code = SioError(Code)
    STOP
  END IF
END IF

'Take over port
Code = SioReset(Port, %NORESET)

IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioReset()"
  Code = SioError(Code)
  STOP
END IF

CLS

PRINT "DOOR 12/15/97.  Port =";Port
PRINT " "
LibVer = SioInfo(ASC("V"))
PRINT "Library Version: "; LTRIM$(STR$(LibVer \ 16)); ".";
PRINT LTRIM$(STR$(LibVer MOD 16))
PRINT "Entering TERMINAL loop..."

DO
  'Anything incoming ?
  Code = SioGetc(Port, 1)
  IF Code = 13 THEN
    PRINT
  ELSEIF Code >= &H20 THEN
    PRINT CHR$(Code);
  END IF
  'Anything to send ?
  AnyKey$ = INKEY$
  IF AnyKey$ <> "" THEN
    'Exit if user types Control-Z
    IF AnyKey$ = CHR$(26) THEN EXIT DO
    Code = SioPutc(Port,ASC(AnyKey$))
  END IF
LOOP

Code = SioDone(Port)

END

 