	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Sign-extend a packed signed BCD to double-size

	include model.inc
	include modelt.inc
	include bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdSx
;//	Desc	Sign-extend a packed signed BCD number into a
;//		double-size packed signed BCD (convert to double-size).
;//
;//
;//	Entry	Passed args
;//	Exit	Double-size packed signed BCD returned to destination.
;//		Acc undefined.
;//
;//	Note	Destination and source may be the same.

bcdSx	proc
arg	dstBCD	:dataptr, \	; Addr of dest BCD (size = 2*srcsz)
	srcBCD	:dataptr, \	; Addr of source BCD (OK if = dstBCD)
	srcsz	:@uint		; Byte size of source BCD
@uses	ds,es,rsi,rdi,rcx,rax
;.
	mov   rcx, [srcsz]
	dec   rcx		; Copy all but the sign byte
	@LDS  rsi, [srcBCD]
	@LES  rdi, [dstBCD]
	@cld
	rep   movsb
	mov   ah, [rsi]		; Get the sign byte
	mov   rcx, [srcsz]	; Zero old sign and high-order
	sub   al, al
	rep   stosb
	mov   al, ah
	stosb			; Store the sign byte
	RET
bcdSx	endp

	END