	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Convert packed signed BCD to/from un-packed signed BCD

	include	model.inc
	include	modelt.inc
	include	bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdP2u
;//	Desc	Convert packed signed BCD to un-packed signed BCD.
;//
;//
;//	Entry	Passed args
;//	Exit	Un-packed signed BCD returned to destination.
;//		Acc undefined.
;//
;//	Note	Size of destination must be double-size.

bcdP2u	proc
arg	dstBCD	:dataptr, \	; Addr of destination (size = 2*srcsz)
	srcBCD	:dataptr, \	; Addr of source packed BCD value
	srcsz	:@uint		; Byte size of source BCD
@uses	ds,es,rsi,rdi,rcx,rax
;.
	@LDS   rsi, [srcBCD]
	@LES   rdi, [dstBCD]
	mov    rcx, [srcsz]
	dec    rcx		; Loop count
	@cld
	@alignn
@@nxtp:	lodsb			; Get two digits of source
	mov   ah, al		; Copy to ah
	and   al, 0fh		; Clear upper nibble of LSD
	@shr  ah, 4		; Shift MSD into position
	;			;   clearing upper nibble
	stosW			; Store AX to destination
	loop  @@nxtp		; Loop until done
	;
	mov   ah, [rsi]		; Get source's sign byte
	and   rax, 8000h	; Isolate sign bit
	stosW			; Zero byte before sign and
	RET			;   determine sign byte
bcdP2u	endp


;//////////////////////////////////////////////////////////////////////
;//	Name	bcdU2p
;//	Desc	Convert un-packed signed BCD to packed signed BCD.
;//
;//
;//	Entry	Passed args
;//	Exit	Packed signed BCD returned to destination.
;//		Acc = 0: Source BCD contains significant information
;//			 that cannot be packed (see note)
;//		Acc > 0: No error
;//
;//	Note	Since the top byte is used for the sign, a 10-byte
;//		packed BCD can contain (10-1)*2 digits (=18); a 20-
;//		byte un-packed BCD can contain (20-1) digits (=19).
;//		Hence, an un-packed number may contain information
;//		that cannot be converted (this is unusual since an
;//		unpacked BCD is generally used as temporary storage
;//		for a packed BCD; it's also compromising the BCD
;//		format).

bcdU2p	proc
arg	dstBCD	:dataptr, \	; Addr of destination (size = srcsz/2)
	srcBCD	:dataptr, \	; Addr of source un-packed BCD value
	srcsz	:@uint		; Byte size of source
@uses	ds,es,rsi,rdi,rcx
;.
	@LDS  rsi, [srcBCD]
	@LES  rdi, [dstBCD]
	mov   rcx, [srcsz]
	shr   rcx, 1
	dec   rcx		; Loop count
	@cld			; String ops forward
	@alignn
@@nxtu:	lodsW			; Get two digits of source
	@shl  ah, 4		; Shift MSD into position
	;			;   clearing lower nibble
	or    al, ah		; Pack two digits into al
	stosb			; Store al to destination
	loop  @@nxtu		; Loop until done

	lodsW			; Get sign and byte before
	xchg  al, ah		; Swap them
	and   al, 80h		; Isolate sign bit
	stosb			; Store sign byte

	neg   ah		; Set carry if non-zero high byte
	sbb   rax, rax		; OK: return acc=1, zf=0
	inc   rax		; Not OK: return acc=0, zf=1
	RET
bcdU2p	endp

	END