	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Validate format of a packed signed BCD

	include model.inc
	include modelt.inc
	include bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdIsbcd
;//	Desc	Validate the format of a packed signed BCD number,
;//		i.e. does it contain non-BCD digits.
;//
;//
;//	Entry	Passed args
;//	Exit	Acc = 0: Error, contains non-BCD digit(s)
;//		Acc > 0: No error
;//
;//	Note	A packed BCD number stored by the FPU (using the
;//		FBSTP instruction) may contain 0FFh in the sign byte,
;//		indicating that the number is a 'BCD indefinite'.
;//		This function does not flag this as an error (assuming
;//		it is handled by an FPU exception handler routine),
;//		and accepts any value in the sign byte.

bcdIsbcd proc
arg	srcBCD	:dataptr, \	; Addr of BCD
	srcsz	:@uint		; Byte size of BCD
@uses	ds,rbx,rcx,rdx
;.
	mov   rcx, [srcsz]
	dec   rcx		; Ignore the sign byte
	mov   rdx, 0A00Ah	; Handy constant
	@LDS  rbx, [srcBCD]
	@alignn
@@vnxt:	mov   al, [rbx]
        inc   rbx
	cmp   al, dh
	jnc sh @@ret
	and   al, 00Fh
	cmp   al, dl
	jnc sh @@ret
	dec   rcx
	jnz   @@vnxt
@@ret:	; Carry set if valid
	sbb   rax, rax
	neg   rax		; Return acc 0 or 1
	RET
bcdIsbcd endp

	END