	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Convert packed signed BCDs to/from little-/big-endian

	include	model.inc
	include	modelt.inc
	include	bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdBe2le
;//	Desc	Convert packed signed BCD from big-endian format
;//		to little-endian format.
;//
;//
;//	Entry	Passed args
;//	Exit	Packed signed little-endian BCD returned to destination
;//		Acc undefined.
;//
;//	Note	Destination and source *cannot* overlap.
;//
;//		Little-endian format stores the least-significant byte
;//		lowest in memory (the usual on Intel PCs).

bcdBe2le proc
arg	dstBCD	:dataptr, \	; Addr of destination BCD storage
	srcBCD	:dataptr, \	; Addr of source big-endian BCD
	srcsz	:@uint		; Byte size of each BCD
@uses	ds,es,rsi,rdi,rcx,rax
;.
	@LDS  rsi, [srcBCD]
	@LES  rdi, [dstBCD]
	mov   rcx, [srcsz]	; No. of bytes to do
	add   rdi, rcx		; Point dst index
	dec   rdi		;   to dst's sign byte
	@alignn
@@nxtb: cld			; Auto-increment src index
	lodsb			; Get a byte
	std			; Auto-decrement dst index
	stosb			; Store the byte
	loop  @@nxtb		; Repeat until done
	cld			; Reset df
	RET
bcdBe2le endp


;//////////////////////////////////////////////////////////////////////
;//	Name	bcdLe2be
;//	Desc	Convert packed signed BCD from little-endian format
;//		to big-endian format.
;//
;//
;//	Entry	Passed args
;//	Exit	Packed signed big-endian BCD returned to destination.
;//		Acc undefined.
;//
;//	Note	Destination and source *cannot* overlap.

bcdLe2be proc
arg	dstBCD	:dataptr, \	; Addr of destination BCD storage
	srcBCD	:dataptr, \	; Addr of source little-endian BCD
	srcsz	:@uint		; Byte size of each BCD
@uses	ds,es,rsi,rdi,rcx,rax
;.
	@LDS  rsi, [srcBCD]
	@LES  rdi, [dstBCD]
	mov   rcx, [srcsz]	; No. of bytes to do
	add   rsi, rcx		; Point source index
	dec   rsi		;   to src's sign byte
	@alignn
@@nxtl: std			; Auto-decrement src index
	lodsb			; Get a byte
	cld			; Auto-increment dst index
	stosb			; Store the byte
	loop  @@nxtl		; Repeat until done
	RET
bcdLe2be endp

	END