# AWK script to extract headers from .asm files
# usage: awk -f headers.awk *.asm [>output.fil]

{
# If new file, print its name between two lines of dashes
if (FILENAME != lastfile) {
	lastfile = FILENAME;
	filnam = "FILE : " lastfile;
	dashes = filnam;
	gsub(/./, "-", dashes);		# Fill with dashes
	printf ("\n\n%s\n%s\n%s", dashes, filnam, dashes);
}
#
# Headers are delimited by ";////" and ";." but we
# abbreviate if seeing a "local", "uses", or "@uses".
# These strings must appear at the start of a line.
#
if ($1 ~ /^;\/\/\/\//) {
	inhdr = 1;  printf ("\n\n");
}
if (inhdr) {
	if ( $1 ~ /^;\./ || $1 ~ /^@?uses/ || $1 ~ /^local/ )
	  inhdr = 0
	else print $0;		# Print header line
}
} END { printf "\n\n;." }
