{ ͻ
   Programmer Tony Papadimitriou                             
   Program    MCOPY                                          
   Uses       Dos, TPUtils, TPRecDir                         
   Includes   Nothing                                        
   Links      Nothing                                        
   Created    Sunday, December 19, 1993  2:08 am             
   Updated    Monday, December 20, 1993  9:57 pm             
   Language   (MSDOS) Turbo Pascal 6.0                       
   Purpose    Show off TPRecDir unit                         
   Version History Ķ
   1.00       Original                                       
  ͼ }
uses
  Dos,
  TPUtils,
  TPRecDir;

const
  progName = 'MCOPY';
  version  = '1.00';

procedure Copyright;
begin
  Writeln(stderr);
  Writeln(stderr,progName+' ver. ' + version + '  Copyright (c) 1993-94 by Tony G. Papadimitriou *FREEWARE*');
  Writeln(stderr);
end; { Copyright }

var
  totalMatches : Longint;
  copied       : Longint;     { files actually copied }
  failed       : Longint;     { files that failed to copy }
  dest         : PathStr;

{ --- this is the user routine whose address you must supply to ForEachFileIn }
function List(rec: SearchRec): Boolean; far;
var
  temp: String;
begin
  List := True;
  ShowProgressHere;
  if not AttributeMatches(rec.attr,Directory) then
  begin
    Inc(totalMatches);
    BlankLine;
    { --- prepare destination filename }
    if (Length(dest) > 0) and (dest[ Length(dest) ] = '\') then
      Delete(dest,Length(dest),1);
    temp := FExpand(dest + '\' + rec.name);
    { --- now, copy it }
    Write('Copying ',Left(FExpand(rec.name)+' to '+temp,60,'.'),'  ');
    if not CopyFile(FExpand(rec.name),temp,No) then
    begin
      Writeln('*FAILED*');
      Inc(failed);
    end
    else
    begin
      Writeln('');
      Inc(copied);
    end;
    Write(stderr,'Working  ');
  end;
end; { List }

var
  path  : PathStr;
  mask  : String;
begin
  Copyright;
  if ParamCount = 0 then
  begin
    Writeln(stderr,'Usage: MCOPY [<path>\]<mask>[;<mask>] [<destination path>]');
    Writeln(stderr);
    Writeln(stderr,'       Press ESC during search to interrupt prematurely.');
    Halt;
  end; { if }
  totalMatches := 0;
  copied       := 0;
  failed       := 0;
  path := ParamStr(1);
  mask := GetMask(path);
  path := GetPath(path);
  dest := ParamStr(2);
  if dest = '' then GetDir(0,dest);
  {$V-} LeftSlashes(dest); {$V+}
  dest := FExpand(dest);
  if path[ 1 ] = dest[ 1 ] then Abort(NIL,'Source and destination drives are the same');
  Write(stderr,'Working  ');
  ForEachFileIn(path,mask,AnyFile,True,True,@List);
  BlankLine;
  if errorsFound then Writeln(stderr,'Errors during processing!');
  Writeln(stderr,totalMatches,' match',OneManyStr(totalMatches,'','es'),' found!');
  Writeln(stderr,copied,' file',OneManyStr(copied,'','s'),' copied!');
  Writeln(stderr,failed,' file',OneManyStr(failed,'','s'),' failed to copy!');
end.
