NOMAP
0 CONSTANT CHAIN-INI
I80186
\ 30000 100 MSDOSEXE
100 MSDOS
INCLUDE DISPLAY1
INCLUDE FACIL1
INCLUDE FILES1

85 CONSTANT MAXGAMES    \ Number of game fields

\
\  ***** DEFINE DATA AREAS *****
\

\ Create the playing field

20 CONSTANT MAXROWS    \ maximum rows in playing field
21 CONSTANT MAXCOLUMNS \ maximum columns in playing field (allows 1 byte count)

MAXROWS MAXCOLUMNS * CONSTANT FIELDSIZE \ for convenience

\ We will be accessing memory beyond the bounds of the array, so we 
\ need a "buffer region" since we are not allowed to reference memory
\ we haven't allocated

MAXCOLUMNS CHARS ALLOT  \ buffer
HERE  \ start of playing field
 FIELDSIZE CHARS ALLOT  \ the playing field
 MAXCOLUMNS CHARS ALLOT \ buffer
CONSTANT FIELD        \ value is address of playing field array

VARIABLE PSOKO        \ pointer to SOKO in playing field
VARIABLE MOVE#        \ number of moves made in game
VARIABLE PUSH#        \ number of pushes made in the game
VARIABLE GAME#        \ current game number

VARIABLE MESSAGE      \ message to be displayed (concerning last move)
VARIABLE LASTCMD      \ last command character
CREATE BAD_MOVE_BUFFER 30 CHARS ALLOT \ Volatile storage for bad move message

\ To help the player, we will allow an Undo last move and a saved state
CREATE UNDOFIELD FIELDSIZE CHARS ALLOT
VARIABLE UNDOPSOKO    \ location of SOKO in last move
VARIABLE UNDOMOVE#    \ move number in saved state
VARIABLE UNDOPUSH#    \ push number in saved state
VARIABLE CAN_UNDO     \ TRUE if we can do an UNDO

CREATE SAVEFIELD FIELDSIZE CHARS ALLOT
VARIABLE SAVEPSOKO    \ location of SOKO in saved state
VARIABLE SAVEMOVE#    \ move number in saved state
VARIABLE SAVEPUSH#    \ push number in saved state
VARIABLE CAN_RESTORE  \ TRUE if there is a saved game

\ In the playing field, the following characters are used.
\  If you change them, the instructions and the initial fields will need
\  to be changed as well.
CHAR # CONSTANT WALL  \ A wall
CHAR $ CONSTANT ROCK  \ A rock
CHAR @ CONSTANT SOKO  \ the player
CHAR . CONSTANT GOAL  \ Rock goal when unoccupied
CHAR * CONSTANT ROCKG \ rock on top of goal (desired result!)
CHAR P CONSTANT SOKOG \ Soko on top of goal (displays as SOKO)
BL     CONSTANT AIR   \ nothing here but air
CHAR x CONSTANT VOID  \ outside the playing field there is nothing!
                      \ (displays as a space)

0 CONSTANT BLACK
4 CONSTANT RED
2 CONSTANT GREEN
6 CONSTANT YELLOW
1 CONSTANT BLUE
5 CONSTANT MAROON
3 CONSTANT CYAN
7 CONSTANT WHITE
\ colors are packed into bytes with background in high-nibble and
\ forground (including bright flag) in low-nibble
H: BRIGHT   ( color -- brightcolor ) 8 + ;
H: FG-BG    ( forecolor backcolor -- mergedcolor ) 16 * + ;

0 2 IN/OUT 
: ?XY ( -- X Y ) cursor @ 2/ c/l /MOD ;
0 0 IN/OUT
: CRNOLF   ?XY NIP 0 SWAP AT-XY ;
0 0 IN/OUT
: EREOL ?XY 2DUP DROP c/l SWAP - SPACES AT-XY ;


\
\  ***** SCOREKEEPING DATA AND CODE *****
\

3 CONSTANT #INITIALS
CREATE LOWSCORES MAXGAMES CELLS ALLOT      \ low scores table
CREATE WHOSCORED MAXGAMES #INITIALS * CHARS ALLOT  \ winners' initials

1 1 IN/OUT
: LOWSCORE ( game# -- tableAddress )
  CELLS LOWSCORES + 
;

1 1 IN/OUT
: WHOSCORE ( game# -- tableAccress )
  #INITIALS * CHARS WHOSCORED +
;

: DUMMY_LOW_SCORES
  \ Just fill in a few low scores to make the game look played
  1000 0 LOWSCORE ! S" AAA" 0 WHOSCORE SWAP CMOVE
  2000 1 LOWSCORE ! S" BBB" 1 WHOSCORE SWAP CMOVE
  3000 2 LOWSCORE ! S" CCC" 2 WHOSCORE SWAP CMOVE
  4000 3 LOWSCORE ! S" DDD" 3 WHOSCORE SWAP CMOVE
  5000 4 LOWSCORE ! S" EEE" 4 WHOSCORE SWAP CMOVE
;

: READ_LOW_SCORES ( -- )
  \ We open and read a file of scores here
  S" SOKOBAN.DAT" R/O BIN OPEN-FILE IF
     DROP
     \ The following code is executed if the file is not found:
     MAXGAMES 0 DO  
        -1 I LOWSCORE !  \ -1 is maximum unsigned value
     LOOP
     WHOSCORED  MAXGAMES #INITIALS * CHARS  BL FILL  \ clear table of initials
     DUMMY_LOW_SCORES  \ seed some of the table to keep things interesting
  ELSE
     >R  \ file id
     LOWSCORES MAXGAMES CELLS R@ READ-FILE 2DROP  \ it will succeed!
     WHOSCORED MAXGAMES #INITIALS * CHARS R@ READ-FILE 2DROP
     R> CLOSE-FILE DROP
  THEN
;

: WRITE_LOW_SCORES ( -- )
  \ This function writes the low scores
  S" SOKOBAN.DAT" W/O BIN CREATE-FILE IF
     ." Cannot write low score file!" CR
     DROP
  ELSE
     >R
     LOWSCORES MAXGAMES CELLS R@ WRITE-FILE DROP
     WHOSCORED MAXGAMES #INITIALS * CHARS R@ WRITE-FILE DROP
     R> CLOSE-FILE DROP
  THEN
;

\ 
\  ***** COLOR SETTING FUNCTIONS *****
\

H: DEFINE_COLOR   ( colorValue -- , build time )
               ( -- , execution time sets col )
   CREATE , DOES> @ style ! ;

WHITE BLACK FG-BG         CONSTANT NORMAL
NORMAL                    DEFINE_COLOR C_NORM
RED BRIGHT BLACK FG-BG    DEFINE_COLOR C_MSG
WHITE BRIGHT BLACK FG-BG  DEFINE_COLOR C_ENH
BLACK GREEN FG-BG         DEFINE_COLOR C_WALL
GREEN BRIGHT GREEN FG-BG  DEFINE_COLOR C_ROCK
WHITE BRIGHT GREEN FG-BG  DEFINE_COLOR C_SOKO
CYAN BRIGHT GREEN FG-BG   DEFINE_COLOR C_GOAL
YELLOW BRIGHT GREEN FG-BG DEFINE_COLOR C_ROCKG
BLUE BRIGHT BLACK FG-BG   DEFINE_COLOR C_CMDS

\
\  ***** CODE TO INITIALIZE THE PLAYING FIELD ****
\


VARIABLE PFIELD         \ pointer to field row

: !FIELD ( stringAddress length -- )
    DUP PFIELD @ C!           \ store the length 
    PFIELD @ CHAR+ SWAP CMOVE \ move in the data
    MAXCOLUMNS PFIELD +!      \ point to next row
;

0 0 IN/OUT
: RESET_FIELD ( -- )
    FIELD FIELDSIZE CHARS 0 FILL \ clear the playing field
    FIELD PFIELD ! ;

\ The levels follow as ascii text:
\ Problem -- how to use the playing field file? I decided to
\ dedicate a word for each game play field to do initialization. 
\ When the word executes, the playing field for the game is copied
\ into volatile (alterable) memory.  A simple set of macros in my 
\ text editor converted the ascii file into the following Forth code: 


: (001)
S" xxxx#####" !FIELD
S" xxxx#   #" !FIELD
S" xxxx#$  #" !FIELD
S" xx###  $##" !FIELD
S" xx#  $ $ #" !FIELD
S" ### # ## #xxx######" !FIELD
S" #   # ## #####  ..#" !FIELD
S" # $  $          ..#" !FIELD
S" ##### ### #@##  ..#" !FIELD
S" xxxx#     #########" !FIELD
S" xxxx#######" !FIELD
;

: (002)
S" ############" !FIELD
S" #..  #     ###" !FIELD
S" #..  # $  $  #" !FIELD
S" #..  #$####  #" !FIELD
S" #..    @ ##  #" !FIELD
S" #..  # #  $ ##" !FIELD
S" ###### ##$ $ #" !FIELD
S" xx# $  $ $ $ #" !FIELD
S" xx#    #     #" !FIELD
S" xx############" !FIELD
;

: (003)
S" xxxxxxxx########" !FIELD
S" xxxxxxxx#     @#" !FIELD
S" xxxxxxxx# $#$ ##" !FIELD
S" xxxxxxxx# $  $#" !FIELD
S" xxxxxxxx##$ $ #" !FIELD
S" ######### $ # ###" !FIELD
S" #....  ## $  $  #" !FIELD
S" ##...    $  $   #" !FIELD
S" #....  ##########" !FIELD
S" ########" !FIELD
;

: (004)
S" xxxxxxxxxxx########" !FIELD
S" xxxxxxxxxxx#  ....#" !FIELD
S" ############  ....#" !FIELD
S" #    #  $ $   ....#" !FIELD
S" # $$$#$  $ #  ....#" !FIELD
S" #  $     $ #  ....#" !FIELD
S" # $$ #$ $ $########" !FIELD
S" #  $ #     #" !FIELD
S" ## #########" !FIELD
S" #    #    ##" !FIELD
S" #     $   ##" !FIELD
S" #  $$#$$  @#" !FIELD
S" #    #    ##" !FIELD
S" ###########" !FIELD
;

: (005)
S" xxxxxxxx#####" !FIELD
S" xxxxxxxx#   #####" !FIELD
S" xxxxxxxx# #$##  #" !FIELD
S" xxxxxxxx#     $ #" !FIELD
S" ######### ###   #" !FIELD
S" #....  ## $  $###" !FIELD
S" #....    $ $$ ##" !FIELD
S" #....  ##$  $ @#" !FIELD
S" #########  $  ##" !FIELD
S" xxxxxxxx# $ $  #" !FIELD
S" xxxxxxxx### ## #" !FIELD
S" xxxxxxxxxx#    #" !FIELD
S" xxxxxxxxxx######" !FIELD
;

: (006)
S" ######xx###" !FIELD
S" #..  #x##@##" !FIELD
S" #..  ###   #" !FIELD
S" #..     $$ #" !FIELD
S" #..  # # $ #" !FIELD
S" #..### # $ #" !FIELD
S" #### $ #$  #" !FIELD
S" xxx#  $# $ #" !FIELD
S" xxx# $  $  #" !FIELD
S" xxx#  ##   #" !FIELD
S" xxx#########" !FIELD
;

: (007)
S" xxxxxxx#####" !FIELD
S" x#######   ##" !FIELD
S" ## # @## $$ #" !FIELD
S" #    $      #" !FIELD
S" #  $  ###   #" !FIELD
S" ### #####$###" !FIELD
S" # $  ### ..#" !FIELD
S" # $ $ $ ...#" !FIELD
S" #    ###...#" !FIELD
S" # $$ #x#...#" !FIELD
S" #  ###x#####" !FIELD
S" ####" !FIELD
;

: (008)
S" xx####" !FIELD
S" xx#  ###########" !FIELD
S" xx#    $   $ $ #" !FIELD
S" xx# $# $ #  $  #" !FIELD
S" xx#  $ $  #    #" !FIELD
S" ### $# #  #### #" !FIELD
S" #@#$ $ $  ##   #" !FIELD
S" #    $ #$#   # #" !FIELD
S" #   $    $ $ $ #" !FIELD
S" #####  #########" !FIELD
S" xx#      #" !FIELD
S" xx#      #" !FIELD
S" xx#......#" !FIELD
S" xx#......#" !FIELD
S" xx#......#" !FIELD
S" xx########" !FIELD
;

: (009)
S" xxxxxxxxxx#######" !FIELD
S" xxxxxxxxxx#  ...#" !FIELD
S" xxxxxx#####  ...#" !FIELD
S" xxxxxx#      . .#" !FIELD
S" xxxxxx#  ##  ...#" !FIELD
S" xxxxxx## ##  ...#" !FIELD
S" xxxxx### ########" !FIELD
S" xxxxx# $$$ ##" !FIELD
S" x#####  $ $ #####" !FIELD
S" ##   #$ $   #   #" !FIELD
S" #@ $  $    $  $ #" !FIELD
S" ###### $$ $ #####" !FIELD
S" xxxxx#      #" !FIELD
S" xxxxx########" !FIELD
;

: (010)
S" x###xx#############" !FIELD
S" ##@####       #   #" !FIELD
S" # $$   $$  $ $ ...#" !FIELD
S" #  $$$#    $  #...#" !FIELD
S" # $   # $$ $$ #...#" !FIELD
S" ###   #  $    #...#" !FIELD
S" #     # $ $ $ #...#" !FIELD
S" #    ###### ###...#" !FIELD
S" ## #  #  $ $  #...#" !FIELD
S" #  ## # $$ $ $##..#" !FIELD
S" # ..# #  $      #.#" !FIELD
S" # ..# # $$$ $$$ #.#" !FIELD
S" ##### #       # #.#" !FIELD
S" xxxx# ######### #.#" !FIELD
S" xxxx#           #.#" !FIELD
S" xxxx###############" !FIELD
;

: (011)
S" xxxxxxxxxx####" !FIELD
S" xxxxx#### #  #" !FIELD
S" xxx### @###$ #" !FIELD
S" xx##      $  #" !FIELD
S" x##  $ $$## ##" !FIELD
S" x#  #$##     #" !FIELD
S" x# # $ $$ # ###" !FIELD
S" x#   $ #  # $ #####" !FIELD
S" ####    #  $$ #   #" !FIELD
S" #### ## $         #" !FIELD
S" #.    ###  ########" !FIELD
S" #.. ..#x####" !FIELD
S" #...#.#" !FIELD
S" #.....#" !FIELD
S" #######" !FIELD
;

: (012)
S" ################" !FIELD
S" #              #" !FIELD
S" # # ######     #" !FIELD
S" # #  $ $ $ $#  #" !FIELD
S" # #   $@$   ## ##" !FIELD
S" # #  $ $ $###...#" !FIELD
S" # #   $ $  ##...#" !FIELD
S" # ###$$$ $ ##...#" !FIELD
S" #     # ## ##...#" !FIELD
S" #####   ## ##...#" !FIELD
S" xxxx#####     ###" !FIELD
S" xxxxxxxx#     #" !FIELD
S" xxxxxxxx#######" !FIELD
;

: (013)
S" #####x####" !FIELD
S" #...#x#  ####" !FIELD
S" #...###  $  #" !FIELD
S" #....## $  $###" !FIELD
S" ##....##   $  #" !FIELD
S" ###... ## $ $ #" !FIELD
S" # ##    #  $  #" !FIELD
S" #  ## # ### ####" !FIELD
S" # $ # #$  $    #" !FIELD
S" #  $ @ $    $  #" !FIELD
S" #   # $ $$ $ ###" !FIELD
S" #  ######  ###" !FIELD
S" # ##xxxx####" !FIELD
S" ###" !FIELD
;

: (014)
S" xxx#########" !FIELD
S" xx##   ##  ######" !FIELD
S" ###     #  #    ###" !FIELD
S" #  $ #$ #  #  ... #" !FIELD
S" # # $#@$## # #.#. #" !FIELD
S" #  # #$  #    . . #" !FIELD
S" # $    $ # # #.#. #" !FIELD
S" #   ##  ##$ $ . . #" !FIELD
S" # $ #   #  #$#.#. #" !FIELD
S" ## $  $   $  $... #" !FIELD
S" x#$ ######    ##  #" !FIELD
S" x#  #xxxx##########" !FIELD
S" x####" !FIELD
;

: (015)
S" xxxxxxx#######" !FIELD
S" x#######     #" !FIELD
S" x#     # $@$ #" !FIELD
S" x#$$ #   #########" !FIELD
S" x# ###......##   #" !FIELD
S" x#   $......## # #" !FIELD
S" x# ###......     #" !FIELD
S" ##   #### ### #$##" !FIELD
S" #  #$   #  $  # #" !FIELD
S" #  $ $$$  # $## #" !FIELD
S" #   $ $ ###$$ # #" !FIELD
S" #####     $   # #" !FIELD
S" xxxx### ###   # #" !FIELD
S" xxxxxx#     #   #" !FIELD
S" xxxxxx########  #" !FIELD
S" xxxxxxxxxxxxx####" !FIELD
;

: (016)
S" xxx########" !FIELD
S" xxx#   #  #" !FIELD
S" xxx#  $   #" !FIELD
S" x### #$   ####" !FIELD
S" x#  $  ##$   #" !FIELD
S" x#  # @ $ # $#" !FIELD
S" x#  #      $ ####" !FIELD
S" x## ####$##     #" !FIELD
S" x# $#.....# #   #" !FIELD
S" x#  $..**. $# ###" !FIELD
S" ##  #.....#   #" !FIELD
S" #   ### #######" !FIELD
S" # $$  #  #" !FIELD
S" #  #     #" !FIELD
S" ######   #" !FIELD
S" xxxxx#####" !FIELD
;

: (017)
S" #####" !FIELD
S" #   ##" !FIELD
S" #    #xx####" !FIELD
S" # $  ####  #" !FIELD
S" #  $$ $   $#" !FIELD
S" ###@ #$    ##" !FIELD
S" x#  ##  $ $ ##" !FIELD
S" x# $  ## ## .#" !FIELD
S" x#  #$##$  #.#" !FIELD
S" x###   $..##.#" !FIELD
S" xx#    #.*...#" !FIELD
S" xx# $$ #.....#" !FIELD
S" xx#  #########" !FIELD
S" xx#  #" !FIELD
S" xx####" !FIELD
;

: (018)
S" xxx##########" !FIELD
S" xxx#..  #   #" !FIELD
S" xxx#..      #" !FIELD
S" xxx#..  #  ####" !FIELD
S" xx#######  #  ##" !FIELD
S" xx#            #" !FIELD
S" xx#  #  ##  #  #" !FIELD
S" #### ##  #### ##" !FIELD
S" #  $  ##### #  #" !FIELD
S" # # $  $  # $  #" !FIELD
S" # @$  $   #   ##" !FIELD
S" #### ## #######" !FIELD
S" xxx#    #" !FIELD
S" xxx######" !FIELD
;

: (019)
S" xxxxx###########" !FIELD
S" xxxxx#  .  #   #" !FIELD
S" xxxxx# #.    @ #" !FIELD
S" x##### ##..# ####" !FIELD
S" ##  # ..###     ###" !FIELD
S" # $ #...   $ #  $ #" !FIELD
S" #    .. ##  ## ## #" !FIELD
S" ####$##$# $ #   # #" !FIELD
S" xx## #    #$ $$ # #" !FIELD
S" xx#  $ # #  # $## #" !FIELD
S" xx#               #" !FIELD
S" xx#  ###########  #" !FIELD
S" xx####xxxxxxxxx####" !FIELD
;

: (020)
S" xx######" !FIELD
S" xx#   @####" !FIELD
S" ##### $   #" !FIELD
S" #   ##    ####" !FIELD
S" # $ #  ##    #" !FIELD
S" # $ #  ##### #" !FIELD
S" ## $  $    # #" !FIELD
S" ## $ $ ### # #" !FIELD
S" ## #  $  # # #" !FIELD
S" ## # #$#   # #" !FIELD
S" ## ###   # # ######" !FIELD
S" #  $  #### # #....#" !FIELD
S" #    $    $   ..#.#" !FIELD
S" ####$  $# $   ....#" !FIELD
S" #       #  ## ....#" !FIELD
S" ###################" !FIELD
;

: (021)
S" xxxx##########" !FIELD
S" #####        ####" !FIELD
S" #     #   $  #@ #" !FIELD
S" # #######$####  ###" !FIELD
S" # #    ## #  #$ ..#" !FIELD
S" # # $     #  #  #.#" !FIELD
S" # # $  #     #$ ..#" !FIELD
S" # #  ### ##     #.#" !FIELD
S" # ###  #  #  #$ ..#" !FIELD
S" # #    #  ####  #.#" !FIELD
S" # #$   $  $  #$ ..#" !FIELD
S" #    $ # $ $ #  #.#" !FIELD
S" #### $###    #$ ..#" !FIELD
S" xxx#    $$ ###....#" !FIELD
S" xxx#      ##x######" !FIELD
S" xxx########" !FIELD
;

: (022)
S" #########" !FIELD
S" #       #" !FIELD
S" #       ####" !FIELD
S" ## #### #  #" !FIELD
S" ## #@##    #" !FIELD
S" # $$$ $  $$#" !FIELD
S" #  # ## $  #" !FIELD
S" #  # ##  $ ####" !FIELD
S" ####  $$$ $#  #" !FIELD
S" x#   ##   ....#" !FIELD
S" x# #   # #.. .#" !FIELD
S" x#   # # ##...#" !FIELD
S" x##### $  #...#" !FIELD
S" xxxxx##   #####" !FIELD
S" xxxxxx#####" !FIELD
;

: (023)
S" ######xxxxx####" !FIELD
S" #    #######  #####" !FIELD
S" #   $#  #  $  #   #" !FIELD
S" #  $  $  $ # $ $  #" !FIELD
S" ##$ $   # @# $    #" !FIELD
S" #  $ ########### ##" !FIELD
S" # #   #.......# $#" !FIELD
S" # ##  # ......#  #" !FIELD
S" # #   $........$ #" !FIELD
S" # # $ #.... ..#  #" !FIELD
S" #  $ $####$#### $#" !FIELD
S" # $   ### $   $  ##" !FIELD
S" # $     $ $  $    #" !FIELD
S" ## ###### $ ##### #" !FIELD
S" #         #       #" !FIELD
S" ###################" !FIELD
;

: (024)
S" xxxx#######" !FIELD
S" xxxx#  #  ####" !FIELD
S" ##### $#$ #  ##" !FIELD
S" #.. #  #  #   #" !FIELD
S" #.. # $#$ #  $####" !FIELD
S" #.  #     #$  #  #" !FIELD
S" #..   $#  # $    #" !FIELD
S" #..@#  #$ #$  #  #" !FIELD
S" #.. # $#     $#  #" !FIELD
S" #.. #  #$$#$  #  ##" !FIELD
S" #.. # $#  #  $#$  #" !FIELD
S" #.. #  #  #   #   #" !FIELD
S" ##. ####  #####   #" !FIELD
S" x####xx####xxx#####" !FIELD
;

: (025)
S" ###############" !FIELD
S" #..........  .####" !FIELD
S" #..........$$.#  #" !FIELD
S" ###########$ #   ##" !FIELD
S" #      $  $     $ #" !FIELD
S" ## ####   #  $ #  #" !FIELD
S" #      #   ##  # ##" !FIELD
S" #  $#  # ##  ### ##" !FIELD
S" # $ #$###    ### ##" !FIELD
S" ###  $ #  #  ### ##" !FIELD
S" ###    $ ## #  # ##" !FIELD
S" x# $  #  $  $ $   #" !FIELD
S" x#  $  $#$$$  #   #" !FIELD
S" x#  #  $      #####" !FIELD
S" x# @##  #  #  #" !FIELD
S" x##############" !FIELD
;

: (026)
S" ####" !FIELD
S" #  ##############" !FIELD
S" #  #   ..#......#" !FIELD
S" #  # # ##### ...#" !FIELD
S" ##$#    ........#" !FIELD
S" #   ##$######  ####" !FIELD
S" # $ #     ######@ #" !FIELD
S" ##$ # $   ######  #" !FIELD
S" #  $ #$$$##       #" !FIELD
S" #      #    #$#$###" !FIELD
S" # #### #$$$$$    #" !FIELD
S" # #    $     #   #" !FIELD
S" # #   ##        ###" !FIELD
S" # ######$###### $ #" !FIELD
S" #        #xxxx#   #" !FIELD
S" ##########xxxx#####" !FIELD
;

: (027)
S" x#######" !FIELD
S" x#  #  #####" !FIELD
S" ##  #  #...###" !FIELD
S" #  $#  #...  #" !FIELD
S" # $ #$$ ...  #" !FIELD
S" #  $#  #... .#" !FIELD
S" #   # $########" !FIELD
S" ##$       $ $ #" !FIELD
S" ##  #  $$ #   #" !FIELD
S" x######  ##$$@#" !FIELD
S" xxxxxx#      ##" !FIELD
S" xxxxxx########" !FIELD
;

: (028)
S" x#################" !FIELD
S" x#...   #    #   ##" !FIELD
S" ##.....  $## # #$ #" !FIELD
S" #......#  $  #    #" !FIELD
S" #......#  #  # #  #" !FIELD
S" ######### $  $ $  #" !FIELD
S" xx#     #$##$ ##$##" !FIELD
S" x##   $    # $    #" !FIELD
S" x#  ## ### #  ##$ #" !FIELD
S" x# $ $$     $  $  #" !FIELD
S" x# $    $##$ ######" !FIELD
S" x#######  @ ##" !FIELD
S" xxxxxxx######" !FIELD
;

: (029)
S" xxxxxxxxx#####" !FIELD
S" xxxxx#####   #" !FIELD
S" xxxx## $  $  ####" !FIELD
S" ##### $  $ $ ##.#" !FIELD
S" #       $$  ##..#" !FIELD
S" #  ###### ###.. #" !FIELD
S" ## #  #    #... #" !FIELD
S" # $   #    #... #" !FIELD
S" #@ #$ ## ####...#" !FIELD
S" ####  $ $$  ##..#" !FIELD
S" xxx##  $ $  $...#" !FIELD
S" xxxx# $$  $ #  .#" !FIELD
S" xxxx#   $ $  ####" !FIELD
S" xxxx######   #" !FIELD
S" xxxxxxxxx#####" !FIELD
;

: (030)
S" #####" !FIELD
S" #   ##" !FIELD
S" # $  #########" !FIELD
S" ## # #       ######" !FIELD
S" ## #   $#$#@  #   #" !FIELD
S" #  #      $ #   $ #" !FIELD
S" #  ### ######### ##" !FIELD
S" #  ## ..*..... # ##" !FIELD
S" ## ## *.*..*.* # ##" !FIELD
S" # $########## ##$ #" !FIELD
S" #  $   $  $    $  #" !FIELD
S" #  #   #   #   #  #" !FIELD
S" ###################" !FIELD
;

: (031)
S" xxxxxxx###########" !FIELD
S" xxxxxxx#   #     #" !FIELD
S" #####  #     $ $ #" !FIELD
S" #   ##### $## # ##" !FIELD
S" # $ ##   # ## $  #" !FIELD
S" # $  @$$ # ##$$$ #" !FIELD
S" ## ###   # ##    #" !FIELD
S" ## #   ### #####$#" !FIELD
S" ## #     $  #....#" !FIELD
S" #  ### ## $ #....##" !FIELD
S" # $   $ #   #..$. #" !FIELD
S" #  ## $ #  ##.... #" !FIELD
S" #####   ######...##" !FIELD
S" xxxx#####xxxx#####" !FIELD
;

: (032)
S" xx####" !FIELD
S" xx#  #########" !FIELD
S" x##  ##  #   #" !FIELD
S" x#  $# $@$   ####" !FIELD
S" x#$  $  # $ $#  ##" !FIELD
S" ##  $## #$ $     #" !FIELD
S" #  #  # #   $$$  #" !FIELD
S" # $    $  $## ####" !FIELD
S" # $ $ #$#  #  #" !FIELD
S" ##  ###  ###$ #" !FIELD
S" x#  #....     #" !FIELD
S" x####......####" !FIELD
S" xxx#....####" !FIELD
S" xxx#...##" !FIELD
S" xxx#...#" !FIELD
S" xxx#####" !FIELD
;

: (033)
S" xxxxxx####" !FIELD
S" xx#####  #" !FIELD
S" x##     $#" !FIELD
S" ## $  ## ###" !FIELD
S" #@$ $ # $  #" !FIELD
S" #### ##   $#" !FIELD
S" x#....#$ $ #" !FIELD
S" x#....#   $#" !FIELD
S" x#....  $$ ##" !FIELD
S" x#... # $   #" !FIELD
S" x######$ $  #" !FIELD
S" xxxxxx#   ###" !FIELD
S" xxxxxx#$ ###" !FIELD
S" xxxxxx#  #" !FIELD
S" xxxxxx####" !FIELD
;

: (034)
S" ############" !FIELD
S" ##     ##  #" !FIELD
S" ##   $   $ #" !FIELD
S" #### ## $$ #" !FIELD
S" #   $ #    #" !FIELD
S" # $$$ # ####" !FIELD
S" #   # # $ ##" !FIELD
S" #  #  #  $ #" !FIELD
S" # $# $#    #" !FIELD
S" #   ..# ####" !FIELD
S" ####.. $ #@#" !FIELD
S" #.....# $# #" !FIELD
S" ##....#  $ #" !FIELD
S" ###..##    #" !FIELD
S" ############" !FIELD
;

: (035)
S" x#########" !FIELD
S" x#....   ##" !FIELD
S" x#.#.#  $ ##" !FIELD
S" ##....# # @##" !FIELD
S" # ....#  #  ##" !FIELD
S" #     #$ ##$ #" !FIELD
S" ## ###  $    #" !FIELD
S" x#$  $ $ $#  #" !FIELD
S" x# #  $ $ ## #" !FIELD
S" x#  ###  ##  #" !FIELD
S" x#    ## ## ##" !FIELD
S" x#  $ #  $  #" !FIELD
S" x###$ $   ###" !FIELD
S" xxx#  #####" !FIELD
S" xxx####" !FIELD
;

: (036)
S" ############x######" !FIELD
S" #   #    # ###....#" !FIELD
S" #   $$#   @  .....#" !FIELD
S" #   # ###   # ....#" !FIELD
S" ## ## ###  #  ....#" !FIELD
S" x# $ $     # # ####" !FIELD
S" x#  $ $##  #      #" !FIELD
S" #### #  #### # ## #" !FIELD
S" #  # #$   ## #    #" !FIELD
S" # $  $  # ## #   ##" !FIELD
S" # # $ $    # #   #" !FIELD
S" #  $ ## ## # #####" !FIELD
S" # $$     $$  #" !FIELD
S" ## ## ### $  #" !FIELD
S" x#    #x#    #" !FIELD
S" x######x######" !FIELD
;

: (037)
S" xxxxxxxxxxxx#####" !FIELD
S" #####xx######   #" !FIELD
S" #   ####  $ $ $ #" !FIELD
S" # $   ## ## ##  ##" !FIELD
S" #   $ $     $  $ #" !FIELD
S" ### $  ## ##     ##" !FIELD
S" xx# ##### #####$$ #" !FIELD
S" x##$##### @##     #" !FIELD
S" x# $  ###$### $  ##" !FIELD
S" x# $  #   ###  ###" !FIELD
S" x# $$ $ #   $$ #" !FIELD
S" x#     #   ##  #" !FIELD
S" x#######.. .###" !FIELD
S" xxxx#.........#" !FIELD
S" xxxx#.........#" !FIELD
S" xxxx###########" !FIELD
;

: (038)
S" ###########" !FIELD
S" #......   #########" !FIELD
S" #......   #  ##   #" !FIELD
S" #..### $    $     #" !FIELD
S" #... $ $ #   ##   #" !FIELD
S" #...#$#####    #  #" !FIELD
S" ###    #   #$  #$ #" !FIELD
S" xx#  $$ $ $  $##  #" !FIELD
S" xx#  $   #$#$ ##$ #" !FIELD
S" xx### ## #    ##  #" !FIELD
S" xxx#  $ $ ## ######" !FIELD
S" xxx#    $  $  #" !FIELD
S" xxx##   # #   #" !FIELD
S" xxxx#####@#####" !FIELD
S" xxxxxxxx###" !FIELD
;

: (039)
S" xxxxxx####" !FIELD
S" ####### @#" !FIELD
S" #     $  #" !FIELD
S" #   $## $#" !FIELD
S" ##$#...# #" !FIELD
S" x# $...  #" !FIELD
S" x# #. .# ##" !FIELD
S" x#   # #$ #" !FIELD
S" x#$  $    #" !FIELD
S" x#  #######" !FIELD
S" x####" !FIELD
;

: (040)
S" xxxxxxxxxxxxx######" !FIELD
S" x#############....#" !FIELD
S" ##   ##     ##....#" !FIELD
S" #  $$##  $ @##....#" !FIELD
S" #      $$ $#  ....#" !FIELD
S" #  $ ## $$ # # ...#" !FIELD
S" #  $ ## $  #  ....#" !FIELD
S" ## ##### ### ##.###" !FIELD
S" ##   $  $ ##   .  #" !FIELD
S" # $###  # ##### ###" !FIELD
S" #   $   #       #" !FIELD
S" #  $ #$ $ $###  #" !FIELD
S" # $$$# $   #x####" !FIELD
S" #    #  $$ #" !FIELD
S" ######   ###" !FIELD
S" xxxxx#####" !FIELD
;

: (041)
S" xxxx############" !FIELD
S" xxxx#          ##" !FIELD
S" xxxx#  # #$$ $  #" !FIELD
S" xxxx#$ #$#  ## @#" !FIELD
S" xxx## ## # $ # ##" !FIELD
S" xxx#   $ #$  # #" !FIELD
S" xxx#   # $   # #" !FIELD
S" xxx## $ $   ## #" !FIELD
S" xxx#  #  ##  $ #" !FIELD
S" xxx#    ## $$# #" !FIELD
S" ######$$   #   #" !FIELD
S" #....#  ########" !FIELD
S" #.#... ##" !FIELD
S" #....   #" !FIELD
S" #....   #" !FIELD
S" #########" !FIELD
;

: (042)
S" xxxxxxxxxxx#####" !FIELD
S" xxxxxxxxxx##   ##" !FIELD
S" xxxxxxxxx##     #" !FIELD
S" xxxxxxxx##  $$  #" !FIELD
S" xxxxxxx## $$  $ #" !FIELD
S" xxxxxxx# $    $ #" !FIELD
S" ####xxx#   $$ #####" !FIELD
S" #  ######## ##    #" !FIELD
S" #.            $$$@#" !FIELD
S" #.# ####### ##   ##" !FIELD
S" #.# #######. #$ $##" !FIELD
S" #........... #    #" !FIELD
S" ##############  $ #" !FIELD
S" xxxxxxxxxxxxx##  ##" !FIELD
S" xxxxxxxxxxxxxx####" !FIELD
;

: (043)
S" xxxxx########" !FIELD
S" xx####      ######" !FIELD
S" xx#    ## $ $   @#" !FIELD
S" xx# ## ##$#$ $ $##" !FIELD
S" ### ......#  $$ ##" !FIELD
S" #   ......#  #   #" !FIELD
S" # # ......#$  $  #" !FIELD
S" # #$...... $$# $ #" !FIELD
S" #   ### ###$  $ ##" !FIELD
S" ###  $  $  $  $ #" !FIELD
S" xx#  $  $  $  $ #" !FIELD
S" xx######   ######" !FIELD
S" xxxxxxx#####" !FIELD
;

: (044)
S" xxxxxxxx#######" !FIELD
S" xxxx#####  #  ####" !FIELD
S" xxxx#   #   $    #" !FIELD
S" x#### #$$ ## ##  #" !FIELD
S" ##      # #  ## ###" !FIELD
S" #  ### $#$  $  $  #" !FIELD
S" #...    # ##  #   #" !FIELD
S" #...#    @ # ### ##" !FIELD
S" #...#  ###  $  $  #" !FIELD
S" ######## ##   #   #" !FIELD
S" xxxxxxxxxx#########" !FIELD
;

: (045)
S" x#####" !FIELD
S" x#   #" !FIELD
S" x# # #######" !FIELD
S" x#      $@######" !FIELD
S" x# $ ##$ ###   #" !FIELD
S" x# #### $    $ #" !FIELD
S" x# ##### #  #$ ####" !FIELD
S" ##  #### ##$      #" !FIELD
S" #  $#  $  # ## ## #" !FIELD
S" #         # #...# #" !FIELD
S" ######  ###  ...  #" !FIELD
S" xxxxx####x# #...# #" !FIELD
S" xxxxxxxxxx# ### # #" !FIELD
S" xxxxxxxxxx#       #" !FIELD
S" xxxxxxxxxx#########" !FIELD
;

: (046)
S" ##########" !FIELD
S" #        ####" !FIELD
S" # ###### #  ##" !FIELD
S" # # $ $ $  $ #" !FIELD
S" #       #$   #" !FIELD
S" ###$  $$#  ###" !FIELD
S" xx#  ## # $##" !FIELD
S" xx##$#   $ @#" !FIELD
S" xxx#  $ $ ###" !FIELD
S" xxx# #   $  #" !FIELD
S" xxx# ##   # #" !FIELD
S" xx##  ##### #" !FIELD
S" xx#         #" !FIELD
S" xx#.......###" !FIELD
S" xx#.......#" !FIELD
S" xx#########" !FIELD
;

: (047)
S" xxxxxxxxx####" !FIELD
S" x#########  ##" !FIELD
S" ##  $      $ #####" !FIELD
S" #   ## ##   ##...#" !FIELD
S" # #$$ $ $$#$##...#" !FIELD
S" # #   @   #   ...#" !FIELD
S" #  $# ###$$   ...#" !FIELD
S" # $  $$  $ ##....#" !FIELD
S" ###$       #######" !FIELD
S" xx#  #######" !FIELD
S" xx####" !FIELD
;

: (048)
S" xx#########" !FIELD
S" xx#*.*#*.*#" !FIELD
S" xx#.*.*.*.#" !FIELD
S" xx#*.*.*.*#" !FIELD
S" xx#.*.*.*.#" !FIELD
S" xx#*.*.*.*#" !FIELD
S" xx###   ###" !FIELD
S" xxxx#   #" !FIELD
S" ###### ######" !FIELD
S" #           #" !FIELD
S" # $ $ $ $ $ #" !FIELD
S" ## $ $ $ $ ##" !FIELD
S" x#$ $ $ $ $#" !FIELD
S" x#   $@$   #" !FIELD
S" x#  #####  #" !FIELD
S" x####xxx####" !FIELD
;

: (049)
S" xxxxxxx####" !FIELD
S" xxxxxxx#  ##" !FIELD
S" xxxxxxx#   ##" !FIELD
S" xxxxxxx# $$ ##" !FIELD
S" xxxxx###$  $ ##" !FIELD
S" xx####    $   #" !FIELD
S" ###  # #####  #" !FIELD
S" #    # #....$ #" !FIELD
S" # #   $ ....# #" !FIELD
S" #  $ # #.*..# #" !FIELD
S" ###  #### ### #" !FIELD
S" xx#### @$  ##$##" !FIELD
S" xxxxx### $     #" !FIELD
S" xxxxxxx#  ##   #" !FIELD
S" xxxxxxx######### " !FIELD
;

: (050)
S" xxxxxx############" !FIELD
S" xxxxx##..    #   #" !FIELD
S" xxxx##..* $    $ #" !FIELD
S" xxx##..*.# # # $##" !FIELD
S" xxx#..*.# # # $  #" !FIELD
S" ####...#  #    # #" !FIELD
S" #  ## #          #" !FIELD
S" # @$ $ ###  #   ##" !FIELD
S" # $   $   # #   #" !FIELD
S" ###$$   # # # # #" !FIELD
S" xx#   $   # # #####" !FIELD
S" xx# $# #####      #" !FIELD
S" xx#$   #xxx#    # #" !FIELD
S" xx#  ###xxx##     #" !FIELD
S" xx#  #xxxxxx#    ##" !FIELD
S" xx####xxxxxx######" !FIELD
;
: (051)
S" #########" !FIELD
S" #       #" !FIELD
S" #  $   $#" !FIELD
S" ####    #" !FIELD
S" xxx# $  ##" !FIELD
S" ####   $ #" !FIELD
S" #.. $ ## ####" !FIELD
S" #..  $##    #" !FIELD
S" #..    $    #" !FIELD
S" #.###$### #@#" !FIELD
S" #.#x#     ###" !FIELD
S" ###x#######" !FIELD
;

: (052)
S" ####################" !FIELD
S" #  ##########     @#" !FIELD
S" # $#    #     ######" !FIELD
S" #      ####   #  ###" !FIELD
S" #####         #  ###" !FIELD
S" #   $         #  ###" !FIELD
S" #  $####  #   #    #" !FIELD
S" # # #  #..#$###  # #" !FIELD
S" # # #$ #..#  $  $$ #" !FIELD
S" #      #..#  #   # #" !FIELD
S" #   #  #..#  #   # #" !FIELD
S" ####################" !FIELD
;

: (053)
S" ####################" !FIELD
S" #                ###" !FIELD
S" # $#   $ ##  $    ##" !FIELD
S" #    $###    # $$ ##" !FIELD
S" #.###     $ $ ##  ##" !FIELD
S" #...#  #  #    #$  #" !FIELD
S" #..##$$#### $  #   #" !FIELD
S" #...#      $ ##  ###" !FIELD
S" #...$  ###  #    # #" !FIELD
S" ##..  $#  ##   ##@ #" !FIELD
S" ###.#              #" !FIELD
S" ####################" !FIELD
;

: (054)
S" ####################" !FIELD
S" #   #    #   #   #@#" !FIELD
S" # $      $   $   # #" !FIELD
S" ## ###..## ###     #" !FIELD
S" #   #....#$#  $### #" !FIELD
S" # $ #....#  $  $ $ #" !FIELD
S" #   #....# # # $ $ #" !FIELD
S" #   ##..##   #$#   #" !FIELD
S" ##$##    ##  #  #$##" !FIELD
S" #   $  $     #  #  #" !FIELD
S" #   #    #   #     #" !FIELD
S" ####################" !FIELD
;

: (055)
S" ####################" !FIELD
S" #    @##      #   ##" !FIELD
S" #    ##    $    $ ##" !FIELD
S" #  ###....# # #  ###" !FIELD
S" #   #....# # # $   #" !FIELD
S" ### #...#  #       #" !FIELD
S" ##  ##.#     $   $ #" !FIELD
S" ##  $ $ ###  # # ###" !FIELD
S" ## $       # # $   #" !FIELD
S" #### $  $# # # # $ #" !FIELD
S" ####         # #  ##" !FIELD
S" ####################" !FIELD
;

: (056)
S" ####################" !FIELD
S" #  #  ##    #   @###" !FIELD
S" ##    $    # $###  #" !FIELD
S" ##$# $ ##$# $ $    #" !FIELD
S" #   $#    $      ###" !FIELD
S" # ##   $ ###  #....#" !FIELD
S" # # $# # # # #....##" !FIELD
S" #    $ $ #  #....###" !FIELD
S" ##$ ###  $ #....####" !FIELD
S" #  # $        ######" !FIELD
S" #      # #    ######" !FIELD
S" ####################" !FIELD
;

: (057)
S" ####################" !FIELD
S" #@     ###   #  #  #" !FIELD
S" # # #  #  $  $     #" !FIELD
S" #####     # $ $#$# #" !FIELD
S" #.#..#    ##$ $    #" !FIELD
S" #.....    $   #   ##" !FIELD
S" #.....    ###$##$###" !FIELD
S" #.#..#    $    #   #" !FIELD
S" #####     #  #$  $ #" !FIELD
S" #####  #  $    $ $ #" !FIELD
S" #####  #  #  #  #  #" !FIELD
S" ####################" !FIELD
;

: (058)
S" ####################" !FIELD
S" ##...   ## #    #  #" !FIELD
S" #....         $ ## #" !FIELD
S" #....# # #$###$    #" !FIELD
S" #...#    #       # #" !FIELD
S" ##.#  #$ #     $## #" !FIELD
S" #  #  # $ $ ###  $ #" !FIELD
S" #     $  $ #  # ## #" !FIELD
S" ## # ## #$$# $#  # #" !FIELD
S" #  #   $ $ #      ##" !FIELD
S" #    #     #  #   @#" !FIELD
S" ####################" !FIELD
;

: (059)
S" ####################" !FIELD
S" #   #  #@# ##  #####" !FIELD
S" # # #  $    $  #####" !FIELD
S" # #    ###### $  ###" !FIELD
S" #   #  #....#  $$  #" !FIELD
S" ##$##$##....#      #" !FIELD
S" #      #....##$##$##" !FIELD
S" #  $$  #....#      #" !FIELD
S" # $  $  #  #  ###  #" !FIELD
S" #####  $   $    $  #" !FIELD
S" ##### #    #  #   ##" !FIELD
S" ####################" !FIELD
;

: (060)
S" ####################" !FIELD
S" #     ###..###     #" !FIELD
S" # $$  ###..###  $@ #" !FIELD
S" #  # ##......#  $  #" !FIELD
S" #     #......#  $  #" !FIELD
S" ####  ###..######$ #" !FIELD
S" #   $$$ #..#    #  #" !FIELD
S" # $#   $  $  $$ #$ #" !FIELD
S" #  #  ## $  ##  #  #" !FIELD
S" # $    $ ## $    $ #" !FIELD
S" #  #  ##    ##  #  #" !FIELD
S" ####################" !FIELD
;

: (061)
S" ####################" !FIELD
S" #    #  # #  #  #  #" !FIELD
S" # @# # ## $   $   ##" !FIELD
S" #### #    #  # $   #" !FIELD
S" #    # ## #$ ## ## #" !FIELD
S" #      $   $   $   #" !FIELD
S" #..###$$## $##$ ## #" !FIELD
S" #..#.#  # $   $ #  #" !FIELD
S" #....# $$   ##$ ####" !FIELD
S" #....#  #####      #" !FIELD
S" #...###        ##  #" !FIELD
S" ####################" !FIELD
;

: (062)
S" ####################" !FIELD
S" #....#       #  #  #" !FIELD
S" #....# # $  $      #" !FIELD
S" #.... ##  $# # $#$ #" !FIELD
S" #...#   $   $#  $  #" !FIELD
S" #..####  # $   $$  #" !FIELD
S" #      #### #### ###" !FIELD
S" #        #   #     #" !FIELD
S" # ##   #   $ # $ $ #" !FIELD
S" # ##    $ ## $  $  #" !FIELD
S" #     @#     #   # #" !FIELD
S" ####################" !FIELD
;

: (063)
S" ####################" !FIELD
S" #....###           #" !FIELD
S" #....##### #  #$# ##" !FIELD
S" #....###   #$  $   #" !FIELD
S" #....###    $  #$$##" !FIELD
S" ##  #### $#  #$ $  #" !FIELD
S" ##  ####  $  $  #  #" !FIELD
S" #@  ####$###$## $  #" !FIELD
S" ##        #  #  $  #" !FIELD
S" ##   ###  #  $  ####" !FIELD
S" ########  #  #     #" !FIELD
S" ####################" !FIELD
;

: (064)
S" ####################" !FIELD
S" #     #     @#...###" !FIELD
S" #     #      ##...##" !FIELD
S" # # # ##$## ## ....#" !FIELD
S" #   $ #   $$$  ....#" !FIELD
S" ###$### $$  ### ##.#" !FIELD
S" #     $  #    # ####" !FIELD
S" #  $  #  ###  # #  #" !FIELD
S" ## #$##    $  $$   #" !FIELD
S" #   $ ##   #  # #  #" !FIELD
S" #     #    #  #    #" !FIELD
S" ####################" !FIELD
;

: (065)
S" ####################" !FIELD
S" #     #  #...#@    #" !FIELD
S" # #       ....#    #" !FIELD
S" #  $  #   #....#   #" !FIELD
S" # ##$#### ##....#  #" !FIELD
S" # $   $  #  #...#  #" !FIELD
S" # $$ #   #   # $$  #" !FIELD
S" ###  $$$#   $$  $  #" !FIELD
S" # $  #  #    # $#  #" !FIELD
S" #   $#  #       $  #" !FIELD
S" #  #    #    #  #  #" !FIELD
S" ####################" !FIELD
;

: (066)
S" ####################" !FIELD
S" #####@###.##...##  #" !FIELD
S" #####$  ..#...#    #" !FIELD
S" ####    ......#  $ #" !FIELD
S" ###  $ #.....## # ##" !FIELD
S" ##  $$# #####  $ $ #" !FIELD
S" ## $# $    ##  $$  #" !FIELD
S" ##  #  #    # $  $ #" !FIELD
S" ##   $$ ### #$##   #" !FIELD
S" ## $#      $ $  $ ##" !FIELD
S" ###    #    #    ###" !FIELD
S" ####################" !FIELD
;

: (067)
S" ####################" !FIELD
S" #@     #   #       #" !FIELD
S" ## ### ##  #### # ##" !FIELD
S" #    # #  $$       #" !FIELD
S" #  # # # $ # $ ## ##" !FIELD
S" #     $ #  #$$ #   #" !FIELD
S" #  ###  #      ## ##" !FIELD
S" #..#.# $ #  $ #    #" !FIELD
S" #..#.#  $ # ## $$  #" !FIELD
S" #....##   $$  $  # #" !FIELD
S" #.....##        #  #" !FIELD
S" ####################" !FIELD
;

: (068)
S" ####################" !FIELD
S" #  #      #   #   ##" !FIELD
S" # $# $ $ ##...$  $ #" !FIELD
S" #  $  # ##....# $  #" !FIELD
S" # ## $ ##....#   $ #" !FIELD
S" # $    #....## $   #" !FIELD
S" # $##  #...#       #" !FIELD
S" #   $$$##$##  ### ##" !FIELD
S" # # #  #   #  #    #" !FIELD
S" # $ #  $  ##       #" !FIELD
S" #    #    #@       #" !FIELD
S" ####################" !FIELD
;

: (069)
S" ####################" !FIELD
S" #  #  # #    #  #  #" !FIELD
S" #   $      $ $     #" !FIELD
S" ## #  #$###$##  ## #" !FIELD
S" #   $     $  #  $  #" !FIELD
S" # ###$##$#   # $   #" !FIELD
S" # #   $ $  ###### $#" !FIELD
S" # $  $$ $  #@#.#...#" !FIELD
S" # #     #  # #.#...#" !FIELD
S" # ########## #.....#" !FIELD
S" #            #.....#" !FIELD
S" ####################" !FIELD
;

: (070)
S" ####################" !FIELD
S" #  #     #  ##    ##" !FIELD
S" # $#   $ #     ##  #" !FIELD
S" # $  $  #..#     $ #" !FIELD
S" # $ $  #....#   # ##" !FIELD
S" # $#  #......### $ #" !FIELD
S" #   #  #....#  #$  #" !FIELD
S" # $  ####..#   #   #" !FIELD
S" ## $   ## # # $  $##" !FIELD
S" ### $    $#@$ $#   #" !FIELD
S" ####   #       #   #" !FIELD
S" ####################" !FIELD
;

: (071)
S" ####################" !FIELD
S" #      ....#    ####" !FIELD
S" #      ....        #" !FIELD
S" # # ##########     #" !FIELD
S" # #$   #      ###..#" !FIELD
S" #  $   #$$###   #..#" !FIELD
S" # $ ### $   $   #..#" !FIELD
S" # $ #   $ $ #  ##..#" !FIELD
S" #  #  $$ # $ ##   ##" !FIELD
S" #@## $#  $  $     ##" !FIELD
S" ##       ##   #  ###" !FIELD
S" ####################" !FIELD
;

: (072)
S" ####################" !FIELD
S" #        #   #@ #  #" !FIELD
S" # $$  #$$# # #  ## #" !FIELD
S" #  # $ $ #$$ #     #" !FIELD
S" ## #  #  # # #  #  #" !FIELD
S" #   ##       #     #" !FIELD
S" #   # $ #   #   #  #" !FIELD
S" # $ #$ #   #  $ #..#" !FIELD
S" ##$ #  ####    #...#" !FIELD
S" #  $          #....#" !FIELD
S" #   #  #     #.....#" !FIELD
S" ####################" !FIELD
;

: (073)
S" ####################" !FIELD
S" #     #   #####    #" !FIELD
S" ## $  #   ####  $  #" !FIELD
S" #### $$   #..#  #  #" !FIELD
S" #  $  $  ##..#### ##" !FIELD
S" # $   ###....   $$ #" !FIELD
S" #  #$#   ....# # $ #" !FIELD
S" # #  # $ ..###$#   #" !FIELD
S" # #   $ #..#   ##  #" !FIELD
S" #   $#  ####   # $##" !FIELD
S" # #  #    @#      ##" !FIELD
S" ####################" !FIELD
;

: (074)
S" ####################" !FIELD
S" #   #   #    #   #@#" !FIELD
S" #   $  $     # $ # #" !FIELD
S" ##$# $### #    $$# #" !FIELD
S" #  #  #.###  #$ $  #" !FIELD
S" #  #$#....#  # ### #" !FIELD
S" # $  #.....##    # #" !FIELD
S" ##$  #.#....#$$ $  #" !FIELD
S" #  ######..## #  # #" !FIELD
S" #  $         $ ### #" !FIELD
S" #   #   #        # #" !FIELD
S" ####################" !FIELD
;

: (075)
S" ####################" !FIELD
S" # # # #   #@##   # #" !FIELD
S" #             $    #" !FIELD
S" #  ##$# ##### $ # ##" !FIELD
S" ##    ##.....#  #  #" !FIELD
S" ##$##$#.....###$#$ #" !FIELD
S" #   # ##.....#  # ##" !FIELD
S" #  $    ##..##  #  #" !FIELD
S" # $ #   $   $  $$$ #" !FIELD
S" ## $  $# #  #  $   #" !FIELD
S" #   ##   #  #      #" !FIELD
S" ####################" !FIELD
;

: (076)
S" ######xx#####" !FIELD
S" #    #xx#   #" !FIELD
S" # $  #### $ #" !FIELD
S" # $      $  #" !FIELD
S" #  ###@###$ #" !FIELD
S" ########## ###" !FIELD
S" #..   ##     #" !FIELD
S" #..   ##$    #" !FIELD
S" #..   ## $   #" !FIELD
S" #..   ## $   #" !FIELD
S" #..     $ $  #" !FIELD
S" ###  #########" !FIELD
S" xx####" !FIELD
;

: (077)
S" xxxxxxx###########" !FIELD
S" xxxxxxx#         #" !FIELD
S" xxxxxxx#    $ $  #" !FIELD
S" ###### # $ ##### #" !FIELD
S" #    ##### $  ##$#" !FIELD
S" #       $ $      #" !FIELD
S" #          ## ## #" !FIELD
S" #    ##@##### ## #" !FIELD
S" #    ####xxx# ## ##" !FIELD
S" #....#xxxxxx# $   #" !FIELD
S" #....#xxxxxx#     #" !FIELD
S" ######xxxxxx#######" !FIELD
;

: (078)
S" #############" !FIELD
S" #           #" !FIELD
S" # ### $$    #" !FIELD
S" #   # $  $  #" !FIELD
S" #  $####$######" !FIELD
S" # $ ##        #####" !FIELD
S" #  $$ $        ...#" !FIELD
S" ### ## $$#     ...#" !FIELD
S" xx# ##   #     ...#" !FIELD
S" xx#      #     ...#" !FIELD
S" xx###@#############" !FIELD
S" xxxx###" !FIELD
;

: (079)
S" xx#################" !FIELD
S" ###@##         ...#" !FIELD
S" #    #         ...#" !FIELD
S" # $  #         ...#" !FIELD
S" # $$ #         ...#" !FIELD
S" ## $ ###$##########" !FIELD
S" x# ###  $ #" !FIELD
S" ##   $  $ #" !FIELD
S" #  $ #  $ #" !FIELD
S" # $  #    #" !FIELD
S" #  $ #    #" !FIELD
S" #    #    #" !FIELD
S" ###########" !FIELD
;

: (080)
S" xxxxxxxxxxxxxx#####" !FIELD
S" xxxxx##########   #" !FIELD
S" xxxxx#        #   #" !FIELD
S" xxxxx#  $ $    $$ #" !FIELD
S" xxxxx# ##### ## $ #" !FIELD
S" xxxxx#$$   #$## $ #" !FIELD
S" xxxxx# ### # ##$  #" !FIELD
S" ###### ### $ $    #" !FIELD
S" #....        ##   #" !FIELD
S" #....        ######" !FIELD
S" #....        #" !FIELD
S" ###########@##" !FIELD
S" xxxxxxxxxx###" !FIELD
;

: (081)
S" xxxx######" !FIELD
S" x####    #" !FIELD
S" x#    ## #" !FIELD
S" x# $     #" !FIELD
S" ### #### ########" !FIELD
S" #  $   $ ##  ...#" !FIELD
S" #   $$ $$    ...#" !FIELD
S" #    $  $##  ...#" !FIELD
S" ##@## ## ##  ...#" !FIELD
S" x###  $  ########" !FIELD
S" x#   $$  #" !FIELD
S" x#    #  #" !FIELD
S" x#########" !FIELD
;

: (082)
S" #######x#########" !FIELD
S" #     #x#   ##  #" !FIELD
S" # ### #x#   $   #" !FIELD
S" # # $ ###   $   #" !FIELD
S" #   $$      ##$ #" !FIELD
S" #    ####   ##  #" !FIELD
S" #@############ ##" !FIELD
S" ###..    #####$ #" !FIELD
S" xx#..    ####   #" !FIELD
S" xx#..       $$  #" !FIELD
S" xx#..    #### $ #" !FIELD
S" xx#..    #xx#   #" !FIELD
S" xx########xx#####" !FIELD
;

: (083)
S" #######" !FIELD
S" #     ##########" !FIELD
S" #     #    #  ##" !FIELD
S" # $   #   $ $  #" !FIELD
S" #  $  #  $ ##  #" !FIELD
S" # $$  ##$ $    #" !FIELD
S" ## #  ## #######" !FIELD
S" ## #  ##    ...#" !FIELD
S" #  #$       ...#" !FIELD
S" #   $$      ...#" !FIELD
S" #     ##@#  ...#" !FIELD
S" ################" !FIELD
;

: (084)
S" ############" !FIELD
S" #      #   ##" !FIELD
S" # $  $   #  ######" !FIELD
S" ####  #####      #" !FIELD
S" x#..  #     #### #" !FIELD
S" x#.####  ####    #" !FIELD
S" x#....    #  $ ####" !FIELD
S" x# ...#   # $$$#  ##" !FIELD
S" ###.#### ##  $@$   #" !FIELD
S" #     ##### $ #    #" !FIELD
S" # #.# $      $###$ #" !FIELD
S" # #.########  #  $ #" !FIELD
S" # #..        ##  $ #" !FIELD
S" # # ####### $ # #  #" !FIELD
S" #   #xxxxx#       ##" !FIELD
S" #####xxxxx##########" !FIELD
;

: (085)
S" ####################" !FIELD
S" # #     #          #" !FIELD
S" #       $  ## ### ##" !FIELD
S" #####  ##   $  $   #" !FIELD
S" ##..##  # # $ # #  #" !FIELD
S" #....  $     ##$# ##" !FIELD
S" #....  $#####   #$##" !FIELD
S" ##..# #  #   #  $  #" !FIELD
S" ###.# #  $   $  # @#" !FIELD
S" ##  $  $ #   #  ####" !FIELD
S" ##       ###########" !FIELD
S" ####################" !FIELD
;
\ Initialize to the game of choice:

CREATE INIT_TABLE 
' (001) , ' (002) , ' (003) , ' (004) , ' (005) , 
' (006) , ' (007) , ' (008) , ' (009) , ' (010) ,
' (011) , ' (012) , ' (013) , ' (014) , ' (015) ,
' (016) , ' (017) , ' (018) , ' (019) , ' (020) , 
' (021) , ' (022) , ' (023) , ' (024) , ' (025) , 
' (026) , ' (027) , ' (028) , ' (029) , ' (030) , 
' (031) , ' (032) , ' (033) , ' (034) , ' (035) , 
' (036) , ' (037) , ' (038) , ' (039) , ' (040) , 
' (041) , ' (042) , ' (043) , ' (044) , ' (045) , 
' (046) , ' (047) , ' (048) , ' (049) , ' (050) , 
' (051) , ' (052) , ' (053) , ' (054) , ' (055) , 
' (056) , ' (057) , ' (058) , ' (059) , ' (060) , 
' (061) , ' (062) , ' (063) , ' (064) , ' (065) , 
' (066) , ' (067) , ' (068) , ' (069) , ' (070) , 
' (071) , ' (072) , ' (073) , ' (074) , ' (075) , 
' (076) , ' (077) , ' (078) , ' (079) , ' (080) , 
' (081) , ' (082) , ' (083) , ' (084) , ' (085) , 

1 0 IN/OUT
: INIT_GAME ( gameNumber -- )
  RESET_FIELD
  1- CELLS INIT_TABLE + @ EXECUTE  \ run the code for the right field
;


\
\  ***** SAVE AND RESTORE GAMES (INCLUDES "UNDO") ****
\


0 0 IN/OUT
: SAVE_FOR_UNDO ( -- , save state for undo )
  FIELD UNDOFIELD FIELDSIZE CMOVE
  PSOKO @ UNDOPSOKO !
  PUSH# @ UNDOPUSH# !
  MOVE# @ UNDOMOVE# !
  TRUE CAN_UNDO !
;

0 0 IN/OUT
: SAVE_FOR_RESTORE ( -- , save state for restore )
  FIELD SAVEFIELD FIELDSIZE CMOVE
  PSOKO @ SAVEPSOKO !
  MOVE# @ SAVEMOVE# !
  PUSH# @ SAVEPUSH# !
  TRUE CAN_RESTORE !
;

0 1 IN/OUT
: DO_UNDO ( -- successFlag , restore from undo )
  CAN_UNDO @ IF
    UNDOFIELD FIELD FIELDSIZE CMOVE
    UNDOPSOKO @ PSOKO !
    UNDOMOVE# @ MOVE# !
    UNDOPUSH# @ PUSH# !
    FALSE CAN_UNDO !
    TRUE
  ELSE
    FALSE
  THEN
;

0 1 IN/OUT
: DO_RESTORE ( -- successFlag, restore from save )
  CAN_RESTORE @ DUP IF
    SAVEFIELD FIELD FIELDSIZE CMOVE
    SAVEPSOKO @ PSOKO !
    SAVEMOVE# @ MOVE# !
    SAVEPUSH# @ PUSH# !
  THEN
;


\
\  ***** TRAVERSING THE PLAYING FIELD *****
\


0 1 IN/OUT
: REMAINING? ( -- numberOfRocksNotScored )
  \ In a win, there are no ROCKs, since they are all ROCKGs.
  \ We need to count all ROCKs.
  0
  MAXROWS 0 DO
    MAXCOLUMNS I * CHARS FIELD + \ address of row start
    COUNT 0 ?DO \ check each character in the line
      COUNT ROCK = IF SWAP 1+ SWAP THEN
    LOOP DROP \ the address
  LOOP
;

0 1 IN/OUT
: FIND_SOKO ( -- address, address in FIELD of the player )
  MAXROWS 0 DO
    MAXCOLUMNS I * CHARS FIELD + \ address of row start
    COUNT 0 ?DO \ check each character in the line
      COUNT DUP SOKO = SWAP SOKOG = OR IF UNLOOP UNLOOP 1- EXIT THEN
    LOOP DROP \ the address
  LOOP
  ." SOKO NOT FOUND!" BYE  \ FOR DEBUGGING
;


\
\  ***** SOKO (AND ROCK) MOTION ROUTINES ****
\


1 1 IN/OUT
: FREE? ( fieldAddress -- flag, true if soko/rock can move here )
  C@ CASE 
       AIR OF TRUE ENDOF
       GOAL OF TRUE ENDOF
       FALSE SWAP ENDCASE
;

1 1 IN/OUT
: ROCK? ( fieldAddress -- flag, true if is a rock )
  C@ CASE 
       ROCK OF TRUE ENDOF
       ROCKG OF TRUE ENDOF
       FALSE SWAP ENDCASE
;

1 1 IN/OUT
: GOAL? ( fieldAddress -- flag, true if it is a goal location )
  C@ CASE 
       GOAL OF TRUE ENDOF
       ROCKG OF TRUE ENDOF
       SOKOG OF TRUE ENDOF
       FALSE SWAP ENDCASE
;


VARIABLE VNEXT	\ next location routine address

\ all of these are ( address -- newAddress )

: NEXT_UP    MAXCOLUMNS CHARS -  ;
: NEXT_DOWN  MAXCOLUMNS CHARS +  ;
: NEXT_LEFT  1 CHARS -  ;
: NEXT_RIGHT CHAR+  ;

\ set the direction 
H: MAKE_DIRECTION ( no stack effects )
   CREATE  ' ,  DOES>  @ VNEXT ! ;

MAKE_DIRECTION UP    NEXT_UP
MAKE_DIRECTION DOWN  NEXT_DOWN
MAKE_DIRECTION RIGHT NEXT_RIGHT
MAKE_DIRECTION LEFT  NEXT_LEFT

0 1 IN/OUT
: NEXT  ( -- addressOfNextFieldLocation )
  PSOKO @ VNEXT @ EXECUTE ;

0 1 IN/OUT
: AFTERNEXT ( -- addressOfFieldLocationAfterNext )
  NEXT VNEXT @ EXECUTE ;

0 1 IN/OUT
: MOVE? ( -- flag, true if soko can move )
  NEXT FREE? IF TRUE EXIT THEN  \ all set if next character is free
  NEXT ROCK? IF AFTERNEXT FREE? EXIT THEN \ if a rock, look one beyond
  FALSE \ something else -- can't move
;

0 0 IN/OUT
: MOVE_SOKO ( -- )
  \ change character at original SOKO position
  PSOKO @ C@ SOKO = IF AIR ELSE GOAL THEN PSOKO @ C!
  \ is there a rock at the new soko position?
  NEXT ROCK? IF \ move the rock first
       1 PUSH# +!
       AFTERNEXT DUP C@ GOAL = IF ROCKG ELSE ROCK THEN SWAP C!
  THEN
  \ put soko at new position, watching for goal
  NEXT DUP GOAL? IF SOKOG ELSE SOKO THEN SWAP C!
  \ save new SOKO position
  NEXT PSOKO !
  \ increment the move number
  1 MOVE# +!
;

0 1 IN/OUT
: DO_MOVE ( -- flag, true if successful )
  MOVE? 
  DUP IF  \ success
       SAVE_FOR_UNDO
       MOVE_SOKO
  THEN
;

0 1 IN/OUT
: DO_MOVE_MAX ( -- flag, true if successful )
  MOVE?
  DUP IF \ we can do it
       SAVE_FOR_UNDO  \ allow MAJOR undo
       NEXT ROCK? IF  \ push until reaching wall
          BEGIN
	    MOVE_SOKO
	  MOVE? 0= UNTIL
       ELSE           \ move until touching wall or rock
          BEGIN
            MOVE_SOKO
          NEXT FREE? 0= UNTIL
       THEN
  THEN
;
 	    

\
\  ***** USER INTERFACE (INCLUDE LANGUAGE DEPENDENT FUNCTIONS) *****
\

\ this function might not work for some obscure character set

1 1 IN/OUT
: >UPPER ( character -- upperCaseCharacter )
  DUP [CHAR] a [CHAR] z 1+ WITHIN IF [CHAR] A + [CHAR] a - THEN
;


0 2 IN/OUT
: #IN?  ( -- number successFlag )
  \ returns an unsigned number and a flag indicating success
  0 0 \ for >NUMBER
  PAD DUP 80 ACCEPT \ Read in a line of input
  >NUMBER  IF C@ BL <> IF DROP FALSE EXIT THEN ELSE DROP THEN
  DROP TRUE
;


1 0 IN/OUT
: U.N ( unsigned -- , print with no trailing space )
  0 <# #S #> TYPE
;
1 0 IN/OUT

\ Command characters and prompts --
\  these can be altered at will, as long as there are no duplicates

CHAR q CONSTANT QUIT_GAME
CHAR U CONSTANT MOVE_UP_MAX
CHAR D CONSTANT MOVE_DOWN_MAX
CHAR L CONSTANT MOVE_LEFT_MAX
CHAR R CONSTANT MOVE_RIGHT_MAX
CHAR u CONSTANT MOVE_UP
CHAR d CONSTANT MOVE_DOWN
CHAR l CONSTANT MOVE_LEFT
CHAR r CONSTANT MOVE_RIGHT
CHAR x CONSTANT UNDO_MOVE
CHAR s CONSTANT SAVE_POSITION
CHAR z CONSTANT RESTORE_POSITION

0 1 IN/OUT
: Y/N? ( -- flag, accept only Y, TRUE, or N, FALSE as a response )
  ." (Y or N)?" EREOL
  BEGIN
    KEY DUP EMIT >UPPER
    DUP [CHAR] Y = SWAP [CHAR] N = OVER OR 0= WHILE
    DROP \ the flag
    CR ." INVALID CHOICE -- Specify `Y'es or `N'o:"
  REPEAT
;

0 0 IN/OUT
: ?INSTRUCTIONS ( -- )
  PAGE
  30 SPACES ." The Game of Sokoban" CR CR
  ." Do you want instructions " Y/N?
  CR CR
  0= IF ." Then on with the game..........." CR CR EXIT THEN
  \ display the instructions
."    Sokoban is a visual game of pushing.  You (Soko)  are represented by the"
CR
."    at-sign `@'.  You may move freely through the maze on unoccupied spaces."
CR
."    The dollar-signs `$'  are the rocks you have to push.  You can only push"
CR
."    one rock at a time,  and cannot push a rock through a wall  `#'  or over"
CR
."    another rock.  The object is to push the rocks to their goals  which are"
CR
."    indicated by periods `.'.  A rock on the goal looks like `*'.  There are"
CR
."    " MAXGAMES . ." levels to choose from." 
CR CR
."    Available moves  are indicated  on the display.  You are allowed to save"
CR
."    and restore your game state,  but cannot save more than one state at any"
CR
."    one time.  You can also undo your last move. The movement commands using"
CR
."    UPPERCASE letters will move to an object or push to the wall."
CR CR
."    A count of moves made  and rocks pushed is displayed  so you can attempt"
CR
."    to beat your previous or other players game scores.  A game score is the"
CR 
."    sum of the moves made and rocks pushed.
CR CR
."    Enjoy Sokoban!" 
CR CR
."    [Press any key to continue]" KEY DROP 
PAGE
;

0 1 IN/OUT
: GET_A_GAME_NUMBER ( -- validGameNumber )
    CR
    BEGIN ." Select game number (1 through " 
          MAXGAMES U.N
          ." ):"
       #IN? SWAP DUP 1 MAXGAMES 1+ WITHIN 0= ROT 0= OR WHILE
       DROP
       CR ." INVALID CHOICE, TRY AGAIN!  "
    REPEAT
;

0 0 IN/OUT
: PROMPT_MOVE ( -- )
  ?XY
  45 0 AT-XY C_ENH ." Available Commands" C_CMDS
  50 1 AT-XY QUIT_GAME EMIT ."   -quit"
  50 2 AT-XY SAVE_POSITION EMIT ."   -save" 
  50 3 AT-XY
  UP    MOVE? IF 
     MOVE_UP EMIT [CHAR] / EMIT MOVE_UP_MAX EMIT ." -up" 
  ELSE
     EREOL
  THEN
  50 4 AT-XY
  DOWN  MOVE? IF 
     MOVE_DOWN EMIT [CHAR] / EMIT 
     MOVE_DOWN_MAX EMIT ." -down" 
  ELSE
     EREOL
  THEN
  50 5 AT-XY
  LEFT  MOVE? IF 
     MOVE_LEFT EMIT [CHAR] / EMIT 
     MOVE_LEFT_MAX EMIT ." -left"
  ELSE
     EREOL
  THEN
  50 6 AT-XY
  RIGHT MOVE? IF 
     MOVE_RIGHT EMIT [CHAR] / EMIT 
     MOVE_RIGHT_MAX EMIT ." -right" 
  ELSE
     EREOL
  THEN
  50 7 AT-XY
  CAN_UNDO @ IF UNDO_MOVE EMIT ."   -undo"
  ELSE EREOL THEN
  50 8 AT-XY
  CAN_RESTORE @ IF RESTORE_POSITION EMIT ."   -restore"
  ELSE EREOL THEN
  AT-XY CR C_NORM
  ." Your move:" EREOL
;

0 1 IN/OUT
: NEWGAME? ( -- yesFlag )
  CRNOLF
  ." Play again "
  Y/N?
;

0 1 IN/OUT
: SURE_QUIT? ( -- yesFlag )
  CRNOLF  
  ." Are you sure you want to quit "
  Y/N?
;


0 0 IN/OUT
: PLAY_MSG   ( -- )
  C" Welcome to Sokoban -- it's your move." MESSAGE !
;


1 0 IN/OUT
: BAD_MOVE_MSG  ( character -- )
  \ Move message into a volatile memory area
  C" INVALID MOVE ' ', TRY AGAIN" 
  DUP C@ 1+  BAD_MOVE_BUFFER SWAP  CMOVE
  \ put bad command character into buffer
  BAD_MOVE_BUFFER  15 CHARS +  C!
  BAD_MOVE_BUFFER MESSAGE !
;

0 0 IN/OUT
: WIN_MSG  ( -- )
  C" ***** You WIN! *****"  MESSAGE !
;

0 0 IN/OUT
: NO_MSG  ( -- )
  0 MESSAGE !
;

0 0 IN/OUT
: SAVED_MSG  ( -- )
  C" Game state is saved" MESSAGE !
;

0 0 IN/OUT
: RESTORED_MSG  ( -- )
  C" Game state is restored" MESSAGE !
;

0 0 IN/OUT
: UNDO_MSG  ( -- )
  C" Last move undone" MESSAGE !
;

1 0 IN/OUT
: PRINT_ELEMENT ( character -- )
  DUP CASE  
        WALL OF C_WALL ENDOF
        ROCK OF C_ROCK ENDOF
        SOKO OF C_SOKO ENDOF
        GOAL OF C_GOAL ENDOF
        ROCKG OF C_ROCKG ENDOF
        SOKOG OF C_SOKO DROP SOKO ENDOF
        VOID OF C_NORM  DROP BL ENDOF
        \ air - doesn't involve color change
  ENDCASE
  EMIT
;

0 1 IN/OUT
: PRINT_FIELD ( -- winningPositionFlag , true if displays a win )
  0 0 AT-XY
  MAXROWS 0 DO
    MAXCOLUMNS I * CHARS FIELD + \ address of row start
    COUNT ?DUP IF \ row has contents
      ?XY NIP 20 SWAP AT-XY
      0 DO COUNT PRINT_ELEMENT LOOP
      CR
      DROP \ the address
    ELSE DROP LEAVE THEN \ leave the loop if empty row reached
  LOOP
  C_NORM
  CR ?XY
  0 0 AT-XY C_MSG ." >>SOKOBAN<<"  C_NORM
  0 1 AT-XY ." GAME NUMBER"  C_ENH  
  2 2 AT-XY GAME# @ 5 U.R  C_NORM
  0 3 AT-XY  ." MOVES"  C_ENH  
  2 4 AT-XY MOVE# @ 5 U.R  C_NORM
  0 5 AT-XY ." ROCK PUSHES"  C_ENH  
  2 6 AT-XY PUSH# @ 5 U.R  C_NORM
  0 7 AT-XY ." ROCKS NOT AT GOALS"  C_ENH  
  2 8 AT-XY REMAINING? DUP 5 U.R  C_NORM 
  -ROT AT-XY
  0= DUP IF WIN_MSG THEN \ make message WIN_MSG if game is in winning position
  MESSAGE @ ?DUP IF C_MSG COUNT TYPE C_NORM THEN EREOL
; 


0 0 IN/OUT
: PRINT_LOW_SCORES ( -- )
  PAGE
  22 SPACES 
  ." TABLE OF WINNING LOW SCORES"
  CR
  0 \ entries on current line
  MAXGAMES 0 DO
     I LOWSCORE @ DUP -1 <> IF    \ found one!
        SWAP DUP 4 = IF DROP 0 CR THEN  \ new line if necessary
        SWAP 
        ." Game#" I 1+ 2 .R  BL EMIT   \ game number
        4 .R BL EMIT                    \ the score
        I WHOSCORE #INITIALS TYPE       \ initials
        2 SPACES
        1+				\ one more entry on line
     ELSE
        DROP				\ the lowscore
     THEN
  LOOP
  DROP \ entries
  CR
;


0 0 IN/OUT
: CHECK&ADD_WINNER ( -- )
      CR EREOL CR 
      MOVE# @ PUSH# @ +   \ current score
      DUP  GAME# @ 1- LOWSCORE @ U< IF \ new winner!
           GAME# @ 1- LOWSCORE !
           ." Your initials for the WINNERS table:" EREOL
           GAME# @ 1- WHOSCORE   \ address of whoscored table entry
           DUP #INITIALS BL FILL \ blank fill first
           PAD #INITIALS ACCEPT  \ then read in up to three initials
           PAD ROT ROT CMOVE     \ move into the whoscored table
           CR
           WRITE_LOW_SCORES      \ write out now!
      ELSE DROP \ the score
      THEN
;

  
\ THE REMAINING FUNCTIONS PLAY THE GAME AND ARE NOT LANGUAGE DEPENDENT


1 1 IN/OUT
: MOVE_ACTION ( commandCharacter -- successFlag )
  CASE MOVE_UP    OF UP    DO_MOVE ENDOF
       MOVE_DOWN  OF DOWN  DO_MOVE ENDOF
       MOVE_LEFT  OF LEFT  DO_MOVE ENDOF
       MOVE_RIGHT OF RIGHT DO_MOVE ENDOF
       MOVE_UP_MAX    OF UP    DO_MOVE_MAX ENDOF
       MOVE_DOWN_MAX  OF DOWN  DO_MOVE_MAX ENDOF
       MOVE_LEFT_MAX  OF LEFT  DO_MOVE_MAX ENDOF
       MOVE_RIGHT_MAX OF RIGHT DO_MOVE_MAX ENDOF
       SAVE_POSITION OF SAVE_FOR_RESTORE SAVED_MSG TRUE ENDOF
       UNDO_MOVE        OF DO_UNDO    DUP IF UNDO_MSG THEN     ENDOF
       RESTORE_POSITION OF DO_RESTORE DUP IF RESTORED_MSG THEN ENDOF
       FALSE SWAP \ anything else indicate failure
  ENDCASE
;

0 0 IN/OUT
: PLAY_UNTIL_WIN_OR_QUIT ( -- )
  \ this is the user command interface
  BEGIN 
     PROMPT_MOVE
     NO_MSG \ default to no message
     KEY  DUP LASTCMD !  DUP QUIT_GAME = IF
        SURE_QUIT? 0=
     ELSE
        TRUE
     THEN
     \ leave if QUIT_GAME character hit, and action is verified 
  WHILE
     MOVE_ACTION IF \ success
        PRINT_FIELD IF 
           CHECK&ADD_WINNER \ Game has been won
           EXIT 
        THEN
     ELSE
        LASTCMD @ BAD_MOVE_MSG
	PRINT_FIELD DROP
     THEN
  REPEAT
  DROP \ the "Q"
;
   

: MAIN ( -- )
  ?INSTRUCTIONS
  READ_LOW_SCORES
  BEGIN
    PRINT_LOW_SCORES
    GET_A_GAME_NUMBER  DUP GAME# !  INIT_GAME 
    0 MOVE# !		\ reset move number
    0 PUSH# !           \ reset push number
    FALSE CAN_UNDO !    \ nothing saved when we start
    FALSE CAN_RESTORE !
    FIND_SOKO PSOKO !	\ initialize Soko location
    PAGE
    PLAY_MSG
    PRINT_FIELD DROP    \ show initial playing field
    PLAY_UNTIL_WIN_OR_QUIT
  NEWGAME? 0= UNTIL
;

INCLUDE FILES2
INCLUDE DISPLAY2
INCLUDE FACIL2
INCLUDE FORTHLIB
END
