	page 60,132
	title	DEMO0 - A STARTUP0 Demonstration Program MAIN Procedure
	name	DEMO0
comment 
	DEMO0							V1.00
==========================================================================
NAME
	DEMO0		A STARTUP0 Demonstration Program MAIN Procedure

DESCRIPTION
	This is the main procedure for a STARTUP0 demonstration program.
	This procedure displays all the global variables initialized by
	STARTUP0.

CAUTIONS
	None

RETURNS
	Zero - always

PROGRAMMING NOTES
        Assembled with Microsoft MASM V6.11d

	Written to be assembled in any memory model

REGISTER USAGE
	All

MEMORY UTILIZATION
	Not calculated

EXTERNAL LIBRARIES
	Hex2Bin 		alib?
	Print			alib?
	Puts			alib?
	Stack_Check		alib?
	Startup_0		alib?	; non-tiny memory models only
	Utoa			alib?

EXTERNAL PROCEDURES
	None

INTERRUPTS CALLED
	None

GLOBAL NAMES
	Main

AUTHOR
        Raymond Moon - 6 Oct 95
	Copyright (c) 1995, MoonWare
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
        1.00    -  6 Oct 95     - Orginal

==========================================================================
	 Comment End
	
;-----------------------------
; A	Make the small memory model the default

ifndef	memmod
memmod	equ	<small>
endif

;-----------------------------
; B	Include the processor, memory model, associate ES register with
;	DGROUP, and specify DOS segment order.

	include procesor.inc
%	.MODEL	memmod,FORTRAN
	assume	es:DGROUP
	.dosseg

;-----------------------------
; C	Include files

	include startup.inc
	include lib.inc

;=========================================================================
;	DATA
;=========================================================================
; D	Define required equates

CR	equ	13
LF	equ	10
NULL	equ	 0

	.CONST

LOGO		byte	"STARTUP0.ASM Demonstration Program", CR, LF,
			"Copyright (c) 1995, MoonWare", CR, LF, LF,
			"The memory model is ", NULL
szDGRP		byte	"The value of DGROUP is: 0x", NULL
szPSP		byte	"The value of PSP is: 0x", NULL
szSTACK_BOTTOM	byte	"The value of STACK_BOTTOM is: 0x", NULL
szENVIRON	byte	"The value of ENVIRON is: 0x", NULL
szENV_STR_LEN	byte	"The length of ENVIRON is: ", NULL
szOSMAJOR	byte	"The OS major value is: ", NULL
szOSMINOR	byte	"The OS minor value is: ", NULL
szNEXTPARA	byte	"The value for the next memory paragraph is: 0x", NULL
if	@Model	EQ 1
szMEMMODEL	byte	"Tiny.", NULL
elseif	@Model	EQ 2
szMEMMODEL	byte	"Small.", NULL
elseif	@Model	EQ 3
szMEMMODEL	byte	"Compact.", NULL
elseif	@Model	EQ 4
szMEMMODEL	byte	"Medium.", NULL
elseif	@Model	EQ 5
szMEMMODEL	byte	"Large.", NULL
elseif	@Model	EQ 6
szMEMMODEL	byte	"Huge.", NULL
endif

	.DATA?

szTEMP		byte	6 dup (?)

;=========================================================================
;	CODE
;=========================================================================
; E	Start the Start_Up0 code.  Start CODE segment with the proper
;	relationship with external procedures.

if	@CodeSize
extrn	Start_Up0:FAR
.CODE
Main	proc	far
else
.CODE
extrn	Start_Up0:NEAR
Main	proc	near
endif

;----------------------------
; F	Call Stack Check if DEBUG is defined.

ifdef	DEBUG
	call	Stack_Check
endif

;----------------------------
; G	Display LOGO

	mov	dx, offset LOGO
	call	Print

;----------------------------
; H	Display Memory model

	mov	dx, offset szMEMMODEL
	call	Puts

;----------------------------
; I	Display the DGROUP segment value

	mov	dx, offset szDGRP
	call	Print
	mov	di, offset szTEMP
	mov	dx, DGRP
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; J	Display the PSP segment value

	mov	dx, offset szPSP
	call	Print
	mov	di, offset szTEMP
	mov	dx, PSP
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; K	Display the NEXTPARA segment value

	mov	dx, offset szNEXTPARA
	call	Print
	mov	di, offset szTEMP
	mov	dx, NEXTPARA
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; L	Display the STACK_BOTTOM value

	mov	dx, offset szSTACK_BOTTOM
	call	Print
	mov	di, offset szTEMP
	mov	dx, STACK_BOTTOM
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; M	Display the ENVIRON segment value

	mov	dx, offset szENVIRON
	call	Print
	mov	di, offset szTEMP
	mov	dx, ENVIRON
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; N	Display the OSMAJOR value

	mov	dx, offset szOSMAJOR
	call	Print
	mov	al, OSMAJOR
	xor	ah, ah
	mov	di, offset szTEMP
	call	Utoa
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; O	Display the OSMINOR value

	mov	dx, offset szOSMINOR
	call	Print
	mov	al, OSMINOR
	xor	ah, ah
	mov	di, offset szTEMP
	call	Utoa
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; P	Return with 0 return code.

	xor	al, al
	ret

Main	endp
	end
