	page 60, 132
	title	UTOA - Unsigned Integer to ASCIIZ
	name	UTOA
comment 
	UTOA							V1.00
==========================================================================
NAME
	UTOA - Unsigned Integer to ASCIIZ

SYNOPSIS
	mov	ax, seg TargetString	; If large data model
	mov	es, ax
	mov	di, TargetString
	mov	ax, SourceInteger
	call	UTOA

DESCRIPTION
	This procedure converts a binary unsigned integer into an ASCIIZ
	string.

	The unsigned integer to be converted is passed in the AX register.
	The ES:DI register pair must point to the destination string which
	is overwritten by the result.  The destination string must be at
	least six characters in length.

CAUTION
	If the destination string is not at least six characters in length,
	UTOA may write beyond the end of the string.  No checking is done
	within UTOA.

RETURNS
	Nothing

PROGRAMMING NOTES
	Assembled with Microsoft MASM V6.11a

	Use MEMMOD to specify the memory model.
	/dMEMMOD=TINY|SMALL|COMPACT|MEDIUM|LARGE|HUGE

REGISTER USAGE
	Small Data Memory Models:
	AX, BX, CX and DX are used.

MEMORY UTILIZATION
	DATA
		None

	CODE
					8086	80286+
		Small Code Model:		 47
		Large Code Model:		 47

	STACK
		Small Code Model:		 10
		Large Code Model:		 12

EXTERNAL LIBRARIES
	None
	
EXTERNAL PROCEDURES
	None

INTERUPTS CALLED
	None

GLOBAL NAMES
	UTOA - Procedure Name

AUTHOR
	Raymond Moon - 6 Oct 95

	Copyright (c) 1995 - Raymond Moon
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
	1.00	-  6 Oct 95	- Orginal
==========================================================================
	 Commend End

;----------------------------
;	Make the small memory model the default.

ifndef	memmod
memmod	equ	<small>
endif

;----------------------------
;	Specify processor, memory model, language and ES register assume. 

	include procesor.inc			; Specify target processor
%	.model memmod, fortran
	assume es:DGROUP

;=========================================================================
;	CODE
;=========================================================================
;	Start Code Segment, define UTOA procedure, and declare local TEMP
;	variable for storage on intermediate result.

	.CODE

UTOA	proc
local	TEMP[6]:byte			; Create temp storage for result

;----------------------------
;	Set up CX as the divisor.  Converting to base 10 so CX = 10.
;	Set up temporary storage for intermediary result; BX => TEMP.
;	Load null terminator into TEMP.  Clear DX as DX:AX is the dividend.

	mov	cx, 10			; BX = 10 -- the divisor
	xor	dx, dx			; Clear upper bits
	lea	bx, TEMP		; BX => TEMP
	mov	[bx], dl		; Add null terminator
	inc	bx			; Account for null

;----------------------------
;	AX = value to convert.	Loop through by dividing by 10, converting
;	the remainder to ASCII and saving until the quotient is zero.

UA1:	div	cx			; AX = Quotient/DX = remainder
	or	dl, 30h			; Convert to ASCII
	mov	[bx], dl		; Store it
	inc	bx			; BX => next char
	xor	dx, dx			; Null upper bytes
	or	ax, ax			; Is the Quotient == 0?
	jnz	UA1			; No, continue

;----------------------------
;	The integer has been converted but is in reverse order in TEMP.
;	Now, rewrite it in the proper order in the destination.  CX is
;	number of chars to copy - Remember the terminating null must be
;	copied also.

	mov	cx, bx			; CX => last char + 1
	lea	ax, TEMP		; AX => first char
	sub	cx, ax			; CX => string length + null
	dec	bx			; BX => last char
UA2:	mov	al, [bx]		; AL = char
	dec	bx			; BX => next char
	stosb				; Store it
	loop	UA2

;----------------------------
;	Return

	ret
UTOA	endp
	end
