	page 60,132
	title	MAIN3 - A STARTUP3 Demonstration Program
comment 
	MAIN3							V1.00
==========================================================================
NAME
	MAIN3 - The Main Procedure for a STARTUP3 Demonstration Program

DESCRIPTION
	This is the main procedure for a STARTUP3 demonstration program.
	This procedure displays all the global variables initialized by
	STARTUP3, program name, all command line argruments, and
	environmental strings.

CAUTIONS
	None

RETURNS
	Zero - always

PROGRAMMING NOTES
        Assembled with Microsoft MASM V6.11d

REGISTER USAGE
	All

MEMORY UTILIZATION
	Not calculated

EXTERNAL LIBRARIES
	Hex2Bin 		alib?
	Print			alib?
	Puts			alib?
	Stack_Check		alib?
	Startup_3/Startup_3S	alib?	Depends if SIMPLE is defined
	Utoa			alib?

EXTERNAL PROCEDURES
	None

INTERRUPTS CALLED
	None

GLOBAL NAMES
	Main

AUTHOR
        Raymond Moon - 6 Oct 95
	Copyright (c) 1995, MoonWare
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
	1.00	-  6 Oct 95	- Orginal

==========================================================================
	 Comment End

;-----------------------------
; A     Make the small memory model the default

ifndef	memmod
memmod	equ	<small>
endif
               
;-----------------------------
; B     Include the processor, memory model, associate ES register with
;       DGROUP, and specify DOS segment order.

	include procesor.inc
%	.MODEL	memmod,FORTRAN
	assume	es:DGROUP
	.dosseg

;-----------------------------
; C     Include files

	include startup.inc
	include lib.inc

;=========================================================================
; D     MACROS
;=========================================================================

@LES	macro	reg, address	;; Data Model independent les instruction
if @DataSize
	les     reg, address
else
	mov     reg, address
endif
endm

;=========================================================================
;	DATA
;=========================================================================
; E     Define required equates

CR	equ	13
LF	equ	10
NULL	equ	 0

If @DataSize
	ShiftCount	equ	2
else
	ShiftCount	equ	1
endif

	.CONST

sLOGO		byte	"STARTUP1/2 ASM Demonstration Program", CR, LF,
			"Copyright (c) 1995, MoonWare", CR, LF, LF,
			"The memory model is ", NULL
szARGADDRESSING byte	"ARGC/ARGV[] addressing is ", NULL

Ifdef SIMPLE
szADDRTYPE	byte	"SIMPLE", NULL
else
szADDRTYPE	byte	"NORMAL", NULL
endif

szDGRP		byte	"The value of DGroup is: 0x", NULL
szPSP		byte	"The value of PSP is: 0x", NULL
szSTACK_BOTTOM	byte	"The value of STACK_BOTTOM is: 0x", NULL
szENVIRON	byte	"The value of ENVIRON is: 0x", NULL
szENV_STR_LEN	byte	"The length of ENVIRON is: ", NULL
szOSMAJOR	byte	"The OS major value is: ", NULL
szOSMINOR	byte	"The OS minor value is: ", NULL
szNEXTPARA	byte	"The value for the next memory paragraph is: 0x", NULL
if	@Model	EQ 1
szMEMMODEL	byte	"Tiny.", NULL
elseif	@Model	EQ 2
szMEMMODEL	byte	"Small.", NULL
elseif	@Model	EQ 3
szMEMMODEL	byte	"Compact.", NULL
elseif	@Model	EQ 4
szMEMMODEL	byte	"Medium.", NULL
elseif	@Model	EQ 5
szMEMMODEL	byte	"Large.", NULL
elseif	@Model	EQ 6
szMEMMODEL	byte	"Huge.", NULL
endif
szARGCOUNT	byte	"The value of argc is: ", NULL
szARGV		byte	"The argv[] strings are: ", NULL
szNONE		byte	"None", NULL
szENVIRONSTRS	byte	"The Environmental Strings are: ", NULL

	.DATA?

szTemp		byte	6 dup (?)

;=========================================================================
;	CODE
;=========================================================================
; F     Start the Start_Up code.  Start CODE segment with the proper
;	relationship with external procedures.

ifdef SIMPLE
Start_Up3	equ	<Start_Up3S>
endif

if @CodeSize
extrn	Start_Up3:FAR
.CODE
else
.CODE
extrn	Start_Up3:NEAR
endif

;----------------------------
; G     Select the proper arguments for the startup code.  The order is
;	different for SIMPLE than NORMAL.

ifdef	SIMPLE
Main	proc	ARGV:ptr, ARGC:word, ENVR:ptr
else
Main	proc	ARGC:word, ARGV:ptr, ENVR:ptr
endif

local	COUNT:word

;----------------------------
; H     Call Stack Check if DEBUG is defined.

ifdef	DEBUG
	call	Stack_Check
endif

;----------------------------
; I     Display LOGO and Memory Model string.

	mov	dx, offset sLOGO
	call	Print

;----------------------------
; J     Display Memory model

	mov	dx, offset szMEMMODEL
	call	Puts

;----------------------------
; K     Display ARGC/ARGV[] addressing type

	mov	dx, offset szARGADDRESSING
	call	Print
	mov	dx, offset szADDRTYPE
	call	Puts

;----------------------------
; L     Display the other values.  Each one consists of displaying the
;	explanation string, converting the value, and lastly, display
;	it.
;
;	Start with DGRP

	mov	dx, offset szDGRP
	call	Print
	mov	di, offset szTEMP
	mov	dx, DGRP
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; M     Display the PSP

	mov	dx, offset szPSP
	call	Print
	mov	di, offset szTEMP
	mov	dx, PSP
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; N     Display the value of next free paragraph

	mov	dx, offset szNEXTPARA
	call	Print
	mov	di, offset szTEMP
	mov	dx, NEXTPARA
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; O     Display the STACK_BOTTOM

	mov	dx, offset szSTACK_BOTTOM
	call	Print
	mov	di, offset szTEMP
	mov	dx, STACK_BOTTOM
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; P     Display the ENVIRON

	mov	dx, offset szENVIRON
	call	Print
	mov	di, offset szTEMP
	mov	dx, ENVIRON
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; Q     Display the ENV_STR_LEN

	mov	dx, offset szENV_STR_LEN
	call	Print
	mov	ax, ENV_STR_LEN
	mov	di, offset szTEMP
	call	Utoa
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; R     Display the OSMAJOR

	mov	dx, offset szOSMAJOR
	call	Print
	mov	al, OSMAJOR
	xor	ah, ah
	mov	di, offset szTEMP
	call	Utoa
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; S     Display the OSMINOR

	mov	dx, offset szOSMINOR
	call	Print
	mov	al, OSMINOR
	xor	ah, ah
	mov	di, offset szTEMP
	call	Utoa
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; T     Display the number of command line arguments

	mov	dx, offset szARGCOUNT
	call	Print
	mov	ax, ARGC
	mov	di, offset szTEMP
	call	Utoa
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; U     Display the Command Line argument lead in line.  If none, skip.

	or	ARGC, 0 			; Is ARGC == 0?
	je	MN3
	mov	dx, offset szARGV
	call	Puts

;----------------------------
; V     Display all the command line arguments, one to a line.

	mov	COUNT, 0		; Initialize COUNT
MN1:	mov	ax, COUNT		; AX = COUNT, source
	mov	di, offset szTEMP	; DI => szTEMP, target
	call	Utoa			; Convert to ASCIIZ string

;---------------------------
; W     Convert the format of string to xx:(null).  If there is only one
;	digit, move it over one.

	mov	si, offset szTEMP	; SI => szTEMP
	cmp	byte ptr [si + 1], 0	; Is the 2nd char null?
	jne	MN2			; No, skip special case

;---------------------------
; X     The format is x(null).  Convert to bx where b is a blank.

	mov	al, [si]		; AL = char
	mov	[si + 1], al		; Move complete
	mov	byte ptr [si], ' '	; Blank first char

;---------------------------
; Y     Add colon, space and null terminator

MN2:	mov	word ptr [si + 2], ' :' ; Add the ': '
	mov	byte ptr [si + 4], 0	; Null terminate

;----------------------------
; Z     Display the leader

	mov	dx, si
	call	Print

;----------------------------
; AA    Display the corresponding *argv[].  Must be done two ways.  First,
;	for the Normal, then for the Simple.
;
;	For the Normal, it really is argv.

	mov	di, COUNT		; BX = COUNT
	shl	di, ShiftCount		; Convert to word/dword pointer
ifndef	SIMPLE
	@LES	bx, ARGV		; BX => ARGV[]
	mov	dx, [di][bx]		; DX => *ARGV[count]
else
	@LES	dx, ARGV[di]
endif
	call	Puts			; Display it
if @DataSize
	mov	es, DGRP		; Restore ES
endif

;----------------------------
; AB    See if we are complete.

	inc	COUNT			; Increment COUNT
	mov	ax, COUNT		; AX = COUNT
	cmp	ax, ARGC		; Is AX < ARGC
	jl	MN1			; Yes, continue

;----------------------------
; AC    Display the Environmental Strings.  Start with displaying lead in
;	line

MN3:	mov	dx, offset szENVIRONSTRS
	call	Puts			; Display it

;----------------------------
; AD    Determine if there are any environmental strings

	mov	COUNT, 0		; Initialize COUNT
	mov	di, COUNT		; BX = COUNT
	shl	di, ShiftCount		; Convert to word/dword pointer
	@LES	bx, ENVR		; BX => ENVR[]
	or	word ptr [di][bx], 0	; Is the pointer null?
	jnz	MN4			; No, continue

;----------------------------
; AE    Display None and skip

	mov	di, offset szNONE	; DI => szNONE
	call	PRINT			; Display
	jmp	MN6

;----------------------------
; AF    Display all the environmental strings, one to a line.

MN4:	mov	ax, COUNT		; AX = COUNT, source
	mov	di, offset szTEMP	; DI => szTEMP, target
	call	Utoa			; Convert to ASCIIZ string

;---------------------------
; AG    Convert the format of string to xx:(null).  If there is only one
;	digit, move it over one.

	mov	si, offset szTEMP	; SI => szTEMP
	cmp	byte ptr [si + 1], 0	; Is the 2nd char null?
	jne	MN5			; No, skip special case

;---------------------------
; AH    The format is x(null).  Convert to bx where b is a blank.

	mov	al, [si]		; AL = char
	mov	[si + 1], al		; Move complete
	mov	byte ptr [si], ' '	; Blank first char

;---------------------------
; AI    Add colon, space and null terminator

MN5:	mov	word ptr [si + 2], ' :' ; Add the ': '
	mov	byte ptr [si + 4], 0	; Null terminate

;----------------------------
; AJ    Display the leader

	mov	dx, si
	call	Print

;----------------------------
; AK    Display the corresponding *argv[].  Must be done two ways.  First,
;	for the Normal, then for the Simple.
;
;	For the Normal, it really is argv.

	mov	di, COUNT		; BX = COUNT
	shl	di, ShiftCount		; Convert to word/dword pointer
	@LES	bx, ENVR		; BX => ENVR[]
	mov	dx, [di][bx]		; DX => *ENVR[count]
	call	Puts			; Display it
if @DataSize
	mov	es, DGRP		; Restore ES
endif

;----------------------------
; AL    See if we are complete.

	inc	COUNT			; Increase COUNT
	mov	di, COUNT		; BX = COUNT
	shl	di, ShiftCount		; Convert to word/dword pointer
	@LES	bx, ENVR		; BX => ENVR[]
	or	word ptr [bx][di], 0	; Is the next pointer null?
	jnz	MN4			; No, continue

;----------------------------
; AM    Return with 0 return code.

MN6:	xor	al, al
	ret

Main	endp
	end
