; test.asm
;
; simple test driver routine to show how to use parallel I/O library
;
; written on Wed  06-19-1996  by Ed Beroset
;   and released to the public domain by the author
;

COMMENT ^

This should be fairly self-explanatory, but here's how you use this thing. 
Here's a batch file to assemble and link:

rem Borland's TASM and TLINK are assumed to be on the path
tasm /la /m2 parallel.asm
tasm /la /m2 test.asm
tlink /m /s test.obj parallel.obj;

That should produce TEST.EXE which is a simple bi-directional program which
allows two machines connected back-to-back via parallel ports to communicate. 
Everything typed on one machine appears on the other's screen and vice versa. 
The parallel cable is the same sort used by Laplink, Interlnk, Win95 Direct
Connect, etc. and any parallel port will work (even cheap, old and poorly
designed ones like I've got!) so no special hardware is needed.  Note that only
BIOS services are used -- this code is completely operating system independent
and can even run from a boot sector with no operating system (obviously, you'd
have to change it to a binary without relocatable segments, but it does work).  

The test driver is disposable code, a simple implementation to show how to use
the library code which is the real meat of the program.  As much as possible,
the library implementation is hidden from the application programmer's view, so
a program could use an interface for parallel, serial, or other kind of
communication simply by swapping in a new library.

-> Ed <-

COMMENT ENDS^


        IDEAL
        MODEL small
        P286
        STACK 400h


        DATASEG

K_ESC = 1bh

        CODESEG

        extrn Init:proc
        extrn SendChar:proc
        extrn ReadChar:proc
        extrn IsTransmitReady:proc
        extrn updateTX:proc
        extrn updateRX:proc

MACRO CheckKbd
        mov     ah,1
        int     16h
ENDM

MACRO FetchKey
        mov     ah,0
        int     16h
ENDM

PROC main
        STARTUPCODE
        mov     ax,40h          ; get info from BIOS data area
        mov     es,ax           ;
        mov     bx,8            ; first parallel port base I/O address
        mov     dx,[es:bx]      ; load base I/O address into dx
        or      dx,dx           ; Q: valid parallel port?
        jz      exit            ;  N: we can't run this program
        call    Init
top:
        CheckKbd                ; Q: keystroke ready?
        jz      check_tx        ;  N: nope, so continue
        call    IsTransmitReady ; Q: is transmitter ready for data?
        jnz     check_tx        ; N: we can't yet fetch keystroke
        FetchKey                ; fetch keypress (ASCII code in AL)
        cmp     al,K_ESC
        jz      exit            ; allow bail out
        call    SendChar        ;
check_tx:
        call    updateTX
        call    updateRX
        jnz     top             ; keep going if no char ready
        call    ReadChar        ;
        call    PrintLetter     ;
        jmp     top
exit:
        EXITCODE
ENDP main

;
; PrintLetter
;
; prints the ASCII letter passed in via AL to the output device
;
; Entry:
;       al = letter to be printed
;
; Exit:
;       no change
;
; Trashed:
;       flags may be altered
;
PROC PrintLetter
        push    ax bx           ; save regs
        mov     bx,0007h        ; video page 0, white on black
        mov     ah,0eh          ; use video BIOS char output routine
        int     10h             ; do it now
        pop     bx ax           ; restore registers
        ret
ENDP PrintLetter

        END main

