;---------------------------------------------------------------------
; MANDEL - Mandelbrot Set generator, 74 bytes! - Tylisha C. Andersen
;---------------------------------------------------------------------

.model tiny
.code
org 100h

;---------------------------------------------------------------------

main:   mov   ax, 13h           ; set video mode 13h
        int   10h               ;
        mov   ax, 0A000h        ; es = mode 13h video memory
        mov   es, ax            ;
                                ;
        xor   di, di            ; di = 0
        mov   cx, 200           ; initialize y, for each of 200 rows:
m_1:    mov   si, 320           ; initialize x, for each of 320 columns:
m_2:    mov   bp, 103           ; init color counter
        xor   bx, bx            ; zero i, j coefficients
        xor   dx, dx            ; these are 8.8 bit fixed point values
                                ;
m_3:    push  dx                ; save j
        mov   ax, bx            ; ax = i - j
        sub   ax, dx            ;
        add   dx, bx            ; dx = i + j
        imul  dx                ; dx:ax = (i-j) * (i+j) = i^2 - j^2
        mov   al, ah            ; ax = 8.8 fixed point version
        mov   ah, dl            ;
        pop   dx                ; restore j
        xchg  bx, ax            ; bx = new i, ax = old i
        sub   bx, si            ; final new i:  i = (i^2 - j^2) - x
                                ;
        imul  dx                ; dx:ax = i * j
        mov   dh, dl            ; dx = 8.8 fixed point version
        mov   dl, ah            ;
        add   dx, dx            ; dx = 2 * i * j
        sub   dx, cx            ; final new j:  j = (2 * i * j) - y
                                ;
        test  dh, dh            ; if it has moved out of range, then
        jg    m_4               ; go draw this pixel
        dec   bp                ; decrement color
        jnz   m_3               ; loop (color loop)
                                ;
m_4:    xchg  ax, bp            ; get color in al
        stosb                   ; write pixel to screen
        dec   si                ; loop (x loop)
        jnz   m_2               ;
        loop  m_1               ; loop (y loop)
                                ;
        int   16h               ; wait for a key
        mov   ax, 3             ; restore text mode
        int   10h               ;
        ret                     ; return to DOS

end main
