IFNDEF BufWidth
BufWidth        EQU     320
ENDIF

.386
.model flat
.code


;#############################################################################

; Watcom C declaration:
;
;   void LifeASM(byte *Destination, byte *Source, dword Size);
;   #pragma aux LifeASM "*" parm caller [edi][esi][ecx] modify [eax ecx edx ebx esi edi];

;-----------------------------------------------------------------------------

LifeASM         PROC
                push    ebp
                shr     ecx, 2
                mov     eax, [esi - 1]
                mov     edx, [esi - 1 - BufWidth]
                add     eax, edx
                mov     edx, [esi - 1 + BufWidth]
                add     eax, edx
                xor     ebx, ebx
                jmp     LoopPt

FastLoop:       or      eax, eax
                jnz     ReEnt
                mov     [edi], ebx
                add     esi, 4
                add     edi, 4
                dec     ecx
                jz      ExitPt

LoopPt:         mov     ebp, [esi + 4 - 1]
                mov     edx, [esi + 4 - 1 - BufWidth]
                add     ebp, edx
                mov     edx, [esi + 4 - 1 + BufWidth]
                add     ebp, edx
                jz      FastLoop
ReEnt:          mov     edx, eax
                shrd    eax, ebp, 8
                ror     ebp, 8
                add     edx, eax
                shrd    eax, ebp, 8
                rol     ebp, 8
                add     eax, edx
                mov     edx, [esi]
                sub     eax, edx
                jz      DeadCell4

                cmp     al, 3
                ja      DeadCell1
                je      LiveCell1
                add     al, dl
                cmp     al, 3
                jb      DeadCell1
LiveCell1:      inc     bl
DeadCell1:      cmp     ah, 3
                ja      DeadCell2
                je      LiveCell2
                add     ah, dh
                cmp     ah, 3
                jb      DeadCell2
LiveCell2:      inc     bh
DeadCell2:      shr     eax, 16
                shr     edx, 16

                cmp     al, 3
                ja      DeadCell3
                je      LiveCell3
                add     al, dl
                cmp     al, 3
                jb      DeadCell3
LiveCell3:      add     ebx, 00010000h
DeadCell3:      cmp     ah, 3
                ja      DeadCell4
                je      LiveCell4
                add     ah, dh
                cmp     ah, 3
                jb      DeadCell4
LiveCell4:      add     ebx, 01000000h
DeadCell4:      mov     [edi], ebx
                add     esi, 4
                add     edi, 4
                mov     eax, ebp
                xor     ebx, ebx
                dec     ecx
ExitPt:         jnz     LoopPt
                pop     ebp
                ret
LifeASM         ENDP

;#############################################################################

                PUBLIC  LifeASM
END

