package Buffer_Package is

  task type Buffer is
    entry Append(I: in  Integer);
    entry Take  (I: out Integer);
  end Buffer;

  procedure Append(B: Buffer; I: in  Integer);
  procedure Take  (B: Buffer; I: out Integer);

end Buffer_Package;

package body Buffer_Package is
  N: constant Integer := 10;

  task body Buffer is
    B: array(0..N-1) of Integer;
    In_Ptr, Out_Ptr: Integer := 0;
    Count: Integer := 0;
     
  begin
    loop
      select
        when Count < N =>
          accept Append(I: in Integer) do
            B(In_Ptr) := I;
          end Append;
        Count := Count + 1;
        In_Ptr := (In_Ptr + 1) mod N;
      or
        when Count > 0 =>
         accept Take(I: out Integer) do
           I := B(Out_Ptr);
          end Take;
        Count := Count - 1;
        Out_Ptr := (Out_Ptr + 1) mod N;
      end select;
    end loop;
  end Buffer;

  procedure Append(B: Buffer; I: in  Integer) is
  begin
    B.Append(I);
  end Append;

  procedure Take  (B: Buffer; I: out Integer) is
  begin
    B.Take(I);
  end Take;

end Buffer_Package;
