#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>


extern void patch(unsigned long int address, unsigned char origbyte, unsigned char patchbyte, FILE *target, int no_orig, int restore, int zeile, int reset_patchanyway);  // patch.c
extern long int GetFilesize(FILE *target);  // check.c
extern unsigned int GetCRC(FILE *target);  // check.c
extern long int LHex2Dez(char *hex);  // misc.c


void ProcessDatafile(FILE *datafile, int tfoverride, char *tfname, int restore);
void InterpretMessage(char *dataline);
void InterpretExecute(char *dataline);
FILE *InterpretFilename(char *dataline, int tfoverride, char *tfname, int files);
void InterpretChecksum(char *dataline, FILE *target);
void InterpretFilesize(char *dataline, FILE *target);
void InterpretChange(char *dataline, FILE *target, int restore);

int tfopen=0, CRC_present=0, files=1, zeile=0;
long int realfilesize=0;

void ProcessDatafile(FILE *datafile, int tfoverride, char *tfname, int restore)
{
/*
ProcessDatafile walks line by line through datafile, starting at the actual position.
If no patchfile-signature "*PATCH*" is given in the first line, it asks to continue.
It strips off leading and ending spaces and tabs and ending returns.
Then it calls the corresponding dispatcher for every line.
*/
unsigned char dataline[100]={0}, org_dataline[100]={0}, CRC_remember[100]={0};
/* dataline == read line, org_dataline == copy of it because of the strupr,
   CRC_remember == copy of it for checking the CRC after restoring */
FILE *target;
int l=0, c;
long int startpos;
unsigned char *p_dummy=0, *p_dummy2=0;
char patch_sig[9] = ")O@SBG)\n";    // real: *PATCH*\n

for (c=0; c<= 6; c++) patch_sig[c]++;  // decode patch_sig

startpos = ftell(datafile);  // remember start position in datafile

fgets(dataline, 99, datafile);     // get first line and check for signature
if (feof(datafile)) return;
zeile++;
if (!(!strcmp(dataline, patch_sig)))
  {
  fprintf(stderr, "Warning, no patchfile-signature found ! Perhaps not a patch-datafile.\n"
				  "  Continue anyway (y/N)? ");
  c = getche(); c = toupper((unsigned char)c);  fprintf(stderr, "\n");
  if (c != 'Y' && c != 'J') exit(255);
  fseek(datafile, startpos, SEEK_SET);  // go back to the read in line
  }


while (1)
 {
 fgets(dataline, 99, datafile);          // get line
 if (feof(datafile)) break;
 zeile++;

 strcpy(org_dataline, dataline);
 strupr(dataline); p_dummy = p_dummy2 = dataline;

 l = strlen(p_dummy); p_dummy += l-1;      // kill ending spaces+tabs+return
 while (*p_dummy == ' ' || *p_dummy == '\t' || *p_dummy == '\n'  && *p_dummy != NULL && l >= 0) p_dummy--;
 p_dummy++; *p_dummy = 0;

 while (*p_dummy2 == ' ' || *p_dummy2 == '\t' && *p_dummy2 != NULL) p_dummy2++;  // kill leading spaces+tabs
 strcpy(dataline, p_dummy2);


 if (dataline[0] == 0 || dataline[0] == '#' || dataline[0] == ';' || dataline[0] == '/')
   {           // blank line or comment (with # or ; or / as the first char)
   continue;   // ignore the line
   }
 else if (strstr(dataline, "ECHO") || strstr(dataline, "MESSAGE") || strstr(dataline, "PRINT"))
   {           // Message
   InterpretMessage(org_dataline);  // call dispatcher
   }
 else if (strstr(dataline, "NAME:") || strstr(dataline, "FILE:") || strstr(dataline, "FILENAME:"))
   {        // Filename
   if (tfopen)   // if a target is still open, close it. When restoring first check the CRC.
	 {
	 if (restore && CRC_present) InterpretChecksum(CRC_remember, target);
	 fclose(target);
	 tfopen=0; CRC_present = 0;
	 printf(" Closing targetfile.\n");
	 }
   target = InterpretFilename(dataline, tfoverride, tfname, files);
   tfopen = 1, files++;   // set flag, increase filecounter
   }
 else if (strstr(dataline, "EXECUTE:") || strstr(dataline, "EXEC:"))
   {        // Execute
   InterpretExecute(dataline);      // call dispatcher
   }
 else if (strstr(dataline, "CRC:") || strstr(dataline, "CRC16:") || strstr(dataline, "CHECKSUM:"))
   {        // CRC-checksum
CRCBegin:
   if (restore)      // when restoring remember CRC for checking AFTER restoring
	 {
	 strcpy(CRC_remember, dataline);
	 CRC_present = 1;
     }
    else
	 {
     if (tfopen)    // targetfile open ?
       {
       InterpretChecksum(dataline, target);  // call dispatcher
       }
      else
	   {
       if (tfoverride)
         {
         target = InterpretFilename(dataline, tfoverride, tfname, files);
         tfopen = 1; files++;
         goto CRCBegin;
         }
        else
         {
         fprintf(stderr, " No targetfile open, CRC check skipped !\n");
         }
       }
	 }
   }
 else if (strstr(dataline, "SIZE:") || strstr(dataline, "FILESIZE:") || strstr(dataline, "LENGTH:"))
   {        // Filesize
SizeBegin:
   if (tfopen)    // targetfile open ?
     {
     InterpretFilesize(dataline, target);  // call dispatcher
     }
    else
     {
     if (tfoverride)
       {
       target = InterpretFilename(dataline, tfoverride, tfname, files);
       tfopen = 1; files++;
       goto SizeBegin;
       }
	  else
       {
       fprintf(stderr, " No targetfile open, filesize check skipped !\n");
	   }
     }
   }
 else
   {        // Change-Position
ChangeBegin:
   if (tfopen)    // targetfile open ?
     {
	 InterpretChange(dataline, target, restore);  // call dispatcher
	 }
	else
	 {
	 if (tfoverride)
	   {
       target = InterpretFilename(dataline, tfoverride, tfname, files);
       tfopen = 1; files++;
       goto ChangeBegin;
       }
      else
       {
       fprintf(stderr, " No targetfile open, patch skipped !\n");
       }
     }
   }
 }

if (tfopen)   // if a target is still open, close it. When restoring, first check the CRC.
  {
  if (restore && CRC_present) InterpretChecksum(CRC_remember, target);
  fclose(target);
  tfopen=0; CRC_present = 0;
  printf(" Closing targetfile.\n");
  }
return;
}



void InterpretMessage(char *dataline)
{
char *begin_msg=0, *end_msg=0;
struct text_info ti;

if ((begin_msg = strchr(dataline, '"')) != NULL)  // get message body between
  {                                               // quotation marks
  begin_msg++;
  if ((end_msg = strchr(begin_msg, '"')) != NULL)
	{
	*end_msg = 0;
	gettextinfo(&ti);
	textcolor(WHITE);
	cprintf("%s\r\n", begin_msg);                 // print it out.
	textattr(ti.attribute);
	}
  }
return;
}

void InterpretExecute(char *dataline)
{
int c;
char *p_dummy=0;
char instruction[100]={0};

p_dummy = dataline;          // look for string after the :
while (*p_dummy != ':' && *p_dummy != NULL) p_dummy++; p_dummy++;
while (*p_dummy == ' ' || *p_dummy == '\t' && *p_dummy != NULL) p_dummy++;
strcpy(instruction, p_dummy);

fprintf(stderr, " Execute %s (Y/n/change) ? ", instruction); // ask for execute (Yes/no/change)
c = getche(); c = toupper((unsigned char)c); fprintf(stderr, "\n");
switch (c)
  {
  case 'C':   // ask for the changed intruction. When none is given, skip execute.
	fprintf(stderr, "  Enter instruction: "); gets(instruction);
	if (instruction[0] == NULL)
	  {
	  fprintf(stderr, "  Skipping.\n");
	  goto returnInterpretExecute;
	  }
	  goto ExecInstruction;
  case 'N':
  case 0x1B:
     break;
  default:
ExecInstruction:
	 printf("\n");
	 system(instruction);       // execute it
//	 printf("\nPress any key to continue ..."); getch(); printf("\n");
	 break;
  }

returnInterpretExecute:
return;
}



FILE *InterpretFilename(char *dataline, int tfoverride, char *tfname, int files)
{
unsigned char targetfilename[66]={0}, backupfilename[66]={0}, createbackup[66]={0};
FILE *target;
int c;
char *p_dummy=0;

patch(0,0,0,0,0,0,0,1);       // kill patchalways flags, this is a new file !

p_dummy = dataline;   // look for the string after the :
while (*p_dummy != ':' && *p_dummy != NULL) p_dummy++; p_dummy++;
while (*p_dummy == ' ' || *p_dummy == '\t' && *p_dummy != NULL) p_dummy++;

if (tfoverride)   // if a targetfile is given in the commandline
  {
  if (files > 1)  // the tf in the commandline is only valid for the first
    {             // file, ask for other names of the other files
	fprintf(stderr, " Open targetfile %s (Y/n) ? ", p_dummy);
    c = getche(); c = toupper((unsigned char)c); fprintf(stderr, "\n");
    switch (c)
      {
      case 'N':
      case 0x1B:
        fprintf(stderr, "  Enter targetfilename: "); gets(targetfilename);
        if (targetfilename[0] == NULL)
          {
          fprintf(stderr, "\nAborting.\n");
          exit(255);
          }
          break;
      default:
        strcpy(targetfilename, p_dummy);
        break;
      }
	}
   else  // first file, use the given name in the commandline
    {
    strcpy(targetfilename, tfname);
    }
  }
 else  // no tf is given in the commandline, use the name out of the file
  {
  strcpy(targetfilename, p_dummy);
  }

OpenTargetfile:
printf(" Opening targetfile %s ...", &targetfilename);
if ((target = fopen(targetfilename, "r+b")) == NULL)    // open target
  {
  printf(" Failed.\n");    // when failed, ask for filename. Exit if none is given.
  fprintf(stderr, "  Enter targetfilename: "); gets(targetfilename);
  if (targetfilename[0] == NULL)
    {
    fprintf(stderr, "\nAborting.\n");
    exit(255);
    }
   else
    {
    goto OpenTargetfile;
    }
  }
 else
  {
  printf(" Done.\n");
  fprintf(stderr, " Create backup-file (y/N) ? ");  // Ask for backup
   c = getche(); c = toupper((unsigned char)c); fprintf(stderr, "\n");
   if (c == 'Y' || c == 'J')
     {
	 strcpy(backupfilename, targetfilename);  // construct backupfilename
	 p_dummy = strchr(backupfilename, '.');
	 if (p_dummy)
	   { strcpy(p_dummy, ".BAK"); }
	  else
	   { strcat(backupfilename, ".BAK"); }
	 fprintf(stderr, "  Change suggested backupname %s (y/N) ? ", backupfilename);
	 c = getche(); c = toupper((unsigned char)c); fprintf(stderr, "\n");
	 if (c == 'Y' || c == 'J')
	   {
	   fprintf(stderr, "  Enter backupfilename: "); gets(backupfilename);
	   if (backupfilename[0] == NULL)
		 {
         fprintf(stderr, "  Skipping.\n");
         goto returnInterpretFilename;
         }
       }
     printf("  Creating backupfile %s ...\n", backupfilename);
	 sprintf(createbackup, "copy %s %s", targetfilename, backupfilename);
	 system(createbackup); // creat it
	 }
  }

returnInterpretFilename:
return target;
}

void InterpretChecksum(char *dataline, FILE *target)
{
unsigned int checksum=0, realchecksum=0;
int c;
char *p_dummy=0;

p_dummy = dataline;   // look for the string after the :
while (*p_dummy != ':' && *p_dummy != NULL) p_dummy++; p_dummy++;
while (*p_dummy == ' ' || *p_dummy == '\t' && *p_dummy != NULL) p_dummy++;
checksum = (unsigned int) LHex2Dez(p_dummy);  // get the checksum

printf(" Please wait, calculating CRC16 ...");
realchecksum = GetCRC(target); // calculate the real CRC of the file
printf(" Done.\n");
if (realchecksum != checksum)  // if they are not identical ask for continue
  {
  fprintf(stderr, "Warning, wrong checksum ! Most probably the wrong file or an other version.\n"
                  "  Expected: 0x%04X   Found: 0x%04X\n"
                  "  Continue anyway (y/N)? ", checksum, realchecksum);
  c = getche(); c = toupper((unsigned char)c);  fprintf(stderr, "\n");
  if (c != 'Y' && c != 'J') exit(255);
  }
 else
  {
  printf("  CRC check: OK     (Expected: 0x%04X   Found: 0x%04X)\n", checksum, realchecksum);
  }
return;
}

void InterpretFilesize(char *dataline, FILE *target)
{
long int filesize=0;
int c;
char *p_dummy=0;

p_dummy = dataline;   // look for the string after the :
while (*p_dummy != ':' && *p_dummy != NULL) p_dummy++; p_dummy++;
while (*p_dummy == ' ' || *p_dummy == '\t' && *p_dummy != NULL) p_dummy++;
filesize = atol(p_dummy);   // get filesize
realfilesize = GetFilesize(target);  // get real filesize
if (realfilesize != filesize)  // if they are not identical ask for continue
  {
  fprintf(stderr, "Warning, wrong filesize ! Most probably the wrong file or an other version.\n"
                  "  Expected: %li   Found: %li\n"
                  "  Continue anyway (y/N)? ", filesize, realfilesize);
  c = getche(); c = toupper((unsigned char)c);  fprintf(stderr, "\n");
  if (c != 'Y' && c != 'J') exit(255);
  }
 else
  {
  printf(" Size check: OK     (Expected: %li   Found: %li)\n", filesize, realfilesize);
  }
return;
}


void InterpretChange(char *dataline, FILE *target, int restore)
{
unsigned long int address=0;
char dummy[100]={0};
unsigned char origbyte=0, patchbyte=0;
int l=0, no_orig;
char *p_dummy=0, *p_dummy2=0;

p_dummy = dataline;   // look for the string after the :
while (*p_dummy != ':' && *p_dummy != NULL) p_dummy++; p_dummy++;
l = (p_dummy-dataline);
strncpy(dummy, dataline, l); dummy[l] = 0;  // look for the address
if (strspn(dummy, "0123456789ABCDEF:") != strlen(dummy))   // strcspn is unable ...
  { // check if it is a Hex-address
  fprintf(stderr, " Invalid data/address found at line %i, ignoring line.\n", zeile);
  return;
  }

address = LHex2Dez(dummy);  // get the address
if (address > realfilesize && realfilesize != 0) // if there is a size entry ...
  {
  fprintf(stderr, " Address beyond real filesize found at line %i, ignoring line.\n", zeile);
  return;
  }

while (*p_dummy == ' ' || *p_dummy == '\t' && *p_dummy != NULL) p_dummy++;

p_dummy2 = p_dummy;
while (*p_dummy2 != ' ' && *p_dummy2 != '\t' && *p_dummy2 != NULL) p_dummy2++;
l = (p_dummy2-p_dummy);
if (l == 0)                    // there is no patch-data, only a address
  {
  fprintf(stderr, " No data found at line %i, ignoring line.\n", zeile);
  return;
  }
strncpy(dummy, p_dummy, l); dummy[l] = 0;
origbyte = LHex2Dez(dummy);   // get origbyte

while (*p_dummy2 == ' ' || *p_dummy2 == '\t' && *p_dummy2 != NULL) p_dummy2++;
if (*p_dummy2 != NULL)  // is there something else in the line ?
  {
  p_dummy = p_dummy2;
  while (*p_dummy2 != ' ' && *p_dummy2 != '\t' && *p_dummy2 != NULL) p_dummy2++;
  l = (p_dummy2-p_dummy);
  strncpy(dummy, p_dummy, l); dummy[l] = 0;
  patchbyte = LHex2Dez(dummy);  // get the patchbyte
  no_orig = 0;                  // clear flag
  }
 else
  {
  patchbyte = origbyte;         // because of the structure of patch ...
  no_orig = 1;                  // set flag
  }

// call the patcher
patch(address, origbyte, patchbyte, target, no_orig, restore, zeile, 0);

return;
}
