{

                                                      ͻ
                                                        PGUI Graphic    
                                                        Window Include  
                                                          Rev.  1.00    
                                                      ͼ

}

Procedure GraphicWindow.SaveBackground;
Begin
  Mouse.Hide;
  Size:=ImageSize(X1,Y1,X2,Y2);
  If Size>MaxAvail Then Error(1);
  GetMem(Save,Size);
  GetImage(X1,Y1,X2,Y2,Save^);
  Mouse.Show;
End;

Procedure GraphicWindow.DrawWindow;

Var
  X  :Byte;
  Old:Record
        Color:Word;
        Style:FillSettingsType;
      End;

Begin
  Mouse.Hide;
  Old.Color:=GetColor;
  GetFillSettings(Old.Style);

  SetColor       (BoxBck);
  Line(X1+1,Y1,X2-1,Y1);            {-----}
  Line(X1,Y1+1,X1,Y2-1);            {|<  |}
  Line(X2,Y1+1,X2,Y2-1);            {|  >|}
  Line(X1+1,Y2,X2-1,Y2);            {-----}

  SetColor       (BoxFrg);
  SetFillStyle   (Pattern,FillColor);
  For X:=1 to Thickness do
    Rectangle(X1+X,Y1+X,X2-X,Y2-X);
  Inc(X);
  Bar(X1+X,Y1+X,X2-X,Y2-X);

  PutPixel(X1+1,Y1+1,BoxBck);
  PutPixel(X2-1,Y2-1,BoxBck);
  PutPixel(X2-1,Y1+1,BoxBck);
  PutPixel(X1+1,Y2-1,BoxBck);

  PutPixel(X1+X,Y1+X,BoxFrg);
  PutPixel(X2-X,Y2-X,BoxFrg);
  PutPixel(X2-X,Y1+X,BoxFrg);
  PutPixel(X1+X,Y2-X,BoxFrg);

  SetColor(Old.Color);
  SetFillStyle(Old.Style.Pattern,Old.Style.Color);
  Mouse.Show;
End;

Procedure GraphicWindow.Open(NX1,NY1,NX2,NY2,Forg,Back,
                             Thick,Patrn,PatClr:Word;KeepBackground:Boolean);
Begin
  Buttons.Init;
  HdrButtonNum        :=0;
  VSlideButtonNum     :=0;
  VSlideBarButtonNum  :=0;
  VSlideButtonUpNum   :=0;
  VSlideButtonDownNum :=0;
  VSlideBarMaxPos     :=0;
  VSlideBarCurPos     :=0;
  HSlideButtonNum     :=0;
  HSlideBarButtonNum  :=0;
  HSlideButtonLeftNum :=0;
  HSlideButtonRightNum:=0;
  HSlideBarMaxPos     :=0;
  HSlideBarCurPos     :=0;
  VSlideBarPat        :=0;
  VSlideBarClr        :=0;
  HSlideBarPat        :=0;
  HSlideBarClr        :=0;
  CloseButtonNum      :=0;
  KeepBack            :=KeepBackground;
  Status              :=Visible;
  Header              :='';
  BoxFrg              :=Forg;
  BoxBck              :=Back;
  Thickness           :=Thick;
  Pattern             :=Patrn;
  FillColor           :=PatClr;
  X1                  :=NX1;
  Y1                  :=NY1;
  X2                  :=NX2;
  Y2                  :=NY2;

  If KeepBack Then
    SaveBackground
  Else
  Begin
    Size:=0;
    Save:=NIL;
  End;
  DrawWindow;
End;

Procedure GraphicWindow.DisplayHeading;

Var
  XPos:Word;
  Old :Record
         Color:Word;
         Style:FillSettingsType;
       End;

Begin
  Mouse.Hide;
  GetFillSettings(Old.Style);
  If Header<>'' Then
  Begin
    Old.Color:=GetColor;
    SetColor       (HdrFrg);
    SetFillStyle   (HdrPattern,HdrFillColor);
    Bar(X1+Thickness+2,Y1+Thickness+2,X2-Thickness-2,Y1+Thickness+12);
    Case HdrFmt Of
      LeftText  :XPos:=X1+4;
      CentreText:XPos:=X1+((X2-X1) Div 2)-(Length(Header)*4);
      RightText :XPos:=X2-2*Thickness-(Length(Header)*8)-2;
    End;
    OutTextXY(XPos+Thickness,Y1+4+Thickness,Header);
    SetColor(Old.Color);
  End
  Else
  Begin
    SetFillStyle   (Pattern,FillColor);
    Bar(X1+Thickness+2,Y1+Thickness+2,X2-Thickness-2,Y1+Thickness+12);
  End;
  SetFillStyle(Old.Style.Pattern,Old.Style.Color);
  Mouse.Show;
End;

Procedure GraphicWindow.NewHeading(NewHead:String;NewMode:TextFormats;
                                   Forg,Patrn,PatClr:Word);
Begin
  HdrFrg:=Forg;
  HdrPattern:=Patrn;
  HdrFillColor:=PatClr;
  HdrFmt:=NewMode;
  If NewHead='' Then
    Header:=''
  Else
    Header:=NewHead;
  DisplayHeading;
End;

Procedure GraphicWindow.Hide;

Var
  NewSave :Pointer;

Begin
  Status:=Hidden;
  If KeepBack Then
  Begin
    If Size>MaxAvail Then Error(1);
    GetMem(NewSave,Size);
    Mouse.Hide;
    GetImage(X1,Y1,X2,Y2,NewSave^);
    PutImage(X1,Y1,Save^,NormalPut);
    Mouse.Show;
    FreeMem(Save,Size);
    Save:=NewSave;
  End
  Else
  Begin
    Mouse.Hide;
    SetFillStyle(SolidFill,BoxBck);
    Bar(X1,Y1,X2,Y2);
    Mouse.Show;
  End;
End;

Procedure GraphicWindow.Show;

Var
  NewSave :Pointer;

Begin
  Status:=Visible;
  If KeepBack Then
  Begin
    If Size>MaxAvail Then Error(1);
    GetMem(NewSave,Size);
    Mouse.Hide;
    GetImage(X1,Y1,X2,Y2,NewSave^);
    PutImage(X1,Y1,Save^,NormalPut);
    Mouse.Show;
    FreeMem(Save,Size);
    Save:=NewSave;
  End
  Else
  Begin
    DrawWindow;
    DisplayHeading;
    If CloseButtonNum<>0 Then
      PutImage(X1+Thickness+2,Y1+Thickness+2,IconCloseButton^,CopyPut);
    If VSlideButtonNum<>0 Then DrawVertSlideBar;
    If HSlideButtonNum<>0 Then DrawHorzSlideBar;
  End;
End;

Procedure GraphicWindow.NewPosition(NewX,NewY:Word);
Begin
  Hide;
  Buttons.MoveAll(Integer(NewX)-X1,Integer(NewY)-Y1);
  X2:=NewX+(X2-X1);
  Y2:=NewY+(Y2-Y1);
  X1:=NewX;
  Y1:=NewY;
  Show;
End;

Procedure GraphicWindow.DrawOutLine(NewX,NewY:Word;Var OutLine:OutLineSave);

Var
  OldClr:Word;

Begin
  X2:=NewX+(X2-X1);          {Saves the outline screen area of a box}
  Y2:=NewY+(Y2-Y1);          {and then draws the outline of the box.}
  X1:=NewX;                  {Saves the old screen area into OutLine.}
  Y1:=NewY;
  With OutLine do
  Begin
    Size1:=ImageSize(X1,Y1,X2,Y1);   {Horizontal}
    Size2:=ImageSize(X1,Y1,X1,Y2);   {Vertical}
    If 2*Size1+2*Size2>MaxAvail Then Error(1);
    GetMem(Data[1],Size1);
    GetMem(Data[2],Size1);
    GetMem(Data[3],Size2);
    GetMem(Data[4],Size2);
    Mouse.Hide;
    GetImage(X1,Y1,X2,Y1,Data[1]^);
    GetImage(X1,Y2,X2,Y2,Data[2]^);
    GetImage(X1,Y1,X1,Y2,Data[3]^);
    GetImage(X2,Y1,X2,Y2,Data[4]^);
    Mouse.Show;
  End;
  OldClr:=GetColor;
  SetColor(BoxFrg);
  Mouse.Hide;
  Rectangle(X1,Y1,X2,Y2);
  Mouse.Show;
  SetColor(OldClr);
End;

Procedure GraphicWindow.NoOutLine(Var OutLine:OutLineSave);
Begin
  With OutLine do
  Begin
    Mouse.Hide;
    PutImage(X1,Y1,Data[1]^,NormalPut);  {Restores the screen to as it}
    PutImage(X1,Y2,Data[2]^,NormalPut);  {was before DrawOutLine was called.}
    PutImage(X1,Y1,Data[3]^,NormalPut);
    PutImage(X2,Y1,Data[4]^,NormalPut);
    Mouse.Show;
    FreeMem(Data[1],Size1);
    FreeMem(Data[2],Size1);
    FreeMem(Data[3],Size2);
    FreeMem(Data[4],Size2);
    Size1:=0;
  End;
End;

Procedure GraphicWindow.Drag;

Var
  MouseL,
  MouseR,
  MouseM,
  MouseMoved,
  MouseRelease :Boolean;
  OldMouseX,
  OldMouseY,
  MouseX,
  MouseY,
  MouseStartX,
  MouseStartY,
  MouseDistX,
  MouseDistY,
  NewX,
  NewY,
  OldX,
  OldY         :Word;
  C            :Char;
  OldBut       :Pointer;
  OldData      :OutLineSave;

Begin
  OldBut:=Buttons.Buttons;
  If Mouse.Active Then
  Begin
    C:=#1;
    OldMouseX:=65535;
    OldMouseY:=65535;
    MouseStartX:=((X2-X1) Div 2) + X1;
    MouseStartY:=(Y1+Thickness+4);
    MouseDistX:=MouseStartX-X1;
    MouseDistY:=MouseStartY-Y1;
    Mouse.SetXY(MouseStartX,MouseStartY);
  End;
  MouseRelease:=False;
  OldX:=X1;
  OldY:=Y1;
  Repeat
    Repeat
      MouseMoved:=False;
      KeyBuffer(Clear);
      DrawOutLine(X1,Y1,OldData);      {Flashing Outline of a Box}
      NoOutLine(OldData);
      If Mouse.Active Then
      Begin
        Mouse.GetStatus(MouseX,MouseY,MouseL,MouseR,MouseM);
        If (MouseX<>OldMouseX) Or (MouseY<>OldMouseY) Then MouseMoved:=True;
        If (Not MouseL) And (Not MouseR) Then MouseRelease:=True;
      End;
    Until KeyPressed Or MouseMoved Or MouseRelease;
    If MouseMoved Then
    Begin
      If LongInt(MouseX)-LongInt(MouseDistX)<0 Then
        OldMouseX:=0
      Else
        OldMouseX:=MouseX-MouseDistX;
      If LongInt(MouseY)-LongInt(MouseDistY)<0 Then
        OldMouseY:=0
      Else
        OldMouseY:=MouseY-MouseDistY;
      If (OldMouseX+(X2-X1)+2*Thickness>GetMaxX) Then
         OldMouseX:=GetMaxX-(X2-X1)-2*Thickness;
      If (OldMouseY+(Y2-Y1)+2*Thickness>GetMaxY) Then
         OldMouseY:=GetMaxY-(Y2-Y1)-2*Thickness;
      DrawOutLine(OldMouseX,OldMouseY,OldData);
      OldMouseX:=MouseX;
      OldMouseY:=MouseY;
      If OldData.Size1>0 Then NoOutLine(OldData);
    End
    Else
    Begin
      If KeyPressed Then C:=ReadKey;
      If C=#0 Then
      Begin
        C:=ReadKey;
        Case C Of
          'K':If X1>10         Then DrawOutLine(X1-10,Y1,OldData);
          'M':If X2<GetMaxX-9  Then DrawOutLine(X1+10,Y1,OldData);
          'H':If Y1>10         Then DrawOutLine(X1,Y1-10,OldData);
          'P':If Y2<GetMaxY-9  Then DrawOutLine(X1,Y1+10,OldData);
        End;
      End
      Else
        Case C Of
          '4':If X1>0       Then DrawOutLine(X1-1,Y1,OldData);
          '6':If X2<GetMaxX Then DrawOutLine(X1+1,Y1,OldData);
          '8':If Y1>0       Then DrawOutLine(X1,Y1-1,OldData);
          '2':If Y2<GetMaxY Then DrawOutLine(X1,Y1+1,OldData);
        End;
      If OldData.Size1>0 Then NoOutLine(OldData);
    End;
  Until (C in [#27,#13]) Or MouseRelease;
  NewX:=X1;
  NewY:=Y1;

  X2:=OldX+(X2-X1);
  Y2:=OldY+(Y2-Y1);
  X1:=OldX;
  Y1:=OldY;
  If (C=#13) Or MouseRelease Then
    NewPosition(NewX,NewY);
  Buttons.Buttons:=OldBut;
End;

Procedure GraphicWindow.DragVertSlideButton;

Var
  Dummy,
  SlideBarX1,
  SlideBarY1,
  SlideBarX2,
  SlideBarY2,
  OldMouseY,
  MouseX,
  MouseY       :Word;
  MouseL,
  MouseR,
  MouseM,
  MouseMoved,
  MouseRelease :Boolean;
  OldSlideBarMx:LongInt;
  C            :Char;

Begin
  OldSlideBarMx:=VSlideBarMaxPos;
  C:=#1;
  MouseRelease:=False;
  VertSlideButtonPos(MouseX,MouseY,Dummy,Dummy);
  MouseY:=65535;
  Repeat
    MouseMoved:=False;
    OldMouseY:=MouseY;
    KeyBuffer(Clear);
    Repeat
      If Mouse.Active Then
      Begin
        Mouse.GetStatus(MouseX,MouseY,MouseL,MouseR,MouseM);
        If (MouseY<>OldMouseY) Then MouseMoved:=True;
        If (Not MouseL) And (Not MouseR) Then MouseRelease:=True;
      End;
    Until KeyPressed Or MouseMoved Or MouseRelease;

    VertSlideBarPos(SlideBarX1,SlideBarY1,SlideBarX2,SlideBarY2);
    If KeyPressed Then
    Begin
      C:=ReadKey;
      If C=#0 Then
      Begin
        C:=ReadKey;
        Case C Of
          'H':If MouseY>SlideBarY1   Then Dec(MouseY,1);
          'I':If MouseY>SlideBarY1+9 Then Dec(MouseY,10);
          'P':If MouseY<SlideBarY2   Then Inc(MouseY,1);
          'Q':If MouseY<SlideBarY2-9 Then Inc(MouseY,10);
        End;
      End;
    End
    Else
    Begin
      If (MouseY>SlideBarY2) Then MouseY:=SlideBarY2;
      If (MouseY<SlideBarY1) Then MouseY:=SlideBarY1;
    End;
    VertSlideBar(MouseY-SlideBarY1,SlideBarY2-SlideBarY1,VSlideBarPat,VSlideBarClr);
  Until (C in [#13,#27]) Or MouseRelease;
  VSlideBarMaxPos:=OldSlideBarMx;
  VSlideBarCurPos:=AdjustMeter(0,SlideBarY2-SlideBarY1,MouseY-SlideBarY1,
                               0,VSlideBarMaxPos);
End;

Procedure GraphicWindow.DragHorzSlideButton;

Var
  Dummy,
  SlideBarX1,
  SlideBarY1,
  SlideBarX2,
  SlideBarY2,
  OldMouseX,
  MouseX,
  MouseY       :Word;
  MouseL,
  MouseR,
  MouseM,
  MouseMoved,
  MouseRelease :Boolean;
  OldSlideBarMx:LongInt;
  C            :Char;

Begin
  OldSlideBarMx:=HSlideBarMaxPos;
  C:=#1;
  MouseRelease:=False;
  HorzSlideButtonPos(MouseX,MouseY,Dummy,Dummy);
  MouseX:=65535;
  Repeat
    MouseMoved:=False;
    OldMouseX:=MouseX;
    KeyBuffer(Clear);
    Repeat
      If Mouse.Active Then
      Begin
        Mouse.GetStatus(MouseX,MouseY,MouseL,MouseR,MouseM);
        If (MouseX<>OldMouseX) Then MouseMoved:=True;
        If (Not MouseL) And (Not MouseR) Then MouseRelease:=True;
      End;
    Until KeyPressed Or MouseMoved Or MouseRelease;

    HorzSlideBarPos(SlideBarX1,SlideBarY1,SlideBarX2,SlideBarY2);
    If KeyPressed Then
    Begin
      C:=ReadKey;
      If C=#0 Then
      Begin
        C:=ReadKey;
        Case C Of
          'K':If MouseX>SlideBarX1   Then Dec(MouseX,1);
          'I':If MouseX>SlideBarX1+9 Then Dec(MouseX,10);
          'M':If MouseX<SlideBarX2   Then Inc(MouseX,1);
          'Q':If MouseX<SlideBarX2-9 Then Inc(MouseX,10);
        End;
      End;
    End
    Else
    Begin
      If (MouseX>SlideBarX2) Then MouseX:=SlideBarX2;
      If (MouseX<SlideBarX1) Then MouseX:=SlideBarX1;
    End;
    HorzSlideBar(MouseX-SlideBarX1,SlideBarX2-SlideBarX1,HSlideBarPat,HSlideBarClr);
  Until (C in [#13,#27]) Or MouseRelease;
  HSlideBarMaxPos:=OldSlideBarMx;
  HSlideBarCurPos:=AdjustMeter(0,SlideBarX2-SlideBarX1,MouseX-SlideBarX1,
                               0,HSlideBarMaxPos);
End;

Procedure GraphicWindow.NewSize(NX1,NY1,NX2,NY2:Word);

Var
  NewHead:String;

Begin
  NewHead:=Header;
  Close;
  Open(NX1,NY1,NX2,NY2,BoxFrg,BoxBck,Thickness,Pattern,FillColor,KeepBack);
  Header:=NewHead;
  DisplayHeading;
  If HdrButtonNum>0 Then
  Begin
    HeadingIcon(False);
    HeadingIcon(True);
  End;
End;

Procedure GraphicWindow.CloseIcon(Active:Boolean);

Var
  CloseButtonX1,
  CloseButtonY1,
  CloseButtonX2,
  CloseButtonY2  :Word;

Begin
  CloseButtonPos(CloseButtonX1,CloseButtonY1,CloseButtonX2,CloseButtonY2);
  Mouse.Hide;
  If Active Then
  Begin
    PutImage(X1+Thickness+2,Y1+Thickness+2,IconCloseButton^,CopyPut);
    If CloseButtonNum=0 Then
    Begin
      Buttons.Add(CloseButtonX1, CloseButtonY1, CloseButtonX2,
                  CloseButtonY2, 0, 0, NIL, '',
                  SpecialCode(Key_Alt, Key_F3), KeyCode(Key_Alt, Key_F3));
      CloseButtonNum:=Buttons.Number;
    End;
  End
  Else
  Begin
    DisplayHeading;
    Buttons.GotoNumber(CloseButtonNum);
    Buttons.KillOne;
    CloseButtonNum:=0;
  End;
  Mouse.Show;
End;

Procedure GraphicWindow.HeadingIcon(Active:Boolean);

Var
  HeadingX1,
  HeadingY1,
  HeadingX2,
  HeadingY2:Word;

Begin
  HeadingPos(HeadingX1,HeadingY1,HeadingX2,HeadingY2);
  Mouse.Hide;
  If Active Then
  Begin
    If HdrButtonNum=0 Then
    Begin
      Buttons.Add(HeadingX1, HeadingY1, HeadingX2, HeadingY2,
                  0, 0, NIL, '',
                  SpecialCode(Key_Ctrl, Key_F5), KeyCode(Key_Ctrl, Key_F5));
      HdrButtonNum:=Buttons.Number;
    End;
  End
  Else
  Begin
    Buttons.GotoNumber(HdrButtonNum);
    Buttons.KillOne;
    HdrButtonNum:=0;
  End;
  Mouse.Show;
End;

Procedure GraphicWindow.VertSlideIcon(Active:Boolean);

Var
  SlideButtonX1,
  SlideButtonY1,
  SlideButtonX2,
  SlideButtonY2,

  SlideButtonUpX1,
  SlideButtonUpY1,
  SlideButtonUpX2,
  SlideButtonUpY2,

  SlideButtonDownX1,
  SlideButtonDownY1,
  SlideButtonDownX2,
  SlideButtonDownY2,

  SlideBarX1,
  SlideBarY1,
  SlideBarX2,
  SlideBarY2    :Word;

Begin
  VertSlideBarPos(SlideBarX1,SlideBarY1,SlideBarX2,SlideBarY2);
  VertSlideButtonPos(SlideButtonX1,SlideButtonY1,SlideButtonX2,SlideButtonY2);
  VertSlideButtonUpPos(SlideButtonUpX1,SlideButtonUpY1,SlideButtonUpX2,SlideButtonUpY2);
  VertSlideButtonDownPos(SlideButtonDownX1,SlideButtonDownY1,SlideButtonDownX2,SlideButtonDownY2);

  If Active And (VSlideBarMaxPos>0) Then
  Begin
    If VSlideButtonNum=0 Then
    Begin
      Buttons.Add(SlideButtonX1, SlideButtonY1, SlideButtonX2,
                  SlideButtonY2, 0, 0, NIL, '',
                  SpecialCode(Mouse_Only, Mouse_SlideButtonVert), KeyCode(Mouse_Only, Mouse_SlideButtonVert));
      VSlideButtonNum:=Buttons.Number;
    End;
    If VSlideBarButtonNum=0 Then
    Begin
      Buttons.Add(SlideBarX1, SlideBarY1, SlideBarX2,
                  SlideBarY2, 0, 0, NIL, '',
                  SpecialCode(Mouse_Only, Mouse_SlideBarVert), KeyCode(Mouse_Only, Mouse_SlideBarVert));
      VSlideBarButtonNum:=Buttons.Number;
    End;
    If VSlideButtonUpNum=0 Then
    Begin
      Buttons.Add(SlideButtonUpX1, SlideButtonUpY1, SlideButtonUpX2,
                  SlideButtonUpY2, 0, 0, NIL, '',
                  SpecialCode(Key_None, Key_Up), KeyCode(Key_None, Key_Up));
      VSlideButtonUpNum:=Buttons.Number;
    End;
    If VSlideButtonDownNum=0 Then
    Begin
      Buttons.Add(SlideButtonDownX1, SlideButtonDownY1, SlideButtonDownX2,
                  SlideButtonDownY2, 0, 0, NIL, '',
                  SpecialCode(Key_None, Key_Down), KeyCode(Key_None, Key_Down));
      VSlideButtonDownNum:=Buttons.Number;
    End;
  End
  Else
  Begin
    Buttons.GotoNumber(VSlideBarButtonNum);
    Buttons.KillOne;
    VSlideBarButtonNum:=0;
    Buttons.GotoNumber(VSlideButtonNum);
    Buttons.KillOne;
    VSlideButtonNum:=0;
    Buttons.GotoNumber(VSlideButtonDownNum);
    Buttons.KillOne;
    VSlideButtonDownNum:=0;
    Buttons.GotoNumber(VSlideButtonUpNum);
    Buttons.KillOne;
    VSlideButtonUpNum:=0;
  End;
End;

Procedure GraphicWindow.HorzSlideIcon(Active:Boolean);

Var
  SlideButtonX1,
  SlideButtonY1,
  SlideButtonX2,
  SlideButtonY2,

  SlideButtonUpX1,
  SlideButtonUpY1,
  SlideButtonUpX2,
  SlideButtonUpY2,

  SlideButtonDownX1,
  SlideButtonDownY1,
  SlideButtonDownX2,
  SlideButtonDownY2,

  SlideBarX1,
  SlideBarY1,
  SlideBarX2,
  SlideBarY2    :Word;

Begin
  HorzSlideBarPos(SlideBarX1,SlideBarY1,SlideBarX2,SlideBarY2);
  HorzSlideButtonPos(SlideButtonX1,SlideButtonY1,SlideButtonX2,SlideButtonY2);
  HorzSlideButtonLeftPos(SlideButtonUpX1,SlideButtonUpY1,SlideButtonUpX2,SlideButtonUpY2);
  HorzSlideButtonRightPos(SlideButtonDownX1,SlideButtonDownY1,SlideButtonDownX2,SlideButtonDownY2);

  If Active And (HSlideBarMaxPos>0) Then
  Begin
    If HSlideButtonNum=0 Then
    Begin
      Buttons.Add(SlideButtonX1, SlideButtonY1, SlideButtonX2,
                  SlideButtonY2, 0, 0, NIL, '',
                  SpecialCode(Mouse_Only, Mouse_SlideButtonHorz), KeyCode(Mouse_Only, Mouse_SlideButtonHorz));
      HSlideButtonNum:=Buttons.Number;
    End;
    If HSlideBarButtonNum=0 Then
    Begin
      Buttons.Add(SlideBarX1, SlideBarY1, SlideBarX2,
                  SlideBarY2, 0, 0, NIL, '',
                  SpecialCode(Mouse_Only, Mouse_SlideBarHorz), KeyCode(Mouse_Only, Mouse_SlideBarHorz));
      HSlideBarButtonNum:=Buttons.Number;
    End;
    If HSlideButtonLeftNum=0 Then
    Begin
      Buttons.Add(SlideButtonUpX1, SlideButtonUpY1, SlideButtonUpX2,
                  SlideButtonUpY2, 0, 0, NIL, '',
                  SpecialCode(Key_None, Key_Left), KeyCode(Key_None, Key_Left));
      HSlideButtonLeftNum:=Buttons.Number;
    End;
    If HSlideButtonRightNum=0 Then
    Begin
      Buttons.Add(SlideButtonDownX1, SlideButtonDownY1, SlideButtonDownX2,
                  SlideButtonDownY2, 0, 0, NIL, '',
                  SpecialCode(Key_None, Key_Right), KeyCode(Key_None, Key_Right));
      HSlideButtonRightNum:=Buttons.Number;
    End;
  End
  Else
  Begin
    Buttons.GotoNumber(HSlideBarButtonNum);
    Buttons.KillOne;
    HSlideBarButtonNum:=0;
    Buttons.GotoNumber(HSlideButtonNum);
    Buttons.KillOne;
    HSlideButtonNum:=0;
    Buttons.GotoNumber(HSlideButtonRightNum);
    Buttons.KillOne;
    HSlideButtonRightNum:=0;
    Buttons.GotoNumber(HSlideButtonLeftNum);
    Buttons.KillOne;
    HSlideButtonLeftNum:=0;
  End;
End;

Procedure GraphicWindow.DrawVertSlideBar;
Begin
  If VSlideBarMaxPos=0 Then Exit;
  VSlideButtonPos:=Y1+Thickness+23+((VSlideBarCurPos*(Y2-Y1-10*Thickness-28)) Div VSlideBarMaxPos);
  Mouse.Hide;
  SetFillStyle(VSlideBarPat,VSlideBarClr);
  Bar(X2-Thickness-10,Y1+Thickness+23,X2-Thickness-2,Y2-Thickness-10);
  PutImage(X2-Thickness-10,VSlideButtonPos,IconSlideButtonVert^,CopyPut);
  PutImage(X2-Thickness-10,Y1+Thickness+14,IconSlideButtonUp^,CopyPut);
  PutImage(X2-Thickness-10,Y2-Thickness-10,IconSlideButtonDown^,CopyPut);
  Mouse.Show;
End;

Procedure GraphicWindow.VertSlideBar(CurPos,MaxPos:LongInt;Patrn,PatClr:Word);

Var
  Dummy,
  NewX,
  NewY,
  OldX,
  OldY    :Word;

Begin
  VertSlideButtonPos(OldX,OldY,Dummy,Dummy);
  VSlideBarPat   :=Patrn;
  VSlideBarClr   :=PatClr;
  VSlideBarMaxPos:=MaxPos;
  VSlideBarCurPos:=CurPos;
  DrawVertSlideBar;
  If VSlideButtonNum>0 Then
  Begin
    VertSlideButtonPos(NewX,NewY,Dummy,Dummy);
    Buttons.Move(Integer(NewX)-OldX,Integer(NewY)-OldY,VSlideButtonNum);
  End;
End;

Procedure GraphicWindow.UpdateVertSlideBar(CurPos:LongInt);

Var
  Dummy,
  NewX,
  NewY,
  OldX,
  OldY    :Word;

Begin
  VertSlideButtonPos(OldX,OldY,Dummy,Dummy);
  VSlideBarCurPos:=CurPos;
  DrawVertSlideBar;
  If VSlideButtonNum>0 Then
  Begin
    VertSlideButtonPos(NewX,NewY,Dummy,Dummy);
    Buttons.Move(Integer(NewX)-OldX,Integer(NewY)-OldY,VSlideButtonNum);
  End;
End;

Procedure GraphicWindow.DrawHorzSlideBar;
Begin
  If HSlideBarMaxPos=0 Then Exit;
  HSlideButtonPos:=X1+Thickness+12+((HSlideBarCurPos*(X2-X1-10*Thickness-28)) Div HSlideBarMaxPos);
  Mouse.Hide;
  SetFillStyle(HSlideBarPat,HSlideBarClr);
  Bar(X1+Thickness+11,Y2-Thickness-10,X2-Thickness-21,Y2-Thickness-2);
  PutImage(HSlideButtonPos,Y2-Thickness-10,IconSlideButtonHorz^,CopyPut);
  PutImage(X1+Thickness+2,Y2-Thickness-10,IconSlideButtonLeft^,CopyPut);
  PutImage(X2-Thickness-20,Y2-Thickness-10,IconSlideButtonRight^,CopyPut);
  Mouse.Show;
End;

Procedure GraphicWindow.HorzSlideBar(CurPos,MaxPos:LongInt;Patrn,PatClr:Word);

Var
  Dummy,
  NewX,
  NewY,
  OldX,
  OldY    :Word;

Begin
  HorzSlideButtonPos(OldX,OldY,Dummy,Dummy);
  HSlideBarPat   :=Patrn;
  HSlideBarClr   :=PatClr;
  HSlideBarMaxPos:=MaxPos;
  HSlideBarCurPos:=CurPos;
  DrawHorzSlideBar;
  If HSlideButtonNum>0 Then
  Begin
    HorzSlideButtonPos(NewX,NewY,Dummy,Dummy);
    Buttons.Move(Integer(NewX)-OldX,Integer(NewY)-OldY,HSlideButtonNum);
  End;
End;

Procedure GraphicWindow.UpdateHorzSlideBar(CurPos:LongInt);

Var
  Dummy,
  NewX,
  NewY,
  OldX,
  OldY    :Word;

Begin
  HorzSlideButtonPos(OldX,OldY,Dummy,Dummy);
  HSlideBarCurPos:=CurPos;
  DrawHorzSlideBar;
  If HSlideButtonNum>0 Then
  Begin
    HorzSlideButtonPos(NewX,NewY,Dummy,Dummy);
    Buttons.Move(Integer(NewX)-OldX,Integer(NewY)-OldY,HSlideButtonNum);
  End;
End;

Procedure GraphicWindow.CloseButtonPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=X1+Thickness+2;
  BY1:=Y1+Thickness+2;
  BX2:=X1+Thickness+10;
  BY2:=Y1+Thickness+10;
End;

Procedure GraphicWindow.HeadingPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=X1+Thickness+10;
  BY1:=Y1+Thickness+1;
  BX2:=X2-Thickness-1;
  BY2:=Y1+Thickness+10;
End;

Procedure GraphicWindow.VertSlideBarPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=X2-Thickness-10;
  BY1:=Y1+Thickness+23;
  BX2:=X2-Thickness-2;
  BY2:=Y2-Thickness-10;
End;

Procedure GraphicWindow.VertSlideButtonPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=X2-Thickness-10;
  BY1:=VSlideButtonPos;
  BX2:=X2-Thickness-2;
  BY2:=VSlideButtonPos+8;
End;

Procedure GraphicWindow.VertSlideButtonUpPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=X2-Thickness-10;
  BY1:=Y1+Thickness+14;
  BX2:=X2-Thickness-2;
  BY2:=Y1+Thickness+22;
End;

Procedure GraphicWindow.VertSlideButtonDownPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=X2-Thickness-10;
  BY1:=Y2-Thickness-10;
  BX2:=X2-Thickness-2;
  BY2:=Y2-Thickness-2;
End;

Procedure GraphicWindow.HorzSlideBarPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=X1+Thickness+11;
  BY1:=Y2-Thickness-10;
  BX2:=X2-Thickness-21;
  BY2:=Y2-Thickness-2;
End;

Procedure GraphicWindow.HorzSlideButtonPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=HSlideButtonPos;
  BY1:=Y2-Thickness-9;
  BX2:=HSlideButtonPos+9;
  BY2:=Y2-Thickness;
End;

Procedure GraphicWindow.HorzSlideButtonLeftPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=X1+Thickness+2;
  BY1:=Y2-Thickness-10;
  BX2:=X1+Thickness+11;
  BY2:=Y2-Thickness-1;
End;

Procedure GraphicWindow.HorzSlideButtonRightPos(Var BX1,BY1,BX2,BY2:Word);
Begin
  BX1:=X2-Thickness-20;
  BY1:=Y2-Thickness-10;
  BX2:=X2-Thickness-11;
  BY2:=Y2-Thickness-1;
End;

Procedure GraphicWindow.Lock;
Begin
  SetViewPort(X1,Y1,X2,Y2,ClipOn);
End;

Procedure GraphicWindow.UnLock;
Begin
  SetViewPort(0,0,GetMaxX,GetMaxY,ClipOn);
End;

Procedure GraphicWindow.Close;
Begin
  Mouse.Hide;
  If KeepBack Then
  Begin
    If (Status=Visible) Then
      PutImage(X1,Y1,Save^,NormalPut);
  End
  Else
  Begin
    SetFillStyle(SolidFill,BoxBck);
    Bar(X1,Y1,X2,Y2);
  End;

  Mouse.Show;
  FreeMem(Save,Size);
  Buttons.KillAll;
End;

{ Copyright 1993, Michael Gallias }
