PROGRAM DEMO;

{
  Chrome Interface Demo V1.0
  This program demonstrates some of the aspects of
  the Chrome Interface Library, V1.0.

  Created 10/9/93
}

{ Use Chrome Interface Library, and the Graph unit }

USES Chrome,Graph;

{ These constants are defined to simplify Menu ID's into a readable
  form }

CONST
     BUTTONDEMO=1;
     CHECKDEMO=2;
     PROPDEMO=3;
     LISTDEMO=4;
     STRINGDEMO=5;
     LINKDEMO=6;
     WINDOWDEMO=7;
     EVENTDEMO=8;
     ABOUT=9;
     REQDEMO=10;

     QUIT=100;

VAR
   WM:WinManager;   {The Window Manager Object}

   {Menu List Pointers}

   MainMenu:PMenuList;
   GadgetDemos:PMenuList;
   MenuDemos,MenuDemosLevel2,QuickKeyExample:PMenuList;
   IODemos:PMenuList;

   aw:PWindow;  {Pointer to the active window}

   Port,MenuID:integer;  {Information exchage variables}

   terminated:BOOLEAN; {Quit flag}

   {About Demo Section Variables}

   AboutWin:PWindow;
   AboutView:PGadget;
   AboutList:PListHeader;

   {Window Demo Section Variables}

   WindowWin:PWindow;
   WindowView:PGadget;
   WindowList:PListHeader;

   {Button Demo Section Variables}

   ButtonWin:PWindow;
   ButtonView:PGadget;
   ButtonList:PListHeader;

   {Check Box Demo Section Variables}

   CheckWin:PWindow;
   CheckView:PGadget;
   CheckList:PListHeader;

   {Proportional Demo Section Variables}

   PropWin:PWindow;
   PropView,p1,p2:PGadget;
   PropList:PListHeader;

   {List Demo Section Variables}

   ListWin:PWindow;
   ListView,ListSelect:PGadget;
   ListList,ListList2:PListHeader;

   {String Demo Section Variables}

   StringWin:PWindow;
   StringView,sgad:PGadget;
   StringList:PListHeader;

   {Link Demo Section Variables}

   LinkWin:PWindow;

   LinkView,viewprop:PGadget;
   LinkList:PListHeader;
   viewgroup:PLinkGadList;

   st,prop:PGadget;
   stpropgroup:PLinkGadList;

   st1,st2,st3:PGadget;
   st2stgroup:PLinkGadList;

   ck1,ck2,ck3:PGadget;
   ckexgroup:PLinkGadList;

   {Event Demo Section Variables}

   EventWin:PWindow;
   EventView:PGadget;
   EventList:PListHeader;


{Include some predefined Links into the program.}

{$I LINKS.PAS}


PROCEDURE InitDemo;
{This procedure Initializes the menus, and sets some pointers to nil }

BEGIN
     {Gadget Demo Menus}

     GadgetDemos:=WM.NewMenuHeader('Gadget Demos');
     WM.NewMenuNode(GadgetDemos,'Button Gadgets...      ',BUTTONDEMO,#0,NIL);
     WM.NewMenuNode(GadgetDemos,'CheckBox Gadgets...    ',CHECKDEMO ,#0,NIL);
     WM.NewMenuNode(GadgetDemos,'Proportional Gadgets...',PROPDEMO  ,#0,NIL);
     WM.NewMenuNode(GadgetDemos,'List Gadgets...        ',LISTDEMO  ,#0,NIL);
     WM.NewMenuNode(GadgetDemos,'String Gadgets...      ',STRINGDEMO,#0,NIL);
     WM.NewMenuNode(GadgetDemos,''                       ,0         ,#0,NIL);
     WM.NewMenuNode(GadgetDemos,'Gadget Links...        ',LINKDEMO  ,#0,NIL);

     {Menu Demo Menus}

     QuickKeyExample:=WM.NewMenuHeader('Quick Key');
     WM.NewMenuNode(QuickKeyExample,'  Menu Demo Done  ',0,#0,NIL);

     MenuDemosLevel2:=WM.NewMenuHeader('More Info');
     WM.NewMenuNode(MenuDemosLevel2,'Menus stay open until the user',0,#0,NIL);
     WM.NewMenuNode(MenuDemosLevel2,'is ready to close them.  Items',0,#0,NIL);
     WM.NewMenuNode(MenuDemosLevel2,'can have alt-codes for quick  ',0,#0,NIL);
     WM.NewMenuNode(MenuDemosLevel2,'access.  Press Alt-M or click ',0,#0,NIL);
     WM.NewMenuNode(MenuDemosLevel2,'below to demonstrate this.    ',0,#0,NIL);
     WM.NewMenuNode(MenuDemosLevel2,''                              ,0,#0,NIL);
     WM.NewMenuNode(MenuDemosLevel2,'Quick Key Example      Alt-M  ',0,#50,QuickKeyExample);

     MenuDemos:=WM.NewMenuHeader('Menu Demos');
     WM.NewMenuNode(MenuDemos,'Menus allow easy selection  ',0,#0,NIL);
     WM.NewMenuNode(MenuDemos,'from lists to get around    ',0,#0,NIL);
     WM.NewMenuNode(MenuDemos,'any program.  Menus can have',0,#0,NIL);
     WM.NewMenuNode(MenuDemos,'infinite levels of submenus.',0,#0,NIL);
     WM.NewMenuNode(MenuDemos,''                            ,0,#0,NIL);
     WM.NewMenuNode(MenuDemos,'Click For More On Menus     ',0,#0,MenuDemosLevel2);

     MainMenu:=WM.NewMenuHeader('Chrome Interface');
     WM.NewMenuNode(MainMenu,'About...         ',ABOUT     ,#0 ,nil);
     WM.NewMenuNode(MainMenu,''                 ,0         ,#0 ,nil);
     WM.NewMenuNode(MainMenu,'Window Demo...   ',WINDOWDEMO,#0 ,nil);
     WM.NewMenuNode(MainMenu,'Requester Demo...',REQDEMO   ,#0 ,nil);
     WM.NewMenuNode(MainMenu,'Menu Demo        ',0         ,#0 ,MenuDemos);
     WM.NewMenuNode(MainMenu,'Gadget Demos     ',0         ,#0 ,GadgetDemos);
     WM.NewMenuNode(MainMenu,'Event Demo...    ',EVENTDEMO ,#0 ,nil);
     WM.NewMenuNode(MainMenu,''                 ,0         ,#0 ,nil);
     WM.NewMenuNode(MainMenu,'Quit        Alt-Q',QUIT      ,#16,nil);

     WM.SetGlobalMenu(MainMenu);

     AboutWin:=nil;
     WindowWin:=nil;
     ButtonWin:=nil;
     CheckWin:=nil;
     PropWin:=nil;
     ListWin:=nil;
     StringWin:=nil;
     LinkWin:=nil;
     EventWin:=nil;
END;

PROCEDURE DoneDemo;
{This procedure Cleans up the demo, including reseting the global menu and
 disposing the menus that were allocated}

BEGIN
     WM.SetGlobalMenu(nil);

     WM.DisposeMenu(MainMenu);
     WM.DisposeMenu(GadgetDemos);
     WM.DisposeMenu(MenuDemos);
     WM.DisposeMenu(MenuDemosLevel2);
     WM.DisposeMenu(QuickKeyExample);
END;

{For the following procedures, the ones ending in Proc initialize the
 specific demo, the ones ending in Handler handle events that are sent
 to that part of the demos window.}

Procedure AboutDemoProc;
BEGIN
     AboutWin:=WM.NewWindow('About',200,95,240,290,WFLAG_CLOSEGADGET);

     AboutView:=WM.NewGadget(GTYPE_VIEWLIST,'',10,14,210,231,GFLAG_NOTHING);

     AboutList:=WM.NewListHeader;
     WM.NewListNode(AboutList,'Chrome Interface Demo V1.0');
     WM.NewListNode(AboutList,'Chrome Interface Library V1.0');
     WM.NewListNode(AboutList,'');
     WM.NewListNode(AboutList,'The Chrome Interface library is');
     WM.NewListNode(AboutList,'a unit which gives Turbo Pascal');
     WM.NewListNode(AboutList,'7.0 users the ability to');
     WM.NewListNode(AboutList,'add a graphical user interface');
     WM.NewListNode(AboutList,'to their dos programs with maximum');
     WM.NewListNode(AboutList,'ease.  This program demonstrates');
     WM.NewListNode(AboutList,'some of the aspects of the library.');
     WM.NewListNode(AboutList,'');
     WM.NewListNode(AboutList,'Please read the readme file which');
     WM.NewListNode(AboutList,'came with this program.  For more');
     WM.NewListNode(AboutList,'information, contact:');
     WM.NewListNode(AboutList,'');
     WM.NewListNode(AboutList,'High Velocity Systems');
     WM.NewListNode(AboutList,'6521 S 41st Street');
     WM.NewListNode(AboutList,'Lincoln, NE  68516');
     WM.NewListNode(AboutList,'');
     WM.NewListNode(AboutList,'Internet: jvanabra@nyx.cs.du.edu');

     WM.SetGadgetList(AboutView,AboutList);
END;

Procedure AboutDemoHandler(port:integer);
BEGIN
     if WM.EventInPort(EVENT_ASKCLOSEWINDOW,port) then
     BEGIN
          WM.DisposeWindow(AboutWin);
          WM.DisposeList(AboutList);

          AboutWin:=nil;
     END;
END;

Procedure WindowDemoProc;
BEGIN
     WindowWin:=WM.NewWindow('Windows',190,60,260,350,WFLAG_STANDARD);

     WindowView:=WM.NewGadget(GTYPE_VIEWLIST,'',10,14,235,291,GFLAG_NOTHING);

     WindowList:=WM.NewListHeader;
     WM.NewListNode(WindowList,'Windows');
     WM.NewListNode(WindowList,'');
     WM.NewListNode(WindowList,'A window is a graphical area of the');
     WM.NewListNode(WindowList,'screen which functions as the');
     WM.NewListNode(WindowList,'primary unit of interaction.');
     WM.NewListNode(WindowList,'');
     WM.NewListNode(WindowList,'All windows are similar.  They all');
     WM.NewListNode(WindowList,'consist of a border.  In the border');
     WM.NewListNode(WindowList,'there are gadgets, or active areas');
     WM.NewListNode(WindowList,'of the window which respond to mouse');
     WM.NewListNode(WindowList,'clicks.  One may click on the title');
     WM.NewListNode(WindowList,'bar to move the window,');
     WM.NewListNode(WindowList,'click on the zoom button (the one');
     WM.NewListNode(WindowList,'with the double arrows) to change');
     WM.NewListNode(WindowList,'the window to its alternate size');
     WM.NewListNode(WindowList,'and position, click on the');
     WM.NewListNode(WindowList,'Close (X) gadget to close the window,');
     WM.NewListNode(WindowList,'or click on the lower right hand corner');
     WM.NewListNode(WindowList,'of the window to change the window''s');
     WM.NewListNode(WindowList,'size.');
     WM.NewListNode(WindowList,'');
     WM.NewListNode(WindowList,'Everything the programmer manipulates');
     WM.NewListNode(WindowList,'is done between the window borders.');
     WM.NewListNode(WindowList,'There, manipulation may be done using');
     WM.NewListNode(WindowList,'the Library''s built in procedures,');
     WM.NewListNode(WindowList,'or the programmer may use BGI routines');
     WM.NewListNode(WindowList,'to draw directly into the window');
     WM.NewListNode(WindowList,'themselves.');

     WM.SetGadgetList(WindowView,WindowList);
END;

Procedure WindowDemoHandler(port:integer);
BEGIN
     if WM.EventInPort(EVENT_ASKCLOSEWINDOW,port) then
     BEGIN
          WM.DisposeWindow(WindowWin);
          WM.DisposeList(WindowList);

          WindowWin:=nil;
     END;
END;

Procedure ReqDemoProc;
{ The requester demo is quite simple, since each request takes over the
  system until it is finished, no Handler is required}

var
   result:integer;
BEGIN
     WM.Request('Requester Example','Requesters can be created using only one command.',
                'They allow an easy way to provide information,','Continue','','');

     Repeat
           result:=WM.Request('Requester Example, cont.','...or an easy way to ask a pressing question',
                              'Isn''t this a great demo?','Yes','No','');

           If result<>1 then
              WM.Request('Information','I''m sorry, you pressed the wrong button.','','Continue','','');
     Until result=1;
END;

Procedure ButtonDemoProc;
var
   tst:string;
   x:integer;

BEGIN
     ButtonWin:=WM.NewWindow('Button Demo',200,100,300,240,WFLAG_CLOSEGADGET);

     for x:=1 to 10 do
     BEGIN
          Str(x,tst);
          WM.NewGadget(GTYPE_BUTTON,'Gad #'+tst,10,11+12*x,60,11,GFLAG_NOTHING);
     END;

     ButtonView:=WM.NewGadget(GTYPE_VIEWLIST,'',100,10,180,201,GFLAG_NOTHING);

     ButtonList:=WM.NewListHeader;
     WM.NewListNode(ButtonList,'Button Gadgets');
     WM.NewListNode(ButtonList,'');
     WM.NewListNode(ButtonList,'Button Gadgets allow the');
     WM.NewListNode(ButtonList,'programmer to instantly');
     WM.NewListNode(ButtonList,'respond to a press of the');
     WM.NewListNode(ButtonList,'mouse button within a defined');
     WM.NewListNode(ButtonList,'area.');
     WM.NewListNode(ButtonList,'');
     WM.NewListNode(ButtonList,'Button Gadgets are used by');
     WM.NewListNode(ButtonList,'the Chrome Interface Library');
     WM.NewListNode(ButtonList,'to make the menuing system.');

     WM.SetGadgetList(ButtonView,ButtonList);
END;

Procedure ButtonDemoHandler(port:integer);
BEGIN
     if WM.EventInPort(EVENT_ASKCLOSEWINDOW,port) then
     BEGIN
          WM.DisposeWindow(ButtonWin);
          WM.DisposeList(ButtonList);

          ButtonWin:=nil;
     END;
END;

Procedure CheckDemoProc;
var
   x:integer;
   tst:string;

BEGIN
     CheckWin:=WM.NewWindow('CheckBox Demo',200,100,300,240,WFLAG_CLOSEGADGET);

     for x:=1 to 10 do
     BEGIN
          Str(x,tst);
          WM.NewGadget(GTYPE_CHECKBOX,'Gad #'+tst,10,11+12*x,11,11,GFLAG_NOTHING);
     END;

     CheckView:=WM.NewGadget(GTYPE_VIEWLIST,'',100,10,180,201,GFLAG_NOTHING);

     CheckList:=WM.NewListHeader;
     WM.NewListNode(CheckList,'Checkbox Gadgets');
     WM.NewListNode(CheckList,'');
     WM.NewListNode(CheckList,'Checkbox gadgets allow the');
     WM.NewListNode(CheckList,'programmer to get on/off');
     WM.NewListNode(CheckList,'states from the user.');
     WM.NewListNode(CheckList,'');
     WM.NewListNode(CheckList,'Checkbox gadgets are usually');
     WM.NewListNode(CheckList,'used in the configuration part');
     WM.NewListNode(CheckList,'of a program to allow the');
     WM.NewListNode(CheckList,'user to select certain');
     WM.NewListNode(CheckList,'features.');

     WM.SetGadgetList(CheckView,CheckList);
END;

Procedure CheckDemoHandler(port:integer);
BEGIN
     if WM.EventInPort(EVENT_ASKCLOSEWINDOW,port) then
     BEGIN
          WM.DisposeWindow(CheckWin);
          WM.DisposeList(CheckList);

          CheckWin:=nil;
     END;
END;

Procedure PropDemoProc;
var
   x:integer;

BEGIN
     PropWin:=WM.NewWindow('Proportional Demo',200,100,350,240,WFLAG_CLOSEGADGET);

     p1:=WM.NewGadget(GTYPE_HPROPORTIONAL,'A',14,11,76,11,GFLAG_NOTHING);
     p2:=WM.NewGadget(GTYPE_VPROPORTIONAL,'B',45,45,11,140,GFLAG_NOTHING);

     WM.SetProportionalFraction(p1,1,10);
     WM.SetProportionalFraction(p2,6,15);

     PropView:=WM.NewGadget(GTYPE_VIEWLIST,'',100,10,230,201,GFLAG_NOTHING);

     PropList:=WM.NewListHeader;
     WM.NewListNode(PropList,'Proportional Gadgets');
     WM.NewListNode(PropList,'');
     WM.NewListNode(PropList,'Proportional Gadgets are used');
     WM.NewListNode(PropList,'to represent a range of integer');
     WM.NewListNode(PropList,'values, and/or a percentage');
     WM.NewListNode(PropList,'of something that can be viewed.');
     WM.NewListNode(PropList,'');
     WM.NewListNode(PropList,'For example, VGA palette entries');
     WM.NewListNode(PropList,'for one componet of a color are');
     WM.NewListNode(PropList,'valid for the numbers 0-63.');
     WM.NewListNode(PropList,'Proportional gadgets could be used');
     WM.NewListNode(PropList,'to allow the user to select a value.');
     WM.NewListNode(PropList,'');
     WM.NewListNode(PropList,'In a list of strings, proportional');
     WM.NewListNode(PropList,'gadgets can represent the percentage');
     WM.NewListNode(PropList,'of the list that is viewable, and');
     WM.NewListNode(PropList,'how much more there is in the list');
     WM.NewListNode(PropList,'that can not be seen.');

     WM.SetGadgetList(PropView,PropList);
END;

Procedure PropDemoHandler(port:integer);
BEGIN
     if WM.EventInPort(EVENT_ASKCLOSEWINDOW,port) then
     BEGIN
          WM.DisposeWindow(PropWin);
          WM.DisposeList(PropList);

          PropWin:=nil;
     END;
END;

Procedure ListDemoProc;
var
   x:integer;
   tst:string;

BEGIN
     ListWin:=WM.NewWindow('List Demo',200,100,350,240,WFLAG_CLOSEGADGET);

     ListSelect:=WM.NewGadget(GTYPE_SELECTLIST,'Select List',10,14,100,180,GFLAG_NOTHING);
     ListView:=WM.NewGadget(GTYPE_VIEWLIST,'View List',130,14,200,201,GFLAG_NOTHING);

     ListList:=WM.NewListHeader;
     WM.NewListNode(ListList,'List Gadgets');
     WM.NewListNode(ListList,'');
     WM.NewListNode(ListList,'Information is given to users');
     WM.NewListNode(ListList,'through the use of a view list');
     WM.NewListNode(ListList,'gadget like this one.');
     WM.NewListNode(ListList,'');
     WM.NewListNode(ListList,'Users can be allowed to select');
     WM.NewListNode(ListList,'from a list of text by the use');
     WM.NewListNode(ListList,'of a select list gadget.');
     WM.NewListNode(ListList,'');
     WM.NewListNode(ListList,'Both types are easily linked to');
     WM.NewListNode(ListList,'a proportional gadget to allow');
     WM.NewListNode(ListList,'for navigation of lists larger');
     WM.NewListNode(ListList,'than the height of the gadget.');


     ListList2:=WM.NewListHeader;

     For x:=1 to 18 do
     BEGIN
          Str(x,tst);
          WM.NewListNode(ListList2,'Selection '+tst);
     END;

     WM.SetGadgetList(ListView,ListList);
     WM.SetGadgetList(ListSelect,ListList2);
END;

Procedure ListDemoHandler(port:integer);
BEGIN
     if WM.EventInPort(EVENT_ASKCLOSEWINDOW,port) then
     BEGIN
          WM.DisposeWindow(ListWin);
          WM.DisposeList(ListList2);
          WM.DisposeList(ListList);

          ListWin:=nil;
     END;
END;

Procedure StringDemoProc;
BEGIN
     StringWin:=WM.NewWindow('String Demo',200,100,350,240,WFLAG_CLOSEGADGET);

     sgad:=WM.NewGadget(GTYPE_STRING,'String Gad',10,14,100,15,GFLAG_NOTHING);
     WM.SetString(sgad,'Edit Me');

     StringView:=WM.NewGadget(GTYPE_VIEWLIST,'',130,14,200,201,GFLAG_NOTHING);

     StringList:=WM.NewListHeader;
     WM.NewListNode(StringList,'String Gadgets');
     WM.NewListNode(StringList,'');
     WM.NewListNode(StringList,'String gadgets allow the');
     WM.NewListNode(StringList,'programmer to get strings of');
     WM.NewListNode(StringList,'text from the user.  These');
     WM.NewListNode(StringList,'strings can be converted to');
     WM.NewListNode(StringList,'numbers by the use of standard');
     WM.NewListNode(StringList,'Pascal routines.');
     WM.NewListNode(StringList,'');
     WM.NewListNode(StringList,'To accept the editing done in');
     WM.NewListNode(StringList,'the string gadget, the user');
     WM.NewListNode(StringList,'presses return.  To abort, the');
     WM.NewListNode(StringList,'user clicks the mouse outside');
     WM.NewListNode(StringList,'of the string gadget.');

     WM.SetGadgetList(StringView,StringList);
END;

Procedure StringDemoHandler(port:integer);
BEGIN
     if WM.EventInPort(EVENT_ASKCLOSEWINDOW,port) then
     BEGIN
          WM.DisposeWindow(StringWin);
          WM.DisposeList(StringList);

          StringWin:=nil;
     END;
END;

Procedure LinkDemoProc;
BEGIN
     LinkWin:=WM.NewWindow('Link Demo',200,100,430,240,WFLAG_CLOSEGADGET);

     LinkList:=WM.NewListHeader;
     WM.NewListNode(LinkList,'Gadget Links');
     WM.NewListNode(LinkList,'');
     WM.NewListNode(LinkList,'Gadgets can be grouped together');
     WM.NewListNode(LinkList,'by the use of gadget links.');
     WM.NewListNode(LinkList,'The actual gadget linking code');
     WM.NewListNode(LinkList,'is a procedure which is called');
     WM.NewListNode(LinkList,'automatically whenever a gadget');
     WM.NewListNode(LinkList,'in a defined group is changed.');
     WM.NewListNode(LinkList,'That procedure is passed the');
     WM.NewListNode(LinkList,'list of gadgets within its');
     WM.NewListNode(LinkList,'group.');
     WM.NewListNode(LinkList,'');
     WM.NewListNode(LinkList,'The links shown here come with');
     WM.NewListNode(LinkList,'the Chrome Interface Library.');
     WM.NewListNode(LinkList,'This view list gadget is linked');
     WM.NewListNode(LinkList,'to a proportional gadget. The');
     WM.NewListNode(LinkList,'other proportional gadget in the');
     WM.NewListNode(LinkList,'window is linked to the string');
     WM.NewListNode(LinkList,'gadget directly below it.  The');
     WM.NewListNode(LinkList,'other three string gadgets are');
     WM.NewListNode(LinkList,'linked to each other so that');
     WM.NewListNode(LinkList,'pressing the return key moves');
     WM.NewListNode(LinkList,'to the next string gadget.');
     WM.NewListNode(LinkList,'The three checkbox gadgets are');
     WM.NewListNode(LinkList,'linked so that one and only one');
     WM.NewListNode(LinkList,'of the checkboxes are on at');
     WM.NewListNode(LinkList,'once.');

     LinkView:=WM.NewGadget(GTYPE_VIEWLIST,'',200,14,200,WM.ConvertListLinesToHeight(15),GFLAG_NOTHING);
     WM.SetGadgetList(LinkView,LinkList);

     viewprop:=WM.NewGadget(GTYPE_VPROPORTIONAL,'',400,14,11,WM.ConvertListLinesToHeight(15),GFLAG_NOTHING);
     WM.SetProportionalFraction(viewprop,15,27);

     viewgroup:=WM.NewLinkGadgetHeader(@LinkProportionalToList);
     WM.NewLinkGadgetNode(viewgroup,LinkView);
     WM.NewLinkGadgetNode(viewgroup,viewprop);

     prop:=WM.NewGadget(GTYPE_HPROPORTIONAL,'',10,10,100,11,GFLAG_NOTHING);
     st:=WM.NewGadget(GTYPE_STRING,'',40,25,40,15,GFLAG_NOTHING);
     WM.SetProportionalFraction(prop,1,101);
     WM.SetProportionalOffsetScale(prop,-51,2);
     WM.SetGadgetState(prop,0);
     WM.SetString(st,'0');

     stpropgroup:=WM.NewLinkGadgetHeader(@LinkProportionalToString);
     WM.NewLinkGadgetNode(stpropgroup,st);
     WM.NewLinkGadgetNode(stpropgroup,prop);

     st1:=WM.NewGadget(GTYPE_STRING,'',10,60,100,15,GFLAG_NOTHING);
     st2:=WM.NewGadget(GTYPE_STRING,'',10,77,100,15,GFLAG_NOTHING);
     st3:=WM.NewGadget(GTYPE_STRING,'',10,94,100,15,GFLAG_NOTHING);

     WM.SetString(st1,'These Gadgets');
     WM.SetString(st2,'Are');
     WM.SetString(st3,'Linked.');

     st2stgroup:=WM.NewLinkGadgetHeader(@LinkStringToString);
     WM.NewLinkGadgetNode(st2stgroup,st3);
     WM.NewLinkGadgetNode(st2stgroup,st2);
     WM.NewLinkGadgetNode(st2stgroup,st1);

     ck1:=WM.NewGadget(GTYPE_CHECKBOX,'Exclusive',10,130,11,11,GFLAG_NOTHING);
     ck2:=WM.NewGadget(GTYPE_CHECKBOX,'Checkbox',10,145,11,11,GFLAG_NOTHING);
     ck3:=WM.NewGadget(GTYPE_CHECKBOX,'Selection',10,160,11,11,GFLAG_NOTHING);

     WM.SetGadgetState(ck1,ON);

     ckexgroup:=WM.NewLinkGadgetHeader(@LINKCheckBoxExclusive);
     WM.NewLinkGadgetNode(ckexgroup,ck3);
     WM.NewLinkGadgetNode(ckexgroup,ck2);
     WM.NewLinkGadgetNode(ckexgroup,ck1);
END;

Procedure LinkDemoHandler(port:integer);
BEGIN
     if WM.EventInPort(EVENT_ASKCLOSEWINDOW,port) then
     BEGIN
          WM.DisposeWindow(LinkWin);
          WM.DisposeList(LinkList);

          LinkWin:=nil;
     END;
END;

Procedure EventDemoProc;
BEGIN
     EventWin:=WM.NewWindow('Events',200,95,240,290,WFLAG_STANDARD);

     EventView:=WM.NewGadget(GTYPE_VIEWLIST,'',10,14,210,200,GFLAG_NOTHING);

     EventList:=WM.NewListHeader;
     WM.NewListNode(EventList,'Events');
     WM.NewListNode(EventList,'');
     WM.NewListNode(EventList,'All important operations done by');
     WM.NewListNode(EventList,'the user are reported to the');
     WM.NewListNode(EventList,'programmer as an event.  When');
     WM.NewListNode(EventList,'an event is received, the');
     WM.NewListNode(EventList,'programmer can use procedures to');
     WM.NewListNode(EventList,'get more information on the event,');
     WM.NewListNode(EventList,'and then he/she may respond to the');
     WM.NewListNode(EventList,'event.');
     WM.NewListNode(EventList,'');
     WM.NewListNode(EventList,'Try clicking in different areas');
     WM.NewListNode(EventList,'and pushing keys on the keyboard');
     WM.NewListNode(EventList,'now.  The events are displayed');
     WM.NewListNode(EventList,'as they happen below this gadget.');

     WM.SetGadgetList(EventView,EventList);
END;

Procedure EventDemoHandler(port:integer);
{ Since this is the most complex handler, it will be further explained}

var
   information:string;
   temp:string;

   procedure OutputInformation;
   {This procedure outputs the variable information in a nice fasion in the
    window}

   BEGIN
        { The PrepareUserOuput/DoneUserOutput pairing is required whenever
         we draw directly into the windows on our own. }

        WM.PrepareUserOutput;

        WM.FillBox(Gray,10,215,221,230);
        WM.DrawBevelBoxInv(10,215,221,230);

        SetColor(Black);
        OutTextXY(20,217,information);

        WM.DoneUserOutput;
   END;

BEGIN
     information:='';

     {We check for all of the possible events that could happen and
      set information equal to the name of the event constant.}

     {A gadget has been pressed, its PGadget ID is available in
      QueryGadgetPressed}

     if WM.EventInPort(EVENT_GADGETPRESSED,port) then
     BEGIN
          information:='GADGETPRESSED ID:';

          str(abs(LongInt(WM.QueryGadgetPressed)),temp);
          information:=information+temp;
     END;

     {Someone has pushed on a close gadget, and this window is asking
      to be closed.  Use Dispose Window to close then window, and
      then perform any other clean up that is needed}

     if WM.EventInPort(EVENT_ASKCLOSEWINDOW,port) then
     BEGIN
          information:='ASKCLOSEWINDOW';

          WM.DisposeWindow(EventWin);
          WM.DisposeList(EventList);

          EventWin:=nil;

          exit;
     END;

     {A Window has been sized, Use QueryWindowWidth/QueryWindowInnerWidth,
      QueryWindowHeight,QueryWindowInnerHeight to get the new sizing
      information.  Since gadgets are automatically updated, we dont
      have to worry about redrawing them.  However, any thing else,
      the user must redraw}

     if WM.EventInPort(EVENT_SIZEWINDOW,port) then
     BEGIN
          information:='SIZEWINDOW w';
          Str(WM.QueryWindowWidth,temp);
          information:=information+temp+' h';
          Str(WM.QueryWindowHeight,temp);
          information:=information+temp;
     END;

     {A New Window has been activated and is now the front most window.
      We need not do any updating, all of the window imagery is stored
      and updated for us.}

     if WM.EventInPort(EVENT_ACTIVATEWINDOW,port) then
     BEGIN
          information:='ACTIVATEWINDOW ID:';

          str(abs(LongInt(WM.QueryWindowActive)),temp);
                information:=information+temp;
     END;

     {The left mouse button has been pressed.  One can use QueryMouseX and
      QueryMouseY to get the positional information of the mouse relative
      to the current window at any time.}

     if WM.EventInPort(EVENT_LMBPRESSED,port) then
     BEGIN
          information:='LBMPRESSED x';

          str(WM.QueryMouseX,temp);
          information:=information+temp+' y';
          str(WM.QueryMouseY,temp);
          information:=information+temp;
     END;

     {The right mouse button has been pressed}

     if WM.EventInPort(EVENT_RMBPRESSED,port) then
     BEGIN
          information:='RMBPRESSED x';

          str(WM.QueryMouseX,temp);
          information:=information+temp+' y';
          str(WM.QueryMouseY,temp);
          information:=information+temp;
     END;

     {The left mouse button has been released}

     if WM.EventInPort(EVENT_LMBRELEASED,port) then
     BEGIN
          information:='LMBRELEASED';
     END;

     {The right mouse button has been released}

     if WM.EventInPort(EVENT_RMBRELEASED,port) then
     BEGIN
          information:='RMBRELEASED';
     END;

     {A key has been pressed, it is available in QueryKeyPressed.}

     if WM.EventInPort(EVENT_KEYPRESSED,port) then
     BEGIN
          information:='KEYPRESSED '+WM.QueryKeyPressed;
     END;

     {An extended key has been pressed, it's code is availale in
      QueryExtKeyPressed. }

     if WM.EventInPort(EVENT_EXTKEYPRESSED,port) then
     BEGIN
          information:='EXTKEYPRESSED X';
     END;

     {A Menu has been pressed, its ID is available in QueryMenuPressed}

     if WM.EventInPort(EVENT_MENUPRESSED,port) then
     BEGIN
          information:='MENUPRESSED ID:';
          Str(WM.QueryMenuPressed,temp);
          information:=information+temp;
     END;

     OutputInformation;  {Output the new information}
END;

BEGIN
     {Init the Window Manager Object, pass the title of the program
      and the name of the programmer. }

     WM.Init('Chrome Interface Demo','High Velocity Systems');

     {Do our initialization}

     InitDemo;

     {Start the loop, continue until terminated}

     Repeat
           {Wait for there to been an event in the port}

           Repeat
                 WM.WinEventManager;

                 Port:=WM.QueryEventPort;
           Until Port<>0;

           {If its a menu event, then we need to init that demo section
            if it is not already open}

           if WM.EventInPort(EVENT_MENUPRESSED,Port) then
           BEGIN
              MenuID:=WM.QueryMenuPressed;

              case MenuID of
                   BUTTONDEMO:
                    If ButtonWin=nil then
                     ButtonDemoProc;
                   CHECKDEMO:
                    If CheckWin=nil then
                     CheckDemoProc;
                   PROPDEMO:
                    If PropWin=nil then
                     PropDemoProc;
                   LISTDEMO:
                    If ListWin=nil then
                     ListDemoProc;
                   STRINGDEMO:
                    If StringWin=nil then
                     StringDemoProc;
                   LINKDEMO:
                    If LinkWin=nil then
                     LinkDemoProc;
                   WINDOWDEMO:
                    If WindowWin=nil then
                     WindowDemoProc;
                   EVENTDEMO:
                    If EventWin=nil then
                     EventDemoProc;
                   ABOUT:
                    If AboutWin=nil then
                     AboutDemoProc;
                   REQDEMO:
                     ReqDemoProc;
                   QUIT:
                     terminated:=TRUE;
              end;
           END
           else
           {Otherwize we need to handle the event according to each
            individual window's handler}
           BEGIN
                aw:=WM.QueryWindowActive;

                If aw=ButtonWin then
                   ButtonDemoHandler(Port)
                else if aw=CheckWin then
                   CheckDemoHandler(Port)
                else if aw=PropWin then
                   PropDemoHandler(Port)
                else if aw=ListWin then
                   ListDemoHandler(Port)
                else if aw=StringWin then
                   StringDemoHandler(Port)
                else if aw=LinkWin then
                   LinkDemoHandler(Port)
                else if aw=WindowWin then
                   WindowDemoHandler(Port)
                else if aw=EventWin then
                   EventDemoHandler(Port)
                else if aw=AboutWin then
                   AboutDemoHandler(Port);
           END;
     Until terminated;

     {Clean up some stuff}

     DoneDemo;

     {Tell the Window Manager that we are done with it.}

     WM.Done;
END.