/*
 * CopyRight 1995. Nicholas Poljakov all rights reserved.
 */
#include <dos.h>
#include <stdio.h>
#include <memory.h>
#include <nau.h>
extern struct nau naua[100];

union REGS inregs, outregs;
struct SREGS segregs;

struct crec { /* for IPX interface this structure is the same as
               * for ASYNC driver, but fields after "asc_rcv_exit"
               * my have another sense.
               */
                void far *asc_rcv_exit;
                short socket;      /* my socket */
                char LocalName[8]; /* Name of local LU */
            } rec;

extern speed;
extern width;
extern parity;
extern n_port;
extern stop_num;
extern void DrEntry(void);

pattach(int n, char _far *pdata, int len)
{
        int i;
        char _far *p;

        if ( n == 0) {
           /*   Open   */
            rec.asc_rcv_exit = DrEntry; /* Entry point for device
                                         * driver.
                                         */
	    rec.socket = 0x4444;
            memcpy(rec.LocalName, naua[0].name, 8);
            p = &rec;
            inregs.x.dx = FP_OFF( p );
            segregs.ds = FP_SEG( p );
            inregs.x.ax = 0;
        }
        else
            if ( n == 1) {
               /*   Send   */
                p = pdata - 12;  /* points to start of segment */
                i = len + 28;
                inregs.x.dx = FP_OFF( p );
                segregs.ds = FP_SEG( p );
                inregs.x.cx = i;
		inregs.h.ah = 1;
		inregs.h.al = 0;

            }
            else
                if ( n == 2) {
                    /*   close   */
		     inregs.h.ah = 2;
		     inregs.h.al = 0;
		}

                else
		     if ( n == 3) {/* Detach_LU */
			  inregs.h.ah = 3;
			  inregs.h.al = 0;
                     }
                     else
                          return -1;

        int86x( 0x6f, &inregs, &outregs, &segregs);
        return 0;
}
