.MODEL LARGE
       INCLUDE precod.inc
.CODE
       PUBLIC _trans
_trans  proc
;**********************************************************
;*                                                        *
;*        Procedure for string translate.                 *
;*                                                        *
;* 1. Called : From "C" module -                          *
;*    int trans(target, source, length, Name)             *
;*    char far *target; - string "to",                    *
;*    char far *source; - string "from",                  *
;*    int  length;  - number of bytes for translation,    *
;*    int  Name; - name of trans. table.                  *
;*                                                        *
;* 2. Input : Parms are placed in stack.                  *
;*                                                        *
;* 3. Output: In the string pointed to by the "target"    *
;*    will be copied the "length" number of bytes         *
;*    which are translated according to the "Name" table. *                            *
;*                                                        *
;*                                                        *
;* CopyRight 1995. Nicholas Poljakov all rights reserved. *
;*                                                        *
;**********************************************************
       push bp
       mov  bp,sp
       push bx
       push cx
       push dx
       push di
       push si
       push es
       push ds
;
       mov  ax, seg _DATA
       mov  ds, ax
       mov  di, [bp + 6]
       mov  dx, [bp + 8] ; save ES  es:di -> "to"
       mov  es, dx
       mov  si, [bp + 10]
       mov  dx, [bp + 12] ; DS is in DX
       mov  cx, [bp + 14]
       mov  ax, [bp + 16]
;
       cmp  ax,0    ; ASCIIalt to DKOI
       jne  next00
       lea  bx, es :T_A_D_1
       jmp  tr_start
next00:
       cmp  ax,2    ; ASCIIm to DKOI
       jne  next01
       lea  bx, es :T_A_D_2
       jmp  tr_start
next01:
       cmp  ax,4    ; ASCIIint to DKOI
       jne  next02
       lea  bx, es :T_A_D_3
       jmp  tr_start
next02:
       cmp  ax,1    ; DKOI to ASCIIalt
       jne  next03
       lea  bx, es :T_D_A_1
       jmp  tr_start
next03:
       cmp  ax,3    ; DKOI to ASCIIm
       jne  next04
       lea  bx, es :T_D_A_2
       jmp  tr_start
next04:
       cmp  ax,5    ; DKOI to ASCIIint
       jne  next05
       lea  bx, es :T_D_A_3
       jmp  tr_start
next05:
       mov  ax, 0ffh
       jmp  tr_exit
;
;  DS:SI -> "from"; ES:DI -> "to"; BX -> trans. table;
;  CX - number of bytes
;
tr_start:
       cld
tr:
       push ds       ; save DS
       mov  ds, dx   ; DS now points to source string segment
       lodsb
       pop  ds       ; restory DS for XLAT
       xlat
       stosb
       loop tr
;
tr_exit:
       mov  ax, 0   ; return (0)
       pop  ds
       pop  es
       pop  si
       pop  di
       pop  dx
       pop  cx
       pop  bx
       pop  bp
       RET
_trans  endp
       END
