/*
                   CONFIRMED

 Function: handle the "confirmed" verb processing.
 Input: pointer to "confirmed" structure.

 CopyRight 1995. Nicholas Poljakov all rights reserved.

 */
#include <stdio.h>
#include <confd.h>
#include <state1.h>
#include <rcb.h>
#include <tcb.h>
#include <cma.h>
#include <repass.h>
#include <string.h>
#include <malloc.h>

int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);

confirmd(pptr)
struct confirmed *pptr;
{
struct rcb *p_rcb;
struct tcb *ptr_tcb;
struct cma ar;
unsigned char type;

int code;
int state;

#if OS_TYPE == 1 /* Unix System V */
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "confd");
pnum = 1;
drec = pptr;
lenr = sizeof(struct send_data);
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

     if (chkparm(pptr, &ar) == -1) {
        return(0);
     }
     p_rcb = ar.p_rcb;
     ptr_tcb = ar.p_tcb;

#if OS_TYPE == 1
     /* Check if the RCB is in the wait queue */
     if (sk_r_wt(p_rcb) == 0) {
        ptr -> prim_rc = INCOMPLETE;
        return (0);
     }
#endif

    /*   place the verb code into the RCB */
       p_rcb -> verb_code = pptr -> code;
       p_rcb -> verb_ptr = (char *)pptr;

       pptr -> prim_rc = 0;
       pptr -> sec_rc = 0;

       if ((state = fsm_conv('s', COnfirmed, p_rcb)) == -1)
            {
                pptr -> prim_rc = PORT_ABENDED;
		return 0;
            }
       if (state == 1)
            {
                pptr -> prim_rc = PORT_ABENDED;
		return 0;
            }
       else
           {
                type = COnfirmed;
                buffmng('A', NULL, NULL, p_rcb, 0, 0, type);
                sendhsf(p_rcb);
           }
       return 0;
}
