/**************************************************************/
/**                     GET_ATTRIBUTES                       **/
/**                                                          **/
/**  Function: Handles the requests for information about a  **/
/**            conversation.                                 **/
/**            Information about the conversation resource   **/
/**            is retrieves from the pertinent control       **/
/**            blocks, and then places into the returned     **/
/**            parameters of the GET_ATTRIBUTES verb.        **/
/**                                                          **/
/**  Input:    GET_ATTRIBUTES verb parameters                **/
/**                                                          **/
/**  Output:   GET_ATTRIBUTES verb returnes parameters       **/
/**            containing information about the conversation **/
/**                                                          **/
/**                                                          **/
/** CopyRight 1995. Nicholas Poljakov all rights reserved.   **/
/**                                                          **/
/**************************************************************/
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <gatt.h>
#include <tcb.h>
#include <mode.h>
#include <lucb.h>
#include <state1.h>
#include <partner.h>
#include <rcb.h>
#include <psp.h>
#include <cma.h>
#include <repass.h>

extern struct psp psp_ini;
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);

get_attr(pptr)
struct get_attributes *pptr;
 {
  struct lucb *p_lucb;
  struct pnlu *p_partner;
  struct tcb *p_tcb;
  struct rcb *p_rcb;
  struct repass *p_rep;
  struct cma ar;
  char s;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;	      /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "getattr");
pnum = 1;
drec = pptr;
lenr = sizeof(struct get_attributes);
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

    if (chkparm(pptr, &ar) == -1) {
       return(0);
    }
    p_rcb = ar.p_rcb;
    p_tcb = ar.p_tcb;

    p_rep = (struct repass *)pptr;

    pptr -> prim_rc = OK;
    pptr -> sec_rc = 0x00000000;

    p_lucb = psp_ini.lucb_list_ptr;
    p_partner = p_rcb -> p_partner;

    memcpy(pptr -> lu_id, p_lucb -> lu_id, 8);
    pptr -> sync_level = p_rcb -> sync_level;
    memcpy(pptr -> mode_name, p_rcb -> mode_name, 8);
    memcpy(pptr -> own_lu_name, p_lucb -> lu_name, 8);
    memcpy(pptr -> partner_lu_name, p_rcb -> lu_name, 8);
    memcpy(pptr -> init_security, p_tcb -> init_security, 8);
    memcpy(pptr -> sec_profile, p_tcb -> profile, 4);
    pptr -> sec_userid = p_tcb -> userid;
    memcpy(pptr -> conversation_correlator, p_rcb -> conv_correlator, 8);

    s ='S';
    p_rcb -> verb_code = Get_attributes;
    p_rcb -> verb_ptr = pptr;
    fsm_conv(s, Get_attributes, p_rcb);

    return 0;
 }
