/**********************************************************************/
/*               FINITE_STATE_MACHINE                                  */
/*                                                                     */
/*                      FSM_ERROR                                      */
/*                                                                     */
/*              fsm_error_or_failure procedure                         */
/*                                                                     */
/*  CopyRight 1995. Nicholas Poljakov all rights reserved.             */
/*                                                                     */
/***********************************************************************/
#include <stdio.h>
#include <malloc.h>
#include <state1.h>
#include <rcb.h>
#include <string.h>
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);

int fsm_error(p1,p_rcb)
 unsigned char p1;
 struct rcb *p_rcb;
{

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "fsmerr");
pnum = 1;
lenr = sizeof(struct rcb) + 1;
drec = malloc(lenr);
drec[0] = p1;
p = drec + 1;
memcpy(p, p_rcb, lenr - 1);
gtf(rtype, pname, pnum, drec, lenr);
free(drec);
/***********************************/
#endif

   switch (p1) {
        case CONV_FAIL_PROTOCOL :
             if((p_rcb->error_state == NO_RQS)||
                (p_rcb->error_state == RCVD_ERROR))
                {
                  p_rcb->error_state = CONV_FAILURE_PROTOCOL_ERROR;
                  goto ex0;
                }
             else
                { goto ex_1;}
        case CONV_FAIL_SON :
             if((p_rcb->error_state == NO_RQS)||
                (p_rcb->error_state == RCVD_ERROR))
                {
                  p_rcb->error_state = CONV_FAILURE_SON;
                  goto ex0;
                }
             else
                { goto ex_1;}
        case Receive_error:
             {
               if (p_rcb->error_state == NO_RQS) {
                 p_rcb->error_state = RCVD_ERROR;
                 p_rcb->ps_to_hs_record = NULL;
                 goto ex0;
               }
               if ((p_rcb->error_state == CONV_FAILURE_PROTOCOL_ERROR)||
                   (p_rcb->error_state == CONV_FAILURE_SON))
                     goto ex0;
               else
                     goto ex_1;
             }
        case ALLOC_FAIL_RETRY:
             if(p_rcb->error_state == NO_RQS)
                {
                    p_rcb->error_state = ALLOCATE_FAILURE_RETRY;
                    goto ex0;
                }
             else
                 goto ex_1;
        case ALLOC_FAIL_NO_RETRY:
             if(p_rcb->error_state == NO_RQS)
                {
                    p_rcb->error_state = ALLOCATE_FAILURE_NO_RETRY;
                    goto ex0;
                }
             else
                 goto ex_1;
        case SYNC_LEVEL_NOT_SUPPTD :
             if(p_rcb->error_state == NO_RQS)
                {
            p_rcb->error_state = SYNC_LEVEL_NOT_SUPPORTED;
                    goto ex0;
                }
             else
                    goto ex_1;
        case RESET:
                {
                    p_rcb->error_state = NO_RQS;
                    goto ex0 ;
                }
    }
 ex0: return(0);
 ex_1: return(-1);
}
