function r=hailpath(x)
%
% r=hailpath(x0) returns the sequance x(n)
% which is computed using the rule:
% x(1)=x0
% x(n+1)=    x odd:  3*x(n)+1
%	     x even: x/2
%
% "Ulam's Conjecture" says the sequance will always converge to 1.
%
% To compile: matcom ulam.m
%
% (c) Copyright Yaron Keren 1995-1996
%

j=0;
while x~=1
  j=j+1;
  r(j)=x;
  if rem(x,2)==0
    x=x/2;
  else
    x=3*x+1;
  end
end
