\ COPYRIGHT 1995 BY THOMAS ALMY.  ALL RIGHTS RESERVED
\ Permission is granted to registered users of ForthCMP to
\ sell or distrubute computer programs incorporating the compiled
\ contents of this file.
\ MS is a trademark of Microsoft Corporation.
\ This file is for standard MS-DOS operation, with or without a
\  separate stack segment.

\ This is a modified DOSGO which incorporates the exception wordset
\ and has handlers built in for divide by zero, control-C, and critical error
\ traps. It serves as an example of how the startup file can be modified
\ for specific applications, but you might want to replace the existing DOSGO
\ with this one if you want the exception handling.
\ Note that the program can be exited via BYE (or bye) or via normal return
\ from MAIN or you can exit via ABORT
\ (assuming you don't catch ABORT's  THROW).

10  

DECIMAL		\ Values used by THROW
-1  CONSTANT Abort
-28 CONSTANT Ctrl-C      ( User interrupt )
-10 CONSTANT 0Divide
HEX
23 CONSTANT cc-int  ( Control-C software interrupt number from DOS)
24 CONSTANT cr-int  ( Critical error interrupt number from DOS)
0  CONSTANT /0-int  ( Zero Divide interrupt )

0 0 IN/OUT NEED m1
0 0 IN/OUT NEED rst
NEED MAIN
ASM FWD,  ( skip the variables )
VARIABLE DP       ( start free ram = HERE, set by END command )
VARIABLE S0       ( top of stack )
VARIABLE R0       ( top of return stack )
VARIABLE BASE     ( radix )     0A BASE !  ( decimal )
VARIABLE fail-cr  ( should critical errors fail? )
VARIABLE crerr    ( last critical error )
2VARIABLE /0-save  ( we will want to save the vectors )
THEN,
SEPSSEG? [IF] AX CS <SEG pssize # AX ADD AX SS >SEG [THEN]
FIND PSIZE [IF] DROP ( PSIZE is constant size of program seg)
PSIZE 0 10. D+ 10 SM/REM NIP
DUP 10 * rssize - DUP # SP MOV  ( set param stack )
  CELL- # S0 [] MOV  ( set S0 )
DUP 10 * # BP MOV  BP R0 [] MOV  ( set return stack, R0 )
4A # AH MOV  SEPSSEG? [IF] pssize + [THEN] # BX MOV  21 INT   [THEN]
FIND PSIZE [IF] DROP [ELSE]
rssize NEGATE DUP # SP MOV  ( set param stack )
  CELL- # S0 [] MOV  ( set S0 )
0 # BP MOV  BP R0 [] MOV  ( set return stack, R0 ) [THEN]
CLD CALL' m1  ( call main program )
CODE bye 
CALL' rst  ( restore the interrupt handlers )
4C00 # AX MOV 21 INT END-CODE

INCLUDE INTS	\ Interrupt handlers

\ We have included exceptio.4th here so we could modify the
\ definition of THROW

VARIABLE exfp	\ Exception frame pointer

CODE CATCH 
  SI POP  AX POP  \ retAddr execAddr
  BP DEC BP DEC SI [BP] MOV
  BP DEC BP DEC SP [BP] MOV
  BP DEC BP DEC exfp [] BX MOV  BX [BP] MOV
  BP exfp [] MOV
  AX CALLI
  [BP] AX MOV  AX exfp [] MOV  
  AX AX XOR  AX PUSH
  4 +[BP] AX MOV  6 # BP ADD  
  AX JMPI
END-CODE

1 0 IN/OUT
CODE throw
  exfp [] BP MOV [BP] BX MOV BX exfp [] MOV
  2 +[BP] SP MOV  AX PUSH
  4 +[BP] AX MOV
  6 # BP ADD  AX JMPI
END-CODE

1 0 IN/OUT
: THROW ?DUP IF throw THEN ;
0 0 IN/OUT
: ABORT Abort THROW ;

L: cc-entry ( actual interrupt handler )
  DECIMAL Ctrl-C HEX # AX MOV
  CALL' throw  \ Never returns


L: /0-entry  
	0Divide # AX MOV
        CALL' throw

L: cr-entry  \ merge with throw because of special handling
   0 # CS: fail-cr [] CMP =0 ~ IF, DI CS: crerr [] MOV 3 # AL MOV IRET THEN,
   DECIMAL AX CS <SEG  AX DS >SEG 
   exfp [] BP MOV [BP] BX MOV  BX exfp [] MOV
SEPSSEG? [IF] pssize # AX ADD [THEN] AX SS >SEG
   2 +[BP] SP MOV  DI AX MOV  AH AH XOR  AX NEG  256 # AX SUB
   AX PUSH
   4 +[BP] AX MOV
   6 # BP ADD  AX JMPI END-CODE
HEX
0 0 IN/OUT
: m1 \ hidden MAIN
	/0-int get-handler /0-save 2!		\ get and save old handlers
	?CS: cc-entry cc-int set-handler	\ set handlers to us
	?CS: /0-entry /0-int set-handler
        ?CS: cr-entry cr-int set-handler
	['] MAIN CATCH CASE
             0 OF  bye ENDOF \ Normal finish
             Abort OF S" Abort" ENDOF
             Ctrl-C OF S" Control-C" ENDOF
             0Divide OF S" Divide by zero" ENDOF
             DUP -110 -100 WITHIN IF ." critical error " NEGATE 100 - THEN
             DECIMAL . S" uncaught" 0 ENDCASE
           TYPE ."  exception--Quiting Program" CR
;
0 0 IN/OUT
: rst \ restore handlers
	/0-save 2@ /0-int set-handler		\ restore handlers
	( We dont need to restore the control-C or critical error handlers )
;

0A = [IF] DECIMAL [THEN]
