\ STRING SUPPORT LIBRARY PART 1
\ Contents Copyright (C) 1986, 1993 by Thomas Almy

\ Permission is granted to registered users of ForthCMP to sell or distribute
\ computer programs incorporating the compiled contents of this file.

\ This file must be loaded BEFORE the application program.
\ Then load STRINGS2.4TH before FORTHLIB.

\ When separate code and data segments are used, beware that
\ string literals are in the code segment.  Use STR>DSEG
\ to move to string buffer ( in DSEG ).


.( Loading STRINGS ) CR
10 DECIMAL

FIND StringSize #IF DROP #ELSE

1024 CONSTANT StringSize  \ alter if desired.

\ For instance, to have a 512 byte buffer instead of the default 1024, start
\ the source file "xxx MSDOS  512 CONSTANT StringSize  INCLUDE STRINGS1".

#THEN

DSEG

FIND strbufr #IF DROP #ELSE

CREATE strbufr  StringSize ALLOT
\ you might also want to put strbufr at some arbitrary high constant
\ location so that the size of the COM/EXE file is not increased:
\   PSIZE StringSize - 1000 ( size of stacks ) - CONSTANT strbufr


\ While the example shows the string buffer at a fixed location, it can
\ be dynamically positioned at program startup if the EQUs STRBUF and
\ strend are set as well. In this case, strbufr should be declared to be an
\ EQU: "xxx MSDOS  0 EQU strbufr  INCLUDE STRINGS1". In MAIN, the following
\ code can be executed: "HERE DUP EQU strbufr  DUP EQU STRBUF  EQU strend
\ StringSize ALLOT"

#THEN

strbufr EQU STRBUF
strbufr EQU strend

1 0 IN/OUT NEED +STRBUF
1 1 IN/OUT NEED STR>DSEG
2 0 IN/OUT NEED STRCPY
2 1 IN/OUT NEED STRPCK
1 1 IN/OUT NEED ASCIIZ
1 1 IN/OUT NEED -ASCIIZ
2 2 IN/OUT NEED -PATH
1 1 IN/OUT NEED -EXT
2 1 IN/OUT NEED +EXT
0 1 IN/OUT NEED argc
2 1 IN/OUT NEED -ASCIIZL
1 1 IN/OUT NEED argv
1 1 IN/OUT NEED getenv

16 = #IF HEX #THEN
