/***********************************************************************

                      CSDB Library, Free Evaluation Version 2.0.3 
                                      Release: November 11th 1996 

       BASE class for many database classes.


                                           Copyright(c) 1994-1996 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSBASE_H
#define __CSBASE_H

#include "cstools.h"
#include "cswarnof.h"
#include "csfile.h"


#define CS_CLID_VRAM		1
#define CS_CLID_BTREE		2
#define CS_CLID_VBASE		3
#define CS_CLID_VBAXE		4
#define CS_CLID_OLAY		5
#define CS_CLID_DLAY		6
#define CS_CLID_OLAYd		CS_CLID_DLAY
#define CS_CLID_TBASE		7
#define CS_CLID_RBASE		8
#define CS_CLID_DAVL		9
#define CS_CLID_RAVL	       10
#define CS_CLID_PAGE	       11
#define CS_CLID_BTREEb	       12
#define CS_CLID_BTREEi	       13
#define CS_CLID_BTREEc	       14
#define CS_CLID_BTREEl	       15
#define CS_CLID_BTREEf	       16
#define CS_CLID_BTREEd	       17
#define CS_CLID_BTREEa	       18
#define CS_CLID_VBASEi	       19
#define CS_CLID_VBASEd	       20
#define CS_CLID_IBASE	       21
#define CS_CLID_BTREEs	       22


int cs_db_type(csCHAR *name,U32 &cs_lib,U32 &fi_ID, S16 &cl_ID);
U32 cs_fi_type(csCHAR *name);
U16 cs_cl_type(csCHAR *name);


csCHAR *lock_file_name(csCHAR *DBName,csCHAR *LockName);
int	lock_file_exist(csCHAR *DBName);
int	remove_lock_file(csCHAR *DBName);

class VBAXE;



////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////



class BASE
{

friend class VBAXE;

protected:

   void *head;
   U16	 is_open;
   U32	 numpage;
   U16	 lenpage;
   U16	 page_foot;
   csSTR db_name;
   FILE_NAME LockFile;
   FILE *fp;
   int	 ReadOnly;
   U16	 ErrorNr;
   int	 use_locking;

   void set_page_size(U16 t);
   void init_vars(void);
   void init_defaults(void);



protected:

   void close2(void);



   U16	debug_error(U16 errnr);
   U16	debug_error(U16 errnr,csCHAR *name);

   U16	visible_error(U16 errnr);
   U16	visible_error(U16 errnr,csCHAR *name);



public:

///////////////////////// Compatibility ////////////////////////////////////

   void name(csCHAR *s) 	  { db_name=s; }
   int	already_open(void)	  { return is_open; }
//   void save(int updated);
// int	set_open(int FT)	  { return is_open=(U16)FT; }


// void zap(void);

//////////////// Made public to support the program generator //////////////

   S32	sj_updated(void);
   S32	sj_created(void);



////////////////////////////////////////////////////////////////////////////////
////////////////////////			    ////////////////////////////
////////////////////////     P U B L I C	    ////////////////////////////
////////////////////////			    ////////////////////////////
////////////////////////////////////////////////////////////////////////////////




public:

   BASE(void);

   virtual
  ~BASE(void);


///////////////////////// Error & Messages ///////////////////////////

   csCHAR *e_name(void) 	  { return (csCHAR *)db_name; }
   void    e_name(csCHAR *s)	  { db_name=s; }

   void error_nr(U16 nr)	  { ErrorNr=nr; }
   U16	error_nr(void  )	  { U16 RC=ErrorNr; ErrorNr=0; return RC; }


   U16	display_error(void);

///////////////////////// Read-Only Mode ////////////////////////////////

   int	read_only(void)     { return read_only(TRUE); }
   int	read_only(int ToF);

   int	is_read_only(void)  { return ReadOnly; }


///////////////////////// Open & Close //////////////////////////////////

   int	open(csCHAR *name);
   void close(void);

   int	save(void) {return TRUE;}


   int	IsOpen(void)	    { return is_open; }
   void IsOpen(int ToF)     { is_open=ToF; }



///////////////////////// Lock files ////////////////////////////////////

   void use_lock_file(int ToF)	{ use_locking=ToF; }
   int	use_lock_file(void   )	{ return use_locking; }

   int	lock_file_exist(csCHAR *DBNAME);

   int	if_cr_lofi(csCHAR *DBName,U16 Exist,U16 False);
   int	if_re_lofi(void);

   int	create_lock_file(csCHAR *DBName,U16 Exist,U16 False);

   int	remove_lock_file(csCHAR *DBName);
   int	remove_lock_file(void);



/////////////////////////Header block ///////////////////////////////////

   virtual int read_header(void);
   virtual int write_header(void);

   void    TimeStamp(void);


///////////////////////// Create /////////////////////////////////////

   void define(void);

   void page_size(U16 t)	  { set_page_size(t); }
   U16	page_size(void) 	  { return lenpage;   }
   U16	foot_size(void) 	  { return page_foot; }
   void foot_size(int size)	  { page_foot=(U16)size;   }

//////////////////////// Number of Pages /////////////////////////////////////

   long num_page(void)		  { return numpage; }
   void set_num_page(long n)	  { numpage=n; }


////////////////////////// Miscellaneous ///////////////////////////////////////
   int	fseek(U32 l)		  { return ::fseek(fp,l,SEEK_SET); }
   long ftell(void )		  { return ::ftell(fp); }
   U16	page_free(void) 	  { return (U16)(page_size()-foot_size()); }
   void empty(void);

   virtual int class_ID(void)=0;



};


#endif
