/***********************************************************************

                      CSDB Library, Free Evaluation Version 2.0.3 
                                      Release: November 11th 1996 

       Header file of the VRAM class.
       This works as a permanent heap, placed on disk.

                                           Copyright(c) 1994-1996 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSVRAM_H
#define __CSVRAM_H

#include "cstypes.h"
#include "cspage.h"


#ifdef __BORLANDC__
#pragma warn -sig
#endif

#ifdef _MSC_VER
#pragma warning(disable : 4051 4135)
#endif


typedef U32 VPOI;


class VRAM: public PAGE
{

 private:

   typedef U32 PANR;
   typedef U16 OFNR;

   typedef struct
   {
     U16 alloc;
   } dhd;                     //Data HeaDer

   typedef struct
   {
     VPOI  pos;
   } edc;                     //Empty Data Chain


protected:

   csCHAR *add_last;
   edc  *eda;
   U16   vpo_offmask;
   U8    vpo_shftrig;
   U8    esr;              // Shift Right
   U16   enr;              // NumbeR (highest array index)
   int   epc;              // Eda Page Changed.
   U32   numall;           // Number of Allocations currently done.
   PANR  pag_last;
   int   relshrink;
   U16   maxlen;


   void define_eca(void);
   void open_eca(void);
   void save_eca(void);
   void close_eca(void);

   void  reset_eca(void);
   U16   *amount(void *ptr)  { return (((U16 *)ptr)-1); }
   U16   *amount(VPOI  ptr)  { return amount(R(ptr)); }

   void free(void *p, VPOI p2 );
   U32  P(VPOI p)            { return p>>vpo_shftrig; }
   U16  O(VPOI p)            { return p&vpo_offmask; }

   void init_vars(void);
   void init_defaults(void);

   virtual int check_id(U32 id);
   virtual void set_id(void);
   int  sort_eca(void);
   void head2vars(void);
   void vars2head(void);


////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////

 public:

   VRAM(void);
   virtual
  ~VRAM(void);

//////////////////////// Compatibility functions //////////////////////
   VPOI vmalloc(U16  size)   { return malloc(size); }
   void vfree(VPOI p)        { free(p); }


//////////////////////// Definition //////////////////////////////////////////
   int define(csCHAR *name,U16 struclen);


//////////////////////// Open & Close ////////////////////////////////////////
   int open(csCHAR *name,S16 kb_buf=100);
   int close(void);
   int save(void);

//////////////////////// Malloc & Free ////////////////////////////////
   VPOI malloc(U16  size);
   void free(VPOI p)         { numall--; free(W(p),p); }

   U16  alloc(VPOI p)        { return *amount(p)-sizeof(dhd); }
   U16  alloc(void *p)       { return *amount(p)-sizeof(dhd); }

//////////////////////// Read & Write /////////////////////////////////
   csCHAR *W(VPOI p);
   csCHAR *R(VPOI p);

//////////////////////// Report Writing //////////////////////////////////////
   U16  report(csCHAR *name,S16 sub=1);
   void report(FILE *fipo,S16 sub);

//////////////////////// Data in Header Page /////////////////////////////////
/* Inherited
   int  data_2_header(void * ptr,U16 length);
   int  header_2_data(void * ptr,U16 length);
   U16  max_data_in_header(void);
*/


/////////////////////////// DB Header ///////////////////////////////////
     virtual int read_header(void);
     virtual int write_header(void);


////////////////////////// Miscellaneous ///////////////////////////////////////
   virtual int class_ID(void)  { return CS_CLID_VRAM; }

   int  defrag(void)   { return sort_eca(); }
   void info(void);
   U32  number(void)   { return numall; }
   int  zap(void);
   int  empty(void);
   void root(VPOI p);
   VPOI root(void);
   U16  max_len(void)  { return maxlen;                  }
   int  relocate_when_shrunk(void) { return relshrink;   }
   void relocate_when_shrunk(int ToF);

};


#ifdef __BORLANDC__
#pragma warn .sig
#endif


#ifdef _MSC_VER
#pragma warning(default : 4051 4135)
#endif


#endif
