/*******************************************************

    The CalcPlus Class Library Version 1.0,
    Author: Vladimir Schipunov, Copyright (C) 1996

    This library is free software. Permission to use,
    copy, modify and redistribute the CalcPlus library
    for any purpose is hereby granted without fee,
    provided that the above copyright notice appear
    in all copies.

*******************************************************/

#ifndef __YYCALC_H
#define __YYCALC_H
#include "calclex.h"

//
//  Header file for the interpreter.
//

class CalcPlus : public YLex, public PrintObj
{
private:

    //  Various stacks which keep current block
    //  for corresponding syntax construction.

    LexStack Blocks;    //  blocks
    LexStack Calls;     //  function calls
    LexStack Cond1;     //  'if'    part of the condition
    LexStack Cond2;     //  'else'  part of the condition
    LexStack Sets;      //  sets
    LexStack Idx;       //  array indexes

    //  Variables below are intended for keeping context also.
    //  Actually they are stacks of depth 1.

    Var*        VarTmp;
    XFunction*  FuncTmp;
    XEcho*      EchoTmp;
    CArray*     StructTmp;

    //  What is current declaration: var, const or struct.

    int DeclType;
    enum { declVar, declConst, declStruct };

protected:

    Var* AddVar( const char* v );   //  Add var named v to the current block

    char *pyylval();                //  needed by yylex

    yyparse();
    virtual Compile();
    virtual Link();
    virtual Exec();
    virtual Err();

public:

    CalcPlus( const char* = 0 );
    ~CalcPlus();

    XBlock *Global;     //  Module context

    int HideVars;       //  Non-zero when local args for
                        //  function are being declared

    Token __name();     //  Checks whether identifier is
                        //  already defined symbol or not
    virtual Run();
    void print( ostream& ) const;
    virtual const char* StartSym() const { return "MAIN"; }

    virtual Expression* UserSym         //  processes symbols which
    ( Expression*, Expression* e = 0 ); //  begin with char '@'

    CType* Call         //  For calling interpreter's functions from C++
    (
        const char* func,   // name of function
        int argc,           // number of arguments
        ...                 // pointers to arguments (CType*)
    );
};

#endif

