/*
 *  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)
 *
 * File         : key.h
 *
 * Description  : key code definitions.
 *
 */


#ifndef __Key_H
#define __Key_H


#define RETURN			0x0d
#define ENTER                   RETURN
#define SPACE			0x20
#define ESC			0x1b
#define BKSP			0x08
#define BACKSPACE		0x08

#define UP              	328
#define DOWN                    336
#define LEFT                    331
#define RIGHT                   333
#define PGUP		        329
#define PGDN	                337
#define HOME                    327
#define END  	       	        335
#define INSERT 	       	        338
#define INS                     INSERT 	       	
#define DELETE 	       	        339
#define DEL                     DELETE

enum { F1 = 315, F2, F3, F4, F5, F6, F7, F8, F9, F10, F11 = 389, F12 };

#define CTRL_UP              	397
#define CTRL_DOWN               401
#define CTRL_LEFT               371
#define CTRL_RIGHT              372
#define CTRL_PGUP		388
#define CTRL_PGDN	        374
#define CTRL_HOME               375
#define CTRL_END  	       	373
#define CTRL_INSERT             402
#define CTRL_INS                CTRL_INSERT
#define CTRL_DELETE             403
#define CTRL_DEL                CTRL_DELETE

enum { CTRL_F1 = 350, CTRL_F2, CTRL_F3, CTRL_F4, CTRL_F5, 
       CTRL_F6, CTRL_F7, CTRL_F8, CTRL_F9, CTRL_F10,
       CTRL_F11 = 393, CTRL_F12
     };

#define CTRL_A                  1
#define CTRL_B                  2
#define CTRL_C                  3
#define CTRL_D                  4
#define CTRL_E                  5
#define CTRL_F                  6
#define CTRL_G                  7
#define CTRL_H                  8
#define CTRL_I                  9
#define CTRL_J                  10
#define CTRL_K                  11
#define CTRL_L                  12
#define CTRL_M                  13
#define CTRL_N                  14
#define CTRL_O                  15
#define CTRL_P                  16
#define CTRL_Q                  17
#define CTRL_R                  18
#define CTRL_S                  19
#define CTRL_T                  20
#define CTRL_U                  21
#define CTRL_V                  22
#define CTRL_W                  23
#define CTRL_X                  24
#define CTRL_Y                  25
#define CTRL_Z                  26

#define ALT_UP              	408
#define ALT_DOWN                416
#define ALT_LEFT                411
#define ALT_RIGHT               413
#define ALT_PGUP	        409
#define ALT_PGDN	        417
#define ALT_HOME                407
#define ALT_END                 415
#define ALT_INSERT              418
#define ALT_INS                 ALT_INSERT
#define ALT_DELETE              419
#define ALT_DEL                 ALT_DELETE

enum { ALT_F1 = 360, ALT_F2, ALT_F3, ALT_F4, ALT_F5, 
       ALT_F6, ALT_F7, ALT_F8, ALT_F9, ALT_F10,
       ALT_F11 = 395, ALT_F12
     };

#define ALT_A                   286
#define ALT_B                   304
#define ALT_C                   302
#define ALT_D                   288
#define ALT_E                   274
#define ALT_F                   289
#define ALT_G                   290
#define ALT_H                   291
#define ALT_I                   279
#define ALT_J                   292
#define ALT_K                   293
#define ALT_L                   294
#define ALT_M                   306
#define ALT_N                   305
#define ALT_O                   280
#define ALT_P                   281
#define ALT_Q                   272
#define ALT_R                   275
#define ALT_S                   287
#define ALT_T                   276
#define ALT_U                   278
#define ALT_V                   303
#define ALT_W                   273
#define ALT_X                   301
#define ALT_Y                   277
#define ALT_Z                   300

#define SHIFT_UP              	328
#define SHIFT_DOWN              336
#define SHIFT_LEFT              331
#define SHIFT_RIGHT             333
#define SHIFT_PGUP	        329
#define SHIFT_PGDN	        337
#define SHIFT_HOME              327
#define SHIFT_END               335
#define SHIFT_INSERT            338
#define SHIFT_INS               SHIFT_INSERT 	       	
#define SHIFT_DELETE 	       	339
#define SHIFT_DEL               SHIFT_DELETE 	       	

enum { SHIFT_F1 = 340, SHIFT_F2, SHIFT_F3, SHIFT_F4, SHIFT_F5, 
       SHIFT_F6, SHIFT_F7, SHIFT_F8, SHIFT_F9, SHIFT_F10,
       SHIFT_F11 = 391, SHIFT_F12
     };

#endif
