/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <stdlib.h>
#include <string.h>
#include <dos.h>



/***
 *
 *  Function   :    load_cfg
 *
 *  Topics     :    Load configuration from a file.
 *
 *  Decisions  :    The file has the same name as the parameter 'name'
 *                  but with extension .CFG
 *                  If configuration file is not found, result is unchanged.
 *
 *  Parameters :    in   char * name        filename
 *                  out  void * config      ptr to variable containing configuration
 *                  in   size_t size        size of data to read
 *
 *  Return     :    number of bytes read
 *                  -1 if file was not found
 *
 ***/


int load_cfg( const char *name, void *config, size_t bsize )

{ char cfgname[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR], file[_MAX_FNAME], ext[_MAX_EXT];
  FILE *cfgFile;
  int r;

  _splitpath( name, drive, dir, file, ext );
  _makepath( cfgname, drive, dir, file, "CFG" );

  cfgFile = fopen( cfgname, "rb" );
  if ( ! cfgFile ) return -1;

  r = fread(config, 1, bsize, cfgFile);
  fclose( cfgFile );
  return r;
}


/***
 *
 *  Function   :    save_cfg
 *
 *  Topics     :    Save a configuration into a file.
 *
 *  Decisions  :    The file has the same name as the parameter 'name'
 *                  but with extension .CFG
 *
 *  Parameters :    in   char * name        filename
 *                  in   void * config      ptr to variable containing configuration
 *                  in   size_t size        size of data to write
 *
 *  Return     :    number of bytes written
 *                  -1 if file was not found
 *
 ***/


int save_cfg( const char *name, const void *config, size_t bsize )

{ char cfgname[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR], file[_MAX_FNAME], ext[_MAX_EXT];
  FILE *cfgFile;
  int r;

  _splitpath( name, drive, dir, file, ext );
  _makepath( cfgname, drive, dir, file, "CFG" );

  cfgFile = fopen( cfgname, "wb" );
  if ( ! cfgFile ) return -1;

  r = fwrite(config, 1, bsize, cfgFile);
  fclose( cfgFile );
  return r;
}


