    :: by Larry Nelson      10-8-1995

   ::                    TB {TOOLBOX} .BAT
   :: TB (Toolbox).bat is a collection of Batch file utilities
   :: all written in "vanilla" DOS 6x Command.com Batch language.
   :: Having seen requests for many of these simple functions I
   :: thought that there may be some interest in a util that
   :: provided access for your own .bats. Toolbox also has demo
   :: .bats with each of the subutils giving some idea of how to
   :: use that tool. TB.bat can be used as a util or as a reference
   :: for some useful  "Vanilla" Batch tools.
   :: If TB.bat is kept in Path it can be accessed by your other
   :: Batch files with a simple "call tb function parameter".
   :: As an example, should one of your .bats need the current
   :: time in a DOS environment variable the line, CALL TB DATETIME T
   :: will create an envar holding the current time.
   :: The advantage to TB.bat is shorter code in your Batch files,
   :: the disadvantage is a loss of portability unless TB.bat goes
   :: along with any .bat file you wish to give to someone else.
   :: Some time loss is a factor but that can be minimized if you
   :: are running a caching program or run your .bats and TB.bat
   :: from a RAMdrive.
   :: Each tool will have a short description of it's function and
   :: use. You might want a copy of TB.bat without notation, if
   :: so please use the onboard tool, "NONOTES", by typing TB
   :: NONOTES, and a file named TBNOTES.txt will be created
   :: along with TBFREE.bat. This will also help to speed up TB.bat.

   ::                         Contents

   :: 0byte...........................creates a 0byte for flagging.
   :: Beep............................................sound effect.
   :: Cmdir.............................sets dircmd=oldir and back.
   :: Datetime.......time and/or date, day of the week in an envar.
   :: Dirxst........searches for given dir, if found, sets xst=yes.
   :: Isansi........................tests if Ansi.sys is installed.
   :: Nonotes......................... strips comments from TB.BAT.
   :: Loopz................................ increments envar %num%.
   :: Vardir....................... puts current Dir into an envar.
   :: Ver..........................sets version of DOS to an envar.
   :: Wait..............................................timed wait.

   @echo off
   cls
         if not %1! == ! goto %1
      goto hlp
   :ed
         edit %0.bat
      goto L8r
   :0byte
      :: Usage = tb 0byte filename.txt
      ::
      :: Zero byte files are sometimes used as flags to branch
      :: a Batch file as in Zbyte.bat bellow.
      ::
      :: Zbyte.bat
      ::    @echo off
      ::    cls
      ::          tb 0byte tst.txt
      ::          if exist tst.txt goto L8r
      ::       echo Did it work?
      ::    :L8r

            rem>%2
         goto L8r

   :beep
      :: Usage = tb beep
      ::
      :: Beep uses ^G five times waits one second then five more.
      :: This can be used to signal the end of a Batch file as it
      :: does in Fmt.bat.
      ::
      :: FMT.BAT
      ::
      ::    @echo off
      ::    cls
      ::       ren/? |format a:/q
      ::       call tb beep
      ::    :L8r

         echo      
            choice /n/c /t: ,1
         echo        
         goto L8r
 
 :cmdir
      :: Usage = tb cmdir (old)
      :: CMDIR puts your old dircmd envar into another envar
      :: named oldir by typing  tb cmdir then sets dircmd=.
      :: To reset dircmd to the original state type  tb cmdir old.
      :: A possible use for Cmdir is when Dir is used in one of
      :: your .bats and you have used the /p switch in Dircmd.
      :: Tst.bat demonstrates the use of Cmdir allowing several
      :: Dir's without hanging on the /p switch. Tb vardir will
      :: be discussed later.
      ::         @echo off
      ::         cls
      ::                  call tb cmdir
      ::                  call tb vardir
      ::                  set
      ::                  pause
      ::                  dir
      ::                  pause
      ::                  cd\zip
      ::                  dir
      ::                  pause
      ::                  cd %dir%
      ::                  dir
      ::                  pause
      ::                  call tb cmdir old
      ::                  set
      ::                  pause
      ::                  set dir=
      ::                  set
      ::         :L8r
      
            set |find "DIRCMD" >nul
            if errorlevel 1 goto old
            if not %2! == ! goto %2
            set oldir=%dircmd%
            set dircmd=
         goto L8r
   :old
            set |find "OLDIR" >nul
            if errorlevel 1 goto L8r
            set dircmd=%oldir%
            set oldir=
         goto L8r
      
 :datetime
      :: DATETIME
      :: Usage = tb datetime (d) date (t) time
      ::          (dt) date/time (dw) day of week.
      :: Datetime pulls system date and/or time, or day of the
      :: week and puts it into an envar with current date/time,
      :: date, or time. Find.exe must be in path. A sample usage
      :: of Datetime is Bootlog.bat below. With { call bootlog }
      :: in your Autoexec.bat a file named Bootlog.dat will
      :: receive a record of every time your computer is booted up.
      ::
      ::BOOTLOG.BAT
      :: 
      ::         @echo off
      ::         cls
      ::               call tb datetime dt
      ::            echo %datetime% >>bootlog.dat
      ::               set datetime=
      ::         :L8r
      
         if %2! == ! goto hlp
      goto %2
 :dt
      echo set datetime=%%3.........%%4 >!.bat
         dir !.bat |find "!" >magic.bat
         call magic
      goto cleanup
 :d
      echo set datetime=%%3.........%%4 >!.bat
         dir !.bat |find "!" >magic.bat
         call magic
      goto cleanup
 :t
      echo set datetime=%%3.........%%4 >!.bat
         dir !.bat |find "!" >magic.bat
         call magic
      :cleanup
         For %%q in (magic !) do del %%q.bat
      goto cleanup
 :dw
         ver |date |find/i "current" >magic.bat
      echo set day=%%3 >current.bat
         call magic
         for %%q in (magic current) do del %%q.bat
      goto cleanup

 :dirxst
      :: USAGE for Dirxst = tb dirxst (path\whatever)
      :: Dirxst searches out a given directory and if found sets
      :: XST to yes. If it hasn't, there will come a time when your
      :: Batch file needs to know if a given directory exists.
      :: Tmp.bat demos how your .bat can call on TB.bat to make that
      :: determination. Call Tmp.bat with the parameter (path\whatever).
      ::
      :: TMP.BAT
      ::
      :: @echo off
      :: cls
      ::       call tb dirxst \tmp
      ::       if not %xst% == yes md %1
      ::       set xst=
      :: :L8r

         set xst=
         if exist %3\nul set xst=yes
      goto L8r
      
 :isansi
      :: ISANSI
      :: Considering the paranoia surrounding "Ansi-bombs" not
      :: everyone has Ansi.sys installed. If your .bat has to do
      :: with color, locating the curser at a certain point on
      :: the screen, or redefining the keyboard, Isansi can help
      :: you determine if Ansi is installed before you cover the
      :: screen with a bunch of gibberish that was supposed to
      :: be commands to that defunct program. Tstansi.bat is
      :: a demo to show how to set for and call Isansi.
      ::
      ::TSTANSI.BAT
      ::
      :: @echo off
      :: cls
      ::       call tb isansi
      ::       if not %isansi% == yes goto hlp
      ::    ( Do your thing here. )
      :: :hlp
      ::    echo Ansi.sys is not installed. To install add to Config.sys
      ::    echo the line.....
      ::    echo    Device=c:\dos\ansi.sys
      ::    echo Substitute your path to Ansi.sys if needed.
      ::       set isansi=
      :: :L8r

         mem/m:ansi|find "Device=ANSI">nul
         if not errorlevel 1 set isansi=yes
  :isansi
      :: ISANSI
      :: Considering the paranoia surrounding "Ansi-bombs" not
      :: everyone has Ansi.sys installed. If your .bat has to do
      :: with color, locating the curser at a certain point on
      :: the screen, or redefining the keyboard, Isansi can help
      :: you determine if Ansi is installed before you cover the
      :: screen with a bunch of gibberish that was supposed to
      :: be commands to that defunct program. Tstansi.bat is
      :: a demo to show how to set for and call Isansi.
      ::
      ::TSTANSI.BAT
      ::
      :: @echo off
      :: cls
      ::       call tb isansi
      ::       if not %isansi% == yes goto hlp
      ::    ( Do your thing here. )
      :: :hlp
      ::    echo Ansi.sys is not installed. To install add to Config.sys
      ::    echo the line.....
      ::    echo    Device=c:\dos\ansi.sys
      ::    echo Substitute your path to Ansi.sys if needed.
      ::       set isansi=
      :: :L8r

         mem/m:ansi|find "Device=ANSI">nul
         if not errorlevel 1 set isansi=yes
      goto L8r

 :nonotes
      ::
      :: Nonotes first makes a copy of TB.bat less the added
      :: notes, then then makes a copy of the notes less the
      :: TB.bat code. Look for two new files in the current
      :: directory named TBNOTES.TXT and TBFREE.BAT. Move the
      :: current copy of TB.BAT to a safe place them REN
      :: TBFREE.BAT TB.BAT. TB.BAT should run a bit faster.
      ::             Usage = tb nonotes

         type tb.bat |find/v "::" |find/v ":nonotes" >TBfree.bat
         type tb.bat |find "::" >TBnotes.txt
      goto L8r

 :loopz
      ::
      :: Loopz is an incrimenting engine that adds 1 to the
      :: envar NUM. %num% can be tested with the line....
      ::          IF %num% == 5 GOTO WHEREVER
      :: and your Batch file will cycle 5 times. Tst.bat is an
      :: example of how Loopz can be used.......
      ::
      ::TST.BAT
      ::         @echo off
      ::         cls
      ::                set num=0
      ::         :lp
      ::                call tb loopz
      ::    { The above line calls TB.BAT with LOOPZ.} 
      ::            echo %num%
      ::                choice /n/c /t: ,1

      ::    { Here is where you do your thing.}

      ::                if not %num% == 3 goto lp
      ::    { The above line sets the number of loops.}

      ::                set num=
      ::             echo BYE!
      ::          :L8r
      :: Loopz works with Basic, Basica, or GWbasic. One
      :: of those three must be in path.

      echo ? "!" %num%+1 |basic |find /v "?" >\%temp%\magic.bat
      echo set num=%%1 >\%temp%\!.bat
         call magic
         for %%q in (magic !) do del \%temp\%%q.bat
      goto L8r
 :VARDIR
      :: Vardir sets dir=(current dir)
      :: Tst.bat demonstrates the use of  tb vardir  allowing DOS
      :: to return your Batch file to the directory of origination.
      :: Tb cmdir has been discussed in the section marked :cmdir.
      :: 
      ::         @echo off
      ::         cls
      ::                  call tb cmdir
      ::                  call tb vardir
      ::                  set
      ::                  pause
      ::                  dir
      ::                  pause
      ::                  cd\zip
      ::                  dir
      ::                  pause
      ::                  cd %dir%
      ::                  dir
      ::                  pause
      ::                  call tb cmdir old
      ::                  set
      ::                  pause
      ::                  set dir=
      ::         :L8r

         dir |find "Directory" >magic.bat
      echo set dir=%%2 >director.bat
         call magic
         for %%q in (magic director) do del %%q.bat
      goto L8r

 :ver
      :: Certain Batch functions are DOS level dependent. Ver will
      :: load the envar, ver with the DOS version number. Vertst.bat
      :: demonstrates the setup and calling of tb ver.
      ::
      :: VERTST.bat
      ::
      :: @echo off
      :: cls
            call tb ver
      ::    for %%q in (6.0 6.10 6.20 6.22) do if %ver% == %%q set ver=yes
      ::    if not %ver% == yes goto hlp
      ::  echo (Do your thing here.)
      ::  goto L8r
      :: :hlp
      ::  echo This Batch file needs DOS ver 6.0 or better.
      ::    set ver=
      :: :L8r

         echo @prompt ! $v>tmp.bat
            command/c tmp>magic.bat
         echo set ver=%%3>!.bat
            call magic
            for %%q in (! magic tmp) do del %%q.bat
         goto L8r
 :wait
      :: Wait uses the Choice command to stop a .bat for 1 to 99
      :: seconds. The spaces between /c  /t and /t:  ,%2 are not
      :: spaces. they are "alt/255"s created by holding down the ALT
      :: key and typing on the number pad, 255. The following sample
      :: .bat demos Wait. Usage for Wait is TB WAIT (n=1-99). Usage for
      :: Timer.bat is timer (n=1-99). A couple of seconds are lost
      :: in translation. You might have to adjust your .bat accordingly.
      ::
      ::    @echo off
      ::    cls
      ::       echo The wait state is now set for %1 seconds.
      ::          call tb wait %1
      ::       echo %1 seconds have passed.
      ::    :L8r

            choice /n/c /t: ,%2
         goto L8r


 :hlp
   echo USAGE = tb function parameter
   echo.
   echo example........
   echo           tb datetime dw
   echo.
   echo Puts the day of the week into an envar.
   echo.
   echo See Function list below for available Parameters.
   echo.
   echo 0byte.....filename.any
   echo beep
   echo cmdir.......(old) original Dircmd
   echo datetime....(dt) date/time, (d) date, (t) time, (dw) day of week.
   echo dirxst......(path\whatever)
   echo isansi
   echo nonotes
   echo loopz
   echo vardir
   echo ver
   echo wait........(n=1-99)
 :L8r
