;	SCAN.CMD:	MicroEMACS macro for scanning
;			SPELL.LST from MicroSPELL 2.0
;			(C)opyright 1987,1992 by Daniel M Lawrence

;*****	Load up the needed procedures *****

store-procedure	getnext
;	Go to the next entry in the spell list

*next
	set %line &add #%slist 1
	set %col #%slist

	; user file name?
	!if &equ %line -2
		set %userlist %col
		!goto next
	!endif

	; if we are all done...
	!if &equ %line -1
		set %done TRUE
		!return
	!endif

	; if we are starting a new file.....
	!if &equ %line 0
		set %cfile %col
		write-message &cat &cat "[Reading " %cfile "]"
		find-file %cfile
		set %cbuffer $cbufname
		set %cfnum &add %cfnum 1
		1 next-window
		2 goto-line
		set $curcol 20
		kill-to-end-of-line
		insert-string &cat " " %cfile
		3 next-window
		!goto next
	!endif

	;reset column offset if needed
	!if &not &equ %lastline %line
		set %offset 0
	!endif
	set %lastline %line

	;go to it!!!
	set $curline %line
	&add %col %offset forward-character
	set %cwnum &add %cwnum 1
!endm

store-procedure get-suggestions

	2 next-window
	shell-command &cat &cat "bic -t " %word " > suggest.tmp"
	set $gflags &bor $gflags 2
	beginning-of-file
	set-mark
	end-of-file
	kill-region
	insert-string "Suggested Replacements:~n"
	insert-file suggest.tmp
	beginning-of-file
	next-line
	!if &seq $line "EXACT MATCH"
		set %exact TRUE
		!return
	!endif
	set %exact FALSE
	19 forward-character
	!if &equ $curchar 32
;		no replacements!
		beginning-of-line
		overwrite-string "    None Found"
		set %currep 0
	!else
;		mark first replacement as current default
		forward-character
		set %currep 1
		overwrite-string "<="
	!endif
	3 next-window
!endm

store-procedure update-responses
	2 next-window
	set $curline &add &mod &sub %currep 1 4 2
	set $curcol &sub &times &div &add %currep 3 4 21 1
	overwrite-string "  "
	set $curline &add &mod &sub %newrep 1 4 2
	set $curcol &sub &times &div &add %newrep 3 4 21 2
	!if &equ $curchar 32
		set %resempty TRUE
	!else
		set %resempty FALSE
	!endif
	forward-character
	overwrite-string "<="
	set %currep %newrep
	3 next-window
!endm

store-procedure doopt
;Macro for asking and resolving options

*begopt
	;grab the word
	0 delete-next-word
	yank
	set %word $kill
!force	previous-word

	; save the casing info about this word
	set %firstchar &left $kill 1
	!if &seq %firstchar &upper %firstchar
		set %upword TRUE
	!else
		set %upword FALSE
	!endif

	;dump gratuitous 's and trailing ' after an s
	!if &gre &len %word 1

		;trailing 's?
		!if &seq &mid %word &sub &len %word 1 2 "'s"
			set %word &mid %word 1 &sub &len %word 2
		!endif

		;trailing s'
		!if &seq &mid %word &sub &len %word 1 2 "s'"
			set %word &mid %word 1 &sub &len %word 1
		!endif

	!endif

	;next check to see if this should be ignored....
	select-buffer "[ignore]
	beginning-of-file
!force	search-forward &cat &cat "~n" %word "~n"
	set %sstatus $status
	select-buffer %cbuffer
	!if &seq %sstatus TRUE
		!return
	!endif

	;see if this word has been replaced in the past
	select-buffer "[source]
	beginning-of-file
!force	search-forward &cat &cat "~n" %word "~n"
	set %sstatus $status

	!if &seq %sstatus TRUE
		set %repline &sub $curline 2
		select-buffer "[replace]"
		set $curline %repline
		set %defrep #"[replace]"
		select-buffer %cbuffer
		set %defflag "*"
		;check to see if this is a global replacement
		!if &equ &asc %defrep 19
			set %defrep &mid %defrep 2 255
			!goto globalrep
		!endif
	!else
		select-buffer %cbuffer
		set %defrep ""
		set %defflag ""
	!endif

*askopt
	run upstat	;update the dialog window
	get-suggestions
	!if &seq %exact TRUE
		3 next-window
		!return
	!endif
	update-word

	set $curline 6
	15 delete-next-character
	insert-string "       Option: "
	beginning-of-file
	3 next-window

*iopt
	update-screen
	set %resp &gtcmd

	!if &seq &left %resp 2 "FN"
		!if &equ %currep 0
			!goto iopt
		!endif
		set %newrep "none"
		set %ckey &mid %resp 3 1
*resagain
		!if &seq %ckey "P"
			set %newrep &sub %currep 1
			!if &equ %newrep 0
				set %newrep 12
			!endif
		!endif
		!if &seq %ckey "N"
			set %newrep &add %currep 1
			!if &equ %newrep 13
				set %newrep 1
			!endif
		!endif
		!if &seq %ckey "B"
			!if &equ %currep 1
				set %newrep 12
			!else
				!if &less %currep 5
					set %newrep &add %currep 7
				!else
					set %newrep &sub %currep 4
				!endif
			!endif
		!endif
		!if &seq %ckey "F"
			!if &equ %currep 12
				set %newrep 1
			!else
				!if &gre %currep 8
					set %newrep &sub %currep 7
				!else
					set %newrep &add %currep 4
				!endif
			!endif
		!endif
		!if &not &seq %newrep "none"
			update-responses
			!if &seq %resempty TRUE
				!goto resagain
			!endif
		!endif
		!goto iopt
	!endif

	!if &seq %resp "MSa"
		set %junk &gtcmd	;dump the upclick
		mouse-move-down
		!if &seq $cbufname "Dialog Window"
			forward-character
			!force search-reverse "("
			!if &seq $status FALSE
				3 next-window
				!goto iopt
			!endif
			forward-character
			set %resp &chr $curchar
			3 next-window
		!else
			!if &seq $cbufname "[suggestions]"
				!if &not &equ $curline 1
					previous-word
					set-mark
					end-of-word
					copy-region
					set %repstring $kill
					3 next-window
					set-mark
					end-of-word
					kill-region
					insert-string %repstring
					update-screen
					set %offset &add &sub %offset &len %word &len %repstring
					!return
				!endif
			!else
				!goto iopt
			!endif
		!endif
	!endif

	!if &seq &left %resp 2 "MS"
		!goto iopt
	!endif

	1 next-window
	set $curline 6
	15 delete-next-character
	15 insert-space
	3 next-window
;	update-screen

	;no case problems!
	set %resp &low %resp

	!if &seq %resp "^m"

		; fetch the string to replace the suspect word with
		2 next-window
		previous-word
		set-mark
		end-of-word
		copy-region
		set %repstring $kill

		; delete the syspect word
		3 next-window
		set-mark
		end-of-word
		kill-region

		; adjust the case of the replacement word if needed
		!if &seq %upword TRUE
			set %repstring &cat &upper &left %repstring 1 &mid %repstring 2 255
		!endif

		; insert the replacement word
		insert-string %repstring
		update-screen
		set %offset &add &sub %offset &len %word &len %repstring
		!return
	!endif

	;skip just this occurence....
	!if &seq %resp "s"
		!return
	!endif

	;Ignore this mismatch and all like it
	!if &seq %resp "i"
		select-buffer "[ignore]"
		end-of-file
		insert-string %word
		select-buffer %cbuffer
		!return
	!endif

	;Replace this string with the default string
	!if &seq %resp "d"
*globalrep
		0 delete-next-word
		insert-string %defrep
		update-screen
		set %offset &add &sub %offset &len %word &len %repstring
		!return
	!endif

	;Replace this string with another.....
	!if &or &seq %resp "c" &seq %resp "g"
		set $discmd TRUE
		set %repstring ""
		!if &seq %resp "g"
			set %repstring "Globally "
		!endif
		!if &seq %defflag ""
			set %repstring @&cat %repstring "Replace with: "
		!else
			set %repstring @&cat &cat &cat %repstring "Replace with[" %defrep "]: "
			!if &seq %repstring ""
				set %repstring %defrep
			!endif
		!endif
		set $discmd FALSE
		0 delete-next-word
		insert-string %repstring
		update-screen
		previous-word
		set %offset &add &sub %offset &len %word &len %repstring
		!if &seq %defflag ""
			select-buffer "[source]"
			end-of-file
			insert-string %word
			select-buffer "[replace]"
			end-of-file
			;if it is a global replace, add this marker
			!if &seq %resp "g"
				insert-string &chr 19
			!endif
			insert-string %repstring
			select-buffer %cbuffer
		!endif
		!goto begopt
	!endif

	;if we are adding this word and it is not to upper case,
	;...lower case it
	!if &seq %resp "a"
		set %resp "u"
		set %word &lower %word
	!endif

	;Add this word to a user dictionary and ignore it
	!if &seq %resp "u"
		select-buffer "[ignore]"
		end-of-file
		insert-string %word
		select-buffer "[add]"
		end-of-file
		insert-string %word
		select-buffer %cbuffer
		set %addflag TRUE
		!return
	!endif

	;Abort the spell check run
	!if &or &seq %resp "" &seq %resp "q"
		set %done ABORT
		!return
	!endif

	write-message ""
	!goto askopt
!endm

store-procedure update-word

	clear-message-line
	1 next-window		;skip to the dialog window
	set $curline 3		;update the current word & default
	3 redraw-display
	set $curcol 21
	20 delete-next-character
	&sub 20 &len %word insert-space
	insert-string %word
	set $curline 4
	set $curcol 21
	20 delete-next-character
	&sub 20 &len %defrep insert-space
	insert-string %defrep
!endm

store-procedure cleanup
;	Add the requested user words to a user dictionary

	!if &seq %addflag TRUE
		!if &seq %userlist ""
			set $discmd TRUE
			set %userlist @"User dictionary name: "
			set $discmd FALSE
		!endif
		write-message "[Updating User Dictionary]"
	!force	find-file %userlist
		set %bdict $cbufname
		select-buffer "[add]"
		beginning-of-file
		set-mark
		end-of-file
		kill-region
		select-buffer %bdict
		end-of-file
		yank
		delete-blank-lines
		save-file
	!endif

	select-buffer "[ignore]"
	unmark-buffer
	select-buffer "[add]"
	unmark-buffer
	select-buffer "[source]"
	unmark-buffer
	select-buffer "[replace]"
	unmark-buffer
	select-buffer "[suggestions]"
	unmark-buffer
	select-buffer "Dialog Window"
	unmark-buffer

	select-buffer %cbuffer
	beginning-of-file

!endm

store-procedure upstat
;	update the dialog window stats

	1 next-window
	beginning-of-file
	set $curcol 44
	&len %cfnum delete-previous-character
	insert-string %cfnum
	set $curcol 48
	&len %tfnum delete-previous-character
	insert-string %tfnum
	set $curcol 61
	&len %cwnum delete-previous-character
	insert-string %cwnum
	set $curcol 67
	&len %twnum delete-previous-character
	insert-string %twnum
	3 next-window
!endm

;	init for spell check run

	add-global-mode "black"
	add-global-mode "WHITE"
	add-mode "blue"
	add-mode "WHITE"

!force	find-file "spell.lst"
	!if &not &seq $status TRUE
		write-message "[No file to scan]~n"
		exit-emacs
	!endif
	write-message "[Preparing to Scan]"

	select-buffer "[source]"
	unmark-buffer
	select-buffer "[replace]"
	delete-buffer "[source]"
	unmark-buffer
	select-buffer "[add]"
	delete-buffer "[replace]"
	unmark-buffer
	select-buffer "[ignore]"
	delete-buffer "[add]"
	unmark-buffer
	select-buffer "[add]"
	delete-buffer "[ignore]"
	select-buffer "[source]"
	newline
	select-buffer "[replace]"
	select-buffer "[ignore]"
	newline

	set $discmd FALSE
	set %oldmflag $modeflag
	set %oldwchars $wchars
	set $wchars "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'"
	set $modeflag FALSE
	set %slist "spell.lst"
	set %userlist ""
	set %done FALSE
	set %cfile ""
	set %cbuffer ""
	set %lastline -1
	set %addflag FALSE
	delete-other-windows
	select-buffer "spell.lst"
	beginning-of-file

	;init data for the dialog window
	set %cfnum 0
	set %tfnum 0
*nxtfile
!force	search-forward "-1~n"
	!if &seq $status TRUE
		set %tfnum &add %tfnum 1
		!goto nxtfile
	!endif
	set %cwnum 0
	end-of-file
	set %twnum &sub &sub &div &sub $curline 1 2 %tfnum 1
	beginning-of-file

	;set up the dialog window
	1 split-current-window
	5 resize-window
	add-mode "red"
	select-buffer "Dialog Window"
	beginning-of-file
	set-mark
	end-of-file
	kill-region
	insert-string "MicroSPELL 2.0 spell scan         File #    /      Word      /     ~n"
	insert-string "               File: ~n"
	insert-string "       Suspect word:                        (S)kip         (C)hange word~n"
	insert-string "Default Replacement:                        (I)gnore       (D)efault replace~n"
	insert-string "                                            (A)dd word     (G)lobal change~n"
	insert-string "                                Add word as (U)pper case   (Q)uit"
	beginning-of-file
	next-window
	split-current-window
	4 resize-window
	add-mode yellow
	select-buffer [suggestions]
	next-window
	add-mode blue
	clear-message-line

	!while &seq %done FALSE
		run getnext
		!if &seq %done FALSE
			doopt
		!endif
	!endwhile

	!if &seq %done "ABORT"
		;abort and discard?
		!if &not &seq %rcspell TRUE
			print "Save Modified File(Y)?"
			set %resp &gtcmd
			!if &or &seq %resp "y" &seq %resp "Y"
				print "[File Saved]           ~n"
			!else
				unmark-buffer
				run cleanup
				print "[Spell check discarded]~n"
				exit-emacs
			!endif
		!endif

		;edit up the spell.lst file so we could continue..
		select-buffer "spell.lst"
		2 previous-line
		set-mark
		beginning-of-file
		kill-region
		insert-string &cat &cat "-1~n" %cfile "~n"
		save-file
		select-buffer %cbuffer
		run cleanup
		write-message "[Spell check ABORTED]"
		!if &not &seq %rcspell TRUE
			set $discmd TRUE
			save-file
			set $gflags &band $gflags &bnot 2
			update-screen
			exit-emacs
		!endif
		set $modeflag %oldmflag
		set $wchars %oldwchars
		add-global-mode blue
	!else
		run cleanup
		;MACHINE DEPENDANT!!!!!!!!!!!!
		!if &seq $sres ""
			shell-command "rm spell.lst"
			shell-command "rm suggest.tmp"
		!else
			shell-command "del spell.lst"
			shell-command "del suggest.tmp"
		!endif
		set $gflags &band $gflags &bnot 2
		write-message "[Spell check run complete]~n"
		set $discmd TRUE
		!if &not &seq %rcspell TRUE
			print "Save Modified File(Y)?"
			set %resp &gtcmd
			!if &or &seq %resp "y" &seq %resp "Y"
				save-file
				print "[File Saved]           ~n"
			!else
				unmark-buffer
				print "[Spell check discarded]~n"
			!endif
			exit-emacs
		!endif
		set $modeflag %oldmflag
		set $wchars %oldwchars
		add-global-mode blue
	!endif
	set $discmd TRUE
!return
