/* SPFONTLD - load binary font table into SPFONT program */

#include <stdio.h>
#include <alloc.h>
#include <string.h>
#include <fcntl.h>
#include <sys\stat.h>

#define MAXFONTS	8
#define CHARSPERFONT	224
#define MAXCHARHEIGHT	16

struct fontinfo
	{
	char anchor[8];
	unsigned int fonttablesize;
	char fonttablevalid;
	} ;

main(int ac, char *av[])
	{
	int comfd, fntfd;
	struct fontinfo finfo;
	unsigned int infoaddr;
	long infopointer;
	struct stat fntstat;
	unsigned fontsize;
	char *fonttable;

	comfd = fntfd = -1;
	if (ac != 3)
		{
		fprintf(stderr, "usage: SPFONTLD comfile fontfile\n");
		exit(1);
		}

	if ((comfd = open(av[1], O_RDWR|O_BINARY)) < 0)
		{
		fprintf(stderr, "can't open SPFONT com file: %s\n", av[1]);
		exit(2);
		}
	lseek(comfd, 3L, SEEK_SET);	/* skip "jmp Init" */
	if (read(comfd, &infoaddr, sizeof(int)) != sizeof(int))
		{
		fprintf(stderr, "can't read SPFONT com file\n");
		exit(3);
		}
	infopointer = (long)(infoaddr - 0x100);	/* since ORG'ed at 100h */
	lseek(comfd, infopointer, SEEK_SET);
	if (read(comfd, &finfo, sizeof(struct fontinfo)) != sizeof(struct fontinfo))
		{
		fprintf(stderr, "can't read SPFONT com file\n");
		exit(3);
		}
	if (memcmp(finfo.anchor, "<SPFONT>", 8) != 0)
		{
		fprintf(stderr, "wrong format for SPFONT com file\n");
		exit(3);
		}

	if ((fntfd = open(av[2], O_RDONLY|O_BINARY)) < 0)
		{
		fprintf(stderr, "can't open SPFONT font file: %s\n", av[2]);
		exit(4);
		}
	fstat(fntfd, &fntstat);
	fontsize = fntstat.st_size;
	if ((fontsize % (MAXFONTS*CHARSPERFONT)) != 0)
		{
		fprintf(stderr, "SPFONT font file is wrong size\n");
		exit(5);
		}
	if (finfo.fonttablesize != fontsize)
		{
		fprintf(stderr, "wrong font table size for SPFONT com file\n");
		exit(3);
		}
	if ((fonttable = malloc(fontsize)) == NULL)
		{
		fprintf(stderr, "cannot allocate font table\n");
		exit(3);
		}
	if (read(fntfd, fonttable, fontsize) != fontsize)
		{
		fprintf(stderr, "can't read SPFONT font file");
		exit(5);
		}
	close(fntfd);

	finfo.fonttablevalid = 0xff;
	lseek(comfd, infopointer, SEEK_SET);
	if (write(comfd, &finfo, sizeof(struct fontinfo)) != sizeof(struct fontinfo))
		{
		fprintf(stderr, "can't write SPFONT com file\n");
		exit(3);
		}
	if (write(comfd, fonttable, fontsize) != fontsize)
		{
		fprintf(stderr, "can't write SPFONT com file\n");
		exit(3);
		}
	close(comfd);

	fprintf(stderr, "Font table loaded.\n");
	exit(0);
	}
